/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import org.zkoss.idom.Attribute;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.metainfo.NamespaceParser;
import org.zkoss.zk.ui.metainfo.NativeInfo;
import org.zkoss.zk.ui.metainfo.PageDefinition;

public class ClientBinderCommandParser
implements NamespaceParser {
    private static String SCRIPT = "zkbind.Binder.%1s(this,%2s)";

    public boolean isMatched(String nsURI) {
        return this.isNative(nsURI) || this.isClient(nsURI) || "".equals(nsURI);
    }

    private boolean isClient(String nsURI) {
        return "client".equals(nsURI) || "http://www.zkoss.org/2005/zk/client".equals(nsURI);
    }

    private boolean isNative(String nsURI) {
        return "native".equals(nsURI) || "http://www.zkoss.org/2005/zk/native".equals(nsURI);
    }

    public boolean parse(Attribute attr, ComponentInfo compInfo, PageDefinition pgdef) throws Exception {
        if (!(compInfo instanceof NativeInfo) && "".equals(attr.getNamespaceURI())) {
            return false;
        }
        String name = attr.getLocalName();
        String value = attr.getValue();
        if (Events.isValid((String)name)) {
            if (value.startsWith("@command(")) {
                String subValue = value.substring(9, value.lastIndexOf(41));
                Object[] strings = subValue.split(",");
                this.addAttribute(compInfo, attr, name, String.format(SCRIPT, "postCommand", Strings.join((Object[])strings)));
                return true;
            }
            if (value.startsWith("@global-command(")) {
                String subValue = value.substring(16, value.lastIndexOf(41));
                Object[] strings = subValue.split(",");
                this.addAttribute(compInfo, attr, name, String.format(SCRIPT, "postGlobalCommand", Strings.join((Object[])strings)));
                return true;
            }
        }
        return false;
    }

    private void addAttribute(ComponentInfo compInfo, Attribute attr, String name, String value) {
        if (compInfo instanceof NativeInfo || this.isNative(attr.getNamespaceURI())) {
            compInfo.addProperty(name, value, null);
        } else {
            compInfo.addWidgetListener(name, value, null);
        }
    }

    public int getPriority() {
        return 10000;
    }
}

