/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.portlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import org.zkoss.lang.SystemException;
import org.zkoss.util.logging.Log;
import org.zkoss.web.portlet.PortletServletContext;
import org.zkoss.web.portlet.ServletPortletDispatcher;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.util.resource.ExtendletContext;

public class Portlets {
    private static final Log log = Log.lookup(Portlets.class);
    public static final int OVERWRITE_URI = 0;
    public static final int IGNORE_PARAM = 1;
    public static final int APPEND_PARAM = 2;

    public static final void include(PortletContext ctx, RenderRequest request, RenderResponse response, String uri, Map params, int mode) throws IOException, PortletException {
        PortletRequestDispatcher disp = Portlets.getRequestDispatcher(ctx, uri, params, mode);
        if (disp == null) {
            throw new PortletException("No dispatcher available to include " + uri);
        }
        disp.include(request, response);
    }

    public static final PortletRequestDispatcher getRequestDispatcher(PortletContext ctx, String uri, Map params, int mode) throws PortletException {
        return new ParsedURI(ctx, uri).getRequestDispatcher(params, mode);
    }

    public static final URL getResource(PortletContext ctx, String uri) throws MalformedURLException {
        return new ParsedURI(ctx, uri).getResource();
    }

    public static final InputStream getResourceAsStream(PortletContext ctx, String uri) {
        return new ParsedURI(ctx, uri).getResourceAsStream();
    }

    private static final ServletContext getServletContext(PortletContext ctx) {
        return PortletServletContext.getInstance(ctx);
    }

    public static final String generateURI(String uri, Map params, int mode) {
        return Servlets.generateURI(uri, params, mode);
    }

    private static class ParsedURI {
        private PortletContext _prtctx;
        private ServletContext _svlctx;
        private ExtendletContext _extctx;
        private String _uri;

        private ParsedURI(PortletContext ctx, String uri) {
            if (uri != null && uri.length() > 0 && uri.charAt(0) == '~') {
                String ctxroot;
                int j = uri.indexOf(47, 1);
                if (j >= 0) {
                    ctxroot = "/" + uri.substring(1, j);
                    this._uri = uri.substring(j);
                } else {
                    ctxroot = "/" + uri.substring(1);
                    this._uri = "/";
                }
                ServletContext svlctx = Portlets.getServletContext(ctx);
                this._extctx = Servlets.getExtendletContext(svlctx, ctxroot.substring(1));
                if (this._extctx == null) {
                    this._svlctx = svlctx;
                    this._svlctx = this._svlctx.getContext(ctxroot);
                    if (this._svlctx == null) {
                        throw new SystemException("Context not found or not visible to " + ctx + ": " + ctxroot);
                    }
                }
            } else {
                this._prtctx = ctx;
                this._uri = uri;
            }
        }

        private PortletRequestDispatcher getRequestDispatcher(Map params, int mode) {
            if (this._extctx == null && this._svlctx == null && this._prtctx == null) {
                return null;
            }
            String uri = Portlets.generateURI(this._uri, params, mode);
            if (this._prtctx != null) {
                return this._prtctx.getRequestDispatcher(uri);
            }
            RequestDispatcher rd = this._svlctx != null ? this._svlctx.getRequestDispatcher(uri) : this._extctx.getRequestDispatcher(uri);
            return ServletPortletDispatcher.getInstance(rd);
        }

        private URL getResource() throws MalformedURLException {
            return this._prtctx != null ? this._prtctx.getResource(this._uri) : (this._svlctx != null ? this._svlctx.getResource(this._uri) : (this._extctx != null ? this._extctx.getResource(this._uri) : null));
        }

        private InputStream getResourceAsStream() {
            return this._prtctx != null ? this._prtctx.getResourceAsStream(this._uri) : (this._svlctx != null ? this._svlctx.getResourceAsStream(this._uri) : (this._extctx != null ? this._extctx.getResourceAsStream(this._uri) : null));
        }
    }
}

