/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zel;

import java.beans.FeatureDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import org.zkoss.zel.ELClass;
import org.zkoss.zel.ELContext;
import org.zkoss.zel.ELException;
import org.zkoss.zel.ELResolver;
import org.zkoss.zel.MethodNotFoundException;
import org.zkoss.zel.PropertyNotFoundException;
import org.zkoss.zel.PropertyNotWritableException;
import org.zkoss.zel.Util;

public class StaticFieldELResolver
extends ELResolver {
    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof ELClass && property instanceof String) {
            context.setPropertyResolved(base, property);
            Class<?> clazz = ((ELClass)base).getKlass();
            String name = (String)property;
            Exception exception = null;
            try {
                Field field = clazz.getField(name);
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers)) {
                    return field.get(null);
                }
            }
            catch (IllegalArgumentException e) {
                exception = e;
            }
            catch (IllegalAccessException e) {
                exception = e;
            }
            catch (NoSuchFieldException e) {
                exception = e;
            }
            catch (SecurityException e) {
                exception = e;
            }
            String msg = Util.message(context, "staticFieldELResolver.notFound", name, clazz.getName());
            if (exception == null) {
                throw new PropertyNotFoundException(msg);
            }
            throw new PropertyNotFoundException(msg, exception);
        }
        return null;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof ELClass && property instanceof String) {
            Class<?> clazz = ((ELClass)base).getKlass();
            String name = (String)property;
            throw new PropertyNotWritableException(Util.message(context, "staticFieldELResolver.notWriteable", name, clazz.getName()));
        }
    }

    @Override
    public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof ELClass && method instanceof String) {
            context.setPropertyResolved(base, method);
            Class<?> clazz = ((ELClass)base).getKlass();
            String methodName = (String)method;
            if ("<init>".equals(methodName)) {
                Constructor<?> match = Util.findConstructor(clazz, paramTypes, params);
                Object[] parameters = Util.buildParameters(match.getParameterTypes(), match.isVarArgs(), params);
                Object result = null;
                try {
                    result = match.newInstance(parameters);
                }
                catch (IllegalArgumentException e) {
                    throw new ELException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ELException(e);
                }
                catch (InstantiationException e) {
                    throw new ELException(e);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    Util.handleThrowable(cause);
                    throw new ELException(cause);
                }
                return result;
            }
            Method match = Util.findMethod(clazz, methodName, paramTypes, params);
            int modifiers = match.getModifiers();
            if (!Modifier.isStatic(modifiers)) {
                throw new MethodNotFoundException(Util.message(context, "staticFieldELResolver.methodNotFound", methodName, clazz.getName()));
            }
            Object[] parameters = Util.buildParameters(match.getParameterTypes(), match.isVarArgs(), params);
            Object result = null;
            try {
                result = match.invoke(null, parameters);
            }
            catch (IllegalArgumentException e) {
                throw new ELException(e);
            }
            catch (IllegalAccessException e) {
                throw new ELException(e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                Util.handleThrowable(cause);
                throw new ELException(cause);
            }
            return result;
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof ELClass && property instanceof String) {
            context.setPropertyResolved(base, property);
            Class<?> clazz = ((ELClass)base).getKlass();
            String name = (String)property;
            Exception exception = null;
            try {
                Field field = clazz.getField(name);
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers)) {
                    return field.getType();
                }
            }
            catch (IllegalArgumentException e) {
                exception = e;
            }
            catch (NoSuchFieldException e) {
                exception = e;
            }
            catch (SecurityException e) {
                exception = e;
            }
            String msg = Util.message(context, "staticFieldELResolver.notFound", name, clazz.getName());
            if (exception == null) {
                throw new PropertyNotFoundException(msg);
            }
            throw new PropertyNotFoundException(msg, exception);
        }
        return null;
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof ELClass && property instanceof String) {
            context.setPropertyResolved(base, property);
        }
        return true;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return String.class;
    }
}

