/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.idom.impl;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;
import org.zkoss.idom.DOMException;
import org.zkoss.idom.Document;
import org.zkoss.idom.Group;
import org.zkoss.idom.Item;
import org.zkoss.idom.Namespaceable;
import org.zkoss.idom.impl.DOMImplementation;
import org.zkoss.idom.impl.EmptyNamedNodeMap;
import org.zkoss.xml.Locator;
import org.zkoss.xml.Nodes;

public abstract class AbstractItem
implements Item,
Node,
Serializable,
Cloneable {
    private static final long serialVersionUID = 20060622L;
    private Group _parent;
    private Locator _loc;
    private Map<String, Object> _usrdta;

    protected AbstractItem() {
    }

    protected static boolean match(Namespaceable vtx, String namespace, String name, Pattern ptn, int mode) {
        String val;
        if (name != null) {
            String string = val = (mode & 4) != 0 ? vtx.getTagName() : vtx.getLocalName();
            if ((mode & 1) != 0 ? !ptn.matcher(val).matches() : ((mode & 2) != 0 ? !name.equalsIgnoreCase(val) : !name.equals(val))) {
                return false;
            }
        }
        if (namespace != null) {
            String string = val = (mode & 8) != 0 ? vtx.getNamespace().getPrefix() : vtx.getNamespace().getURI();
            if (!namespace.equals(val)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void setName(String name) {
        throw new DOMException(15, this._loc);
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public void setText(String text) {
        throw new DOMException(15, this._loc);
    }

    @Override
    public Document getDocument() {
        for (Group v = this._parent; v != null; v = v.getParent()) {
            if (!(v instanceof Document)) continue;
            return (Document)v;
        }
        return null;
    }

    @Override
    public Item detach() {
        if (this._parent != null) {
            this._parent.getChildren().remove(this);
            assert (this._parent == null);
        }
        return this;
    }

    @Override
    public final Group getParent() {
        return this._parent;
    }

    @Override
    public void setParent(Group parent) {
        this._parent = parent;
    }

    @Override
    public final Locator getLocator() {
        return this._loc;
    }

    @Override
    public final void setLocator(Locator loc) {
        this._loc = loc;
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public String getNodeValue() {
        return this.getText();
    }

    @Override
    public void setNodeValue(String nodeValue) {
        this.setText(nodeValue);
    }

    @Override
    public org.w3c.dom.Document getOwnerDocument() {
        return this.getDocument();
    }

    @Override
    public final Node cloneNode(boolean deep) {
        if (!deep) {
            throw new DOMException(9, "always deep", this._loc);
        }
        return (Node)this.clone();
    }

    @Override
    public final Node getParentNode() {
        return (Node)((Object)this.getParent());
    }

    @Override
    public final Node getPreviousSibling() {
        if (this._parent == null) {
            return null;
        }
        List<Item> list = this._parent.getChildren();
        int j = list.indexOf(this);
        if (j < 0) {
            throw new DOMException(3, "internal error", this._loc);
        }
        return j == 0 ? null : (Node)((Object)list.get(j - 1));
    }

    @Override
    public final Node getNextSibling() {
        if (this._parent == null) {
            return null;
        }
        List<Item> list = this._parent.getChildren();
        int j = list.indexOf(this);
        if (j < 0) {
            throw new DOMException(3, "internal error", this._loc);
        }
        return j == list.size() - 1 ? null : (Node)((Object)list.get(j + 1));
    }

    @Override
    public NodeList getChildNodes() {
        return Nodes.EMPTY_NODELIST;
    }

    @Override
    public Node getFirstChild() {
        return null;
    }

    @Override
    public Node getLastChild() {
        return null;
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) {
        throw new DOMException(3, this._loc);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) {
        throw new DOMException(3, this._loc);
    }

    @Override
    public Node removeChild(Node oldChild) {
        throw new DOMException(3, this._loc);
    }

    @Override
    public Node appendChild(Node newChild) {
        throw new DOMException(3, this._loc);
    }

    @Override
    public final void normalize() {
        throw new DOMException(9, this._loc);
    }

    @Override
    public final boolean isSupported(String feature, String version) {
        return DOMImplementation.THE.hasFeature(feature, version);
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public String getLocalName() {
        return this.getName();
    }

    @Override
    public void setPrefix(String prefix) {
        throw new DOMException(15, this._loc);
    }

    @Override
    public NamedNodeMap getAttributes() {
        return EmptyNamedNodeMap.THE;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public String getBaseURI() {
        return null;
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        throw new UnsupportedOperationException("DOM Level 3");
    }

    @Override
    public String getTextContent() throws DOMException {
        throw new UnsupportedOperationException("DOM Level 3");
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        throw new UnsupportedOperationException("DOM Level 3");
    }

    @Override
    public boolean isSameNode(Node other) {
        throw new UnsupportedOperationException("DOM Level 3");
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        throw new UnsupportedOperationException("DOM Level 3");
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        throw new UnsupportedOperationException("DOM Level 3");
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        throw new UnsupportedOperationException("DOM Level 3");
    }

    @Override
    public boolean isEqualNode(Node arg) {
        throw new UnsupportedOperationException("DOM Level 3");
    }

    @Override
    public Object getFeature(String feature, String version) {
        return null;
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        if (handler != null) {
            throw new UnsupportedOperationException("DOM Level 3");
        }
        if (this._usrdta == null) {
            this._usrdta = new LinkedHashMap<String, Object>();
        }
        return this._usrdta.put(key, data);
    }

    @Override
    public Object getUserData(String key) {
        return this._usrdta != null ? this._usrdta.get(key) : null;
    }

    public final boolean equals(Object o) {
        return this == o;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    @Override
    public Object clone() {
        try {
            AbstractItem v = (AbstractItem)super.clone();
            v._parent = null;
            return v;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }
}

