/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.html;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.zkoss.xml.XMLs;

public class HTMLs {
    private static final Set<String> _txtstyles;
    private static final Set<String> _orphans;
    private static char[] IMMUNE_JAVASCRIPT;
    private static final String[] hex;

    public static final void appendAttribute(StringBuffer sb, String name, String val) {
        if (val != null && val.length() != 0) {
            sb.append(' ').append(name).append("=\"").append(XMLs.encodeAttribute(val)).append('\"');
        }
    }

    public static final void appendAttribute(StringBuffer sb, String name, String val, boolean emptyIgnored) {
        if (!emptyIgnored || val != null && val.length() != 0) {
            sb.append(' ').append(name).append("=\"").append(val != null ? XMLs.encodeAttribute(val) : null).append('\"');
        }
    }

    public static final void appendAttribute(StringBuffer sb, String name, int val) {
        sb.append(' ').append(name).append("=\"").append(val).append('\"');
    }

    public static final void appendAttribute(StringBuffer sb, String name, long val) {
        sb.append(' ').append(name).append("=\"").append(val).append('\"');
    }

    public static final void appendAttribute(StringBuffer sb, String name, double val) {
        sb.append(' ').append(name).append("=\"").append(val).append('\"');
    }

    public static final void appendAttribute(StringBuffer sb, String name, short val) {
        sb.append(' ').append(name).append("=\"").append(val).append('\"');
    }

    public static final void appendAttribute(StringBuffer sb, String name, boolean val) {
        sb.append(' ').append(name).append("=\"").append(val).append('\"');
    }

    public static final void appendStyle(StringBuffer sb, String name, String val) {
        if (val != null && val.length() != 0) {
            sb.append(name).append(':').append(val).append(';');
        }
    }

    public static final int getSubstyleIndex(String style, String substyle) {
        if (style == null || substyle == null) {
            throw new IllegalArgumentException("null");
        }
        if (substyle.length() == 0) {
            throw new IllegalArgumentException("empty substyle");
        }
        int j = 0;
        int len = style.length();
        while (true) {
            String nm;
            int l;
            int k = -1;
            for (l = j; l < len; ++l) {
                char cc = style.charAt(l);
                if (k < 0 && cc == ':') {
                    k = l;
                    continue;
                }
                if (cc == ';') break;
            }
            if ((nm = (k >= 0 ? style.substring(j, k) : style.substring(j, l)).trim()).equals(substyle)) {
                return j;
            }
            if (l >= len) {
                return -1;
            }
            j = l + 1;
        }
    }

    public static final String getSubstyleValue(String style, int j) {
        int l;
        int len = style.length();
        int k = -1;
        for (l = j; l < len; ++l) {
            char cc = style.charAt(l);
            if (k < 0 && cc == ':') {
                k = l;
                continue;
            }
            if (cc == ';') break;
        }
        return k < 0 ? "" : style.substring(k + 1, l).trim();
    }

    public static final String getTextRelevantStyle(String style) {
        if (style == null) {
            return null;
        }
        if (style.length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(64);
        int j = 0;
        int len = style.length();
        while (true) {
            String nm;
            int l;
            int k = -1;
            for (l = j; l < len; ++l) {
                char cc = style.charAt(l);
                if (k < 0 && cc == ':') {
                    k = l;
                    continue;
                }
                if (cc == ';') break;
            }
            if ((nm = (k >= 0 ? style.substring(j, k) : style.substring(j, l)).trim()).startsWith("font") || nm.startsWith("text") || _txtstyles.contains(nm)) {
                sb.append(l < len ? style.substring(j, l + 1) : style.substring(j));
            }
            if (l >= len) {
                return sb.toString();
            }
            j = l + 1;
        }
    }

    public static final boolean isOrphanTag(String tagname) {
        return _orphans.contains(tagname.toLowerCase(Locale.ENGLISH));
    }

    private static boolean containsCharacter(char c, char[] array) {
        for (char ch : array) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }

    private static String toHex(char c) {
        return Integer.toHexString(c);
    }

    private static String getHexForNonAlphanumeric(char c) {
        if (c < '\u00ff') {
            return hex[c];
        }
        return HTMLs.toHex(c);
    }

    public static String encodeJavaScript(String input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            sb.append(HTMLs.encodeCharacter(IMMUNE_JAVASCRIPT, Character.valueOf(c)));
        }
        return sb.toString();
    }

    public static String encodeCharacter(char[] immune, Character c) {
        if (HTMLs.containsCharacter(c.charValue(), immune)) {
            return "" + c;
        }
        String hex = HTMLs.getHexForNonAlphanumeric(c.charValue());
        if (hex == null) {
            return "" + c;
        }
        String temp = Integer.toHexString(c.charValue());
        if (c.charValue() < '\u0100') {
            String pad = "00".substring(temp.length());
            return "\\x" + pad + temp.toUpperCase();
        }
        String pad = "0000".substring(temp.length());
        return "\\u" + pad + temp.toUpperCase();
    }

    static {
        String[] txts = new String[]{"color", "background-color", "background", "white-space"};
        _txtstyles = new HashSet<String>();
        int j = txts.length;
        while (--j >= 0) {
            _txtstyles.add(txts[j]);
        }
        _orphans = new HashSet<String>(29);
        String[] orphans = new String[]{"area", "base", "basefont", "bgsound", "br", "col", "embed", "hr", "img", "input", "isindex", "keygen", "link", "meta", "plaintext", "spacer", "wbr"};
        j = orphans.length;
        while (--j >= 0) {
            _orphans.add(orphans[j]);
        }
        IMMUNE_JAVASCRIPT = new char[]{',', '.', '_'};
        hex = new String[256];
        for (char c = '\u0000'; c < '\u00ff'; c = (char)(c + '\u0001')) {
            HTMLs.hex[c] = c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' ? null : HTMLs.toHex(c).intern();
        }
    }
}

