/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util.media;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.zkoss.lang.Strings;
import org.zkoss.mesg.MCommon;
import org.zkoss.util.logging.Log;

public class ContentTypes {
    private static final Log log = Log.lookup(ContentTypes.class);
    private static final Map<String, String> _fmt2ct = new HashMap<String, String>(64);
    private static final Map<String, String> _ct2fmt = new HashMap<String, String>(64);

    protected ContentTypes() {
    }

    public static final boolean isBinary(String ctype) {
        return ctype != null && ctype.length() > 0 && !ctype.startsWith("text/") && ctype.indexOf("script") < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getContentType(String format) {
        if (format == null) {
            return null;
        }
        format = format.trim().toLowerCase();
        while (true) {
            Map<String, String> map = _fmt2ct;
            synchronized (map) {
                String fmt2ct = _fmt2ct.get(format);
                if (fmt2ct != null) {
                    return fmt2ct;
                }
            }
            int j = format.indexOf(46);
            if (j < 0) {
                return null;
            }
            format = format.substring(j + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getFormat(String ctype) {
        String format;
        if (ctype == null) {
            throw new IllegalArgumentException();
        }
        ctype = ctype.trim().toLowerCase();
        Map<String, String> map = _ct2fmt;
        synchronized (map) {
            format = _ct2fmt.get(ctype);
        }
        if (format == null) {
            int j = ctype.indexOf(59);
            if (j >= 0) {
                ctype = ctype.substring(0, j);
                Map<String, String> map2 = _ct2fmt;
                synchronized (map2) {
                    format = _ct2fmt.get(ctype);
                }
            }
            if (format == null) {
                j = ctype.indexOf(47);
                format = j >= 0 ? ctype.substring(j + 1) : ctype;
            }
        }
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void put(String format, String ctype) {
        if (format == null || ctype == null) {
            throw new NullPointerException("format or ctype");
        }
        Map<String, String> map = _fmt2ct;
        synchronized (map) {
            _fmt2ct.put(format, ctype);
        }
        map = _ct2fmt;
        synchronized (map) {
            _ct2fmt.put(ctype, format);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean load(String flnm) {
        InputStream strm = ContentTypes.class.getResourceAsStream(flnm);
        if (strm == null) {
            return false;
        }
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(strm));
            while ((line = in.readLine()) != null) {
                int j = line.indexOf(61);
                if (j < 0) {
                    int k = Strings.skipWhitespaces(line, 0);
                    if (k >= line.length() || line.charAt(k) == '#') continue;
                    log.warning("Ignored error;  illgal format: " + line);
                    continue;
                }
                String format = line.substring(0, j).trim();
                String ctype = line.substring(j + 1).trim();
                if (format.length() == 0 || ctype.length() == 0) {
                    log.warning("Ignored error;  illgal format: " + line);
                    continue;
                }
                _fmt2ct.put(format, ctype);
                _ct2fmt.put(ctype, format);
            }
        }
        catch (IOException ex) {
            log.warning("Ingored error: Unable to read " + flnm, (Throwable)ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            try {
                strm.close();
            }
            catch (Throwable throwable) {}
        }
        return true;
    }

    static {
        String flnm = "/metainfo/org/zkoss/util/media/contentTypes.properties";
        if (!ContentTypes.load("/metainfo/org/zkoss/util/media/contentTypes.properties")) {
            log.warning(MCommon.FILE_NOT_FOUND, (Object)"/metainfo/org/zkoss/util/media/contentTypes.properties");
        }
        ContentTypes.load("/contentTypes.properties");
    }
}

