/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.util.CollectionsX;

public class Locales {
    private static final InheritableThreadLocal _thdLocale;
    private static final Map _founds;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static final Locale getCurrent() {
        Locale l = (Locale)_thdLocale.get();
        return l != null ? l : Locale.getDefault();
    }

    public static final boolean testCurrent(String lang, String country) {
        Locale l = Locales.getCurrent();
        return !(lang != null && !lang.equals(l.getLanguage()) || country != null && !country.equals(l.getCountry()));
    }

    public static final Locale setThreadLocal(Locale locale) {
        Locale old = (Locale)_thdLocale.get();
        _thdLocale.set(locale);
        return old;
    }

    public static final Locale getThreadLocal() {
        return (Locale)_thdLocale.get();
    }

    public static final Locale getLocale(String localeString, char separator) {
        if (localeString == null) {
            return null;
        }
        if (!$assertionsDisabled && localeString.equals("null")) {
            throw new AssertionError((Object)"No Locale called 'null'");
        }
        if (separator == '\u0000') {
            separator = (char)(localeString.indexOf(95) >= 0 ? 95 : 44);
        }
        LinkedList list = new LinkedList();
        CollectionsX.parse(list, localeString, separator);
        String lang = "";
        String cnt = "";
        String var = "";
        switch (list.size()) {
            case 0: {
                return null;
            }
            default: {
                if (!$assertionsDisabled && list.size() > 3) {
                    throw new AssertionError();
                }
                var = (String)list.get(2);
            }
            case 2: {
                cnt = (String)list.get(1);
                if (cnt.length() == 2) break;
                throw new IllegalArgumentException("Not a valid country: " + localeString);
            }
            case 1: 
        }
        lang = (String)list.get(0);
        if (lang.length() != 2) {
            throw new IllegalArgumentException("Not a valid language: " + localeString);
        }
        return Locales.getLocale(new Locale(lang, cnt, var));
    }

    public static final Locale getLocale(String localeString) {
        return Locales.getLocale(localeString, '\u0000');
    }

    public static final synchronized Locale getLocale(Locale locale) {
        Locale l = (Locale)_founds.get(locale);
        if (l != null) {
            return l;
        }
        _founds.put(locale, locale);
        return locale;
    }

    public static Locale getByFallback(Collection values, Locale locale) {
        if (values.contains(locale)) {
            return locale;
        }
        String lang = locale.getLanguage();
        String cnty = locale.getCountry();
        String var = locale.getVariant();
        if (var != null && var.length() > 0 && values.contains(locale = new Locale(lang, cnty))) {
            return locale;
        }
        if (cnty != null && cnty.length() > 0 && values.contains(locale = new Locale(lang, ""))) {
            return locale;
        }
        Locale rtn = null;
        Iterator it = values.iterator();
        while (it.hasNext()) {
            Locale l = (Locale)it.next();
            if (!l.getLanguage().equals(lang)) continue;
            if (var == null || var.length() == 0 || Objects.equals(l.getCountry(), cnty)) {
                return l;
            }
            if (rtn != null) continue;
            rtn = l;
        }
        return rtn;
    }

    public static int indexOfUnderline(String s, int j) {
        int k;
        int last = s.length() - 2;
        while ((k = s.indexOf(95, j)) >= 0 && k < last) {
            char cc = s.charAt(k + 1);
            if (cc >= 'a' && cc <= 'z' && (cc = s.charAt(k + 2)) >= 'a' && cc <= 'z' && ((cc = s.charAt(k + 3)) < 'a' || cc > 'z')) {
                return k;
            }
            j = k + 1;
        }
        return -1;
    }

    public static int indexOfUnderline(String s) {
        return Locales.indexOfUnderline(s, 0);
    }

    static {
        $assertionsDisabled = !Locales.class.desiredAssertionStatus();
        _thdLocale = new InheritableThreadLocal();
        _founds = new HashMap(17);
        Locale[] ls = new Locale[]{Locale.TRADITIONAL_CHINESE, Locale.SIMPLIFIED_CHINESE, Locale.ENGLISH, Locale.US, Locale.JAPAN, Locale.JAPANESE, Locale.KOREA, Locale.KOREAN, Locale.FRANCE, Locale.FRENCH, Locale.GERMANY, Locale.GERMAN, Locale.CHINESE};
        for (int j = 0; j < ls.length; ++j) {
            _founds.put(ls[j], ls[j]);
        }
    }
}

