/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.lang;

import java.util.HashMap;
import java.util.Map;

public class Primitives {
    private static final Map _prims = new HashMap(23);

    public static final boolean toPrimitive(Boolean obj) {
        return obj;
    }

    public static final Boolean toWrapper(boolean obj) {
        return obj;
    }

    public static final byte toPrimitive(Byte obj) {
        return obj;
    }

    public static final Byte toWrapper(byte obj) {
        return new Byte(obj);
    }

    public static final char toPrimitive(Character obj) {
        return obj.charValue();
    }

    public static final Character toWrapper(char obj) {
        return new Character(obj);
    }

    public static final double toPrimitive(Double obj) {
        return obj;
    }

    public static final Double toWrapper(double obj) {
        return new Double(obj);
    }

    public static final float toPrimitive(Float obj) {
        return obj.floatValue();
    }

    public static final Float toWrapper(float obj) {
        return new Float(obj);
    }

    public static final int toPrimitive(Integer obj) {
        return obj;
    }

    public static final Integer toWrapper(int obj) {
        return new Integer(obj);
    }

    public static final long toPrimitive(Long obj) {
        return obj;
    }

    public static final Long toWrapper(long obj) {
        return new Long(obj);
    }

    public static final short toPrimitive(Short obj) {
        return obj;
    }

    public static final Short toWrapper(short obj) {
        return new Short(obj);
    }

    public static final char getNotation(String className) {
        PrimInfo pi = (PrimInfo)_prims.get(className);
        return pi != null ? pi.code : (char)'\u0000';
    }

    public static final Object getDefaultValue(Class cls) {
        PrimInfo pi = (PrimInfo)_prims.get(cls.getName());
        return pi != null ? pi.defVal : null;
    }

    public static final Class toClass(String clsName) {
        PrimInfo pi = (PrimInfo)_prims.get(clsName);
        return pi != null ? pi.cls : null;
    }

    public static final Class toPrimitive(Class wrapper) {
        return (Class)_prims.get(wrapper);
    }

    public static final Class toWrapper(Class primitive) {
        if (!primitive.isPrimitive()) {
            return null;
        }
        if (primitive.equals(Void.TYPE)) {
            return Void.class;
        }
        return Primitives.getDefaultValue(primitive).getClass();
    }

    public static final boolean isPrimitive(String clsName) {
        return _prims.containsKey(clsName);
    }

    static {
        _prims.put("int", new PrimInfo(Integer.TYPE, new Integer(0), 'I'));
        _prims.put("boolean", new PrimInfo(Boolean.TYPE, Boolean.FALSE, 'Z'));
        _prims.put("short", new PrimInfo(Short.TYPE, new Short(0), 'S'));
        _prims.put("byte", new PrimInfo(Byte.TYPE, new Byte(0), 'B'));
        _prims.put("char", new PrimInfo(Character.TYPE, new Character('\u0000'), 'C'));
        _prims.put("long", new PrimInfo(Long.TYPE, new Long(0L), 'L'));
        _prims.put("double", new PrimInfo(Double.TYPE, new Double(0.0), 'D'));
        _prims.put("float", new PrimInfo(Float.TYPE, new Float(0.0f), 'F'));
        _prims.put("void", new PrimInfo(Void.TYPE, null, 'V'));
        _prims.put(Integer.class, Integer.TYPE);
        _prims.put(Boolean.class, Boolean.TYPE);
        _prims.put(Short.class, Short.TYPE);
        _prims.put(Byte.class, Byte.TYPE);
        _prims.put(Character.class, Character.TYPE);
        _prims.put(Long.class, Long.TYPE);
        _prims.put(Double.class, Double.TYPE);
        _prims.put(Float.class, Float.TYPE);
        _prims.put(Void.class, Void.TYPE);
    }

    private static class PrimInfo {
        private final Class cls;
        private final Object defVal;
        private final char code;

        private PrimInfo(Class cls, Object defVal, char code) {
            this.cls = cls;
            this.defVal = defVal;
            this.code = code;
        }
    }
}

