/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.stats.model;

import java.util.UUID;

public class RunStats {
    private long duration;
    private long timeInQueue = -1L;
    private int queueId;
    private long started;
    private long queued = System.currentTimeMillis();
    private String projectName;
    private String nodeName = "master";
    private final String uuid = UUID.randomUUID().toString();

    public RunStats() {
    }

    public RunStats(long duration, long timeInQueue, long started, long queued, String projectName) {
        this();
        this.duration = duration;
        this.timeInQueue = timeInQueue;
        this.started = started;
        this.queued = queued;
        this.projectName = projectName;
    }

    public RunStats(long duration, long timeInQueue, long started, long queued, String projectName, String nodeName) {
        this();
        this.duration = duration;
        this.timeInQueue = timeInQueue;
        this.started = started;
        this.queued = queued;
        this.projectName = projectName;
        this.nodeName = nodeName;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getStarted() {
        return this.started;
    }

    public void setStarted(long started) {
        this.started = started;
        this.timeInQueue = started - this.queued;
        if (this.timeInQueue < 0L) {
            this.timeInQueue = 0L;
        }
    }

    public long getQueued() {
        return this.queued;
    }

    public void setQueued(long queued) {
        this.queued = queued;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public long getTimeInQueue() {
        return this.timeInQueue;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public int getQueueId() {
        return this.queueId;
    }

    public void setQueueId(int queueId) {
        this.queueId = queueId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.duration ^ this.duration >>> 32);
        result = 31 * result + (this.nodeName == null ? 0 : this.nodeName.hashCode());
        result = 31 * result + (this.projectName == null ? 0 : this.projectName.hashCode());
        result = 31 * result + this.queueId;
        result = 31 * result + (int)(this.queued ^ this.queued >>> 32);
        result = 31 * result + (int)(this.started ^ this.started >>> 32);
        result = 31 * result + (int)(this.timeInQueue ^ this.timeInQueue >>> 32);
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RunStats other = (RunStats)obj;
        if (this.duration != other.duration) {
            return false;
        }
        if (this.nodeName == null ? other.nodeName != null : !this.nodeName.equals(other.nodeName)) {
            return false;
        }
        if (this.projectName == null ? other.projectName != null : !this.projectName.equals(other.projectName)) {
            return false;
        }
        if (this.queueId != other.queueId) {
            return false;
        }
        if (this.queued != other.queued) {
            return false;
        }
        if (this.started != other.started) {
            return false;
        }
        if (this.timeInQueue != other.timeInQueue) {
            return false;
        }
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }
}

