/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.stats;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.zeroturnaround.stats.ClusterStatisticsPlugin;
import org.zeroturnaround.stats.model.RunStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class StartCompleteListener
extends RunListener<Run> {
    private static final Logger log = Logger.getLogger(StartCompleteListener.class.getName());

    public void onCompleted(Run r, TaskListener listener) {
        super.onCompleted(r, listener);
        ClusterStatisticsPlugin plugin = ClusterStatisticsPlugin.getInstance();
        RunStats stats = plugin.getStatsData().popUnInitializedItem(r.getParent().getName());
        if (stats != null) {
            stats.setDuration(r.getDuration());
            stats.setStarted(r.getTimeInMillis());
            String nodeName = "master";
            try {
                EnvVars envVars = r.getEnvironment((TaskListener)new LogTaskListener(log, Level.INFO));
                nodeName = (String)envVars.get((Object)"NODE_NAME");
            }
            catch (IOException e) {
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            stats.setNodeName(nodeName);
            plugin.getStatsData().addToTenuredSpace(stats);
            try {
                plugin.cleanUp();
                plugin.maybeSave();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        } else {
            log.fine("Unable to find the task from the tasks for completed. Ignoring");
        }
    }

    public void onStarted(Run r, TaskListener listener) {
        super.onStarted(r, listener);
    }
}

