/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.TabbedPanel;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.TabbedPanelTab;

public class TabbedPanel2
extends TabbedPanel {
    private static final long serialVersionUID = 1L;
    private List<Component> fullTabList = new ArrayList<Component>();
    private List<Component> removedTabList = new ArrayList<Component>();
    private static final Icon PLUS_ICON = DisplayUtils.getScaledIcon(new ImageIcon(TabbedPanel2.class.getResource("/resource/icon/fugue/plus.png")));
    private Component hiddenComponent = new JLabel();
    private final Logger logger = Logger.getLogger(TabbedPanel2.class);
    private int prevTabIndex = -1;

    public TabbedPanel2() {
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TabbedPanel2.this.setCloseButtonStates();
                if (TabbedPanel2.this.getSelectedComponent() != null && TabbedPanel2.this.getSelectedComponent().equals(TabbedPanel2.this.hiddenComponent)) {
                    if (TabbedPanel2.this.prevTabIndex == TabbedPanel2.this.indexOfComponent(TabbedPanel2.this.hiddenComponent)) {
                        TabbedPanel2.this.setSelectedIndex(TabbedPanel2.this.prevTabIndex - 1);
                    } else {
                        TabbedPanel2.this.setSelectedIndex(TabbedPanel2.this.prevTabIndex);
                        TabbedPanel2.this.showHiddenTabPopup();
                    }
                } else {
                    TabbedPanel2.this.prevTabIndex = TabbedPanel2.this.getSelectedIndex();
                }
            }
        });
    }

    private void showHiddenTabPopup() {
        JPopupMenu menu = new JPopupMenu();
        if (this.getMousePosition() == null) {
            return;
        }
        Collections.sort(this.removedTabList, new Comparator<Component>(){

            @Override
            public int compare(Component o1, Component o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Component c : this.removedTabList) {
            if (!(c instanceof AbstractPanel)) continue;
            final AbstractPanel ap = (AbstractPanel)c;
            JMenuItem mi = new JMenuItem(ap.getName());
            mi.setIcon(ap.getIcon());
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TabbedPanel2.this.setVisible(ap, true);
                    ap.setTabFocus();
                }
            });
            menu.add(mi);
        }
        menu.show(this, this.getMousePosition().x, this.getMousePosition().y);
    }

    @Deprecated
    public TabbedPanel2 clone(TabbedPanel2 tabbedPanel) {
        TabbedPanel2 t = new TabbedPanel2();
        t.fullTabList = new ArrayList<Component>(tabbedPanel.fullTabList);
        t.removedTabList = new ArrayList<Component>(tabbedPanel.removedTabList);
        return t;
    }

    private void setCloseButtonStates() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component tabCom = this.getTabComponentAt(i);
            if (tabCom == null || !(tabCom instanceof TabbedPanelTab)) continue;
            TabbedPanelTab jp = (TabbedPanelTab)tabCom;
            jp.setEnabled(i == this.getSelectedIndex());
        }
    }

    public void pinVisibleTabs() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component tabCom = this.getTabComponentAt(i);
            if (tabCom == null || !(tabCom instanceof TabbedPanelTab) || !tabCom.isVisible()) continue;
            TabbedPanelTab jp = (TabbedPanelTab)tabCom;
            jp.setPinned(true);
            this.saveTabState(jp.getAbstractPanel());
        }
    }

    public void unpinTabs() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component tabCom = this.getTabComponentAt(i);
            if (tabCom == null || !(tabCom instanceof TabbedPanelTab) || !tabCom.isVisible()) continue;
            TabbedPanelTab jp = (TabbedPanelTab)tabCom;
            jp.setPinned(false);
            this.saveTabState(jp.getAbstractPanel());
        }
    }

    private String safeName(String str) {
        return str.replaceAll("[^A-Za-z0-9]", "");
    }

    private boolean isTabPinned(Component c) {
        boolean showByDefault = false;
        if (c instanceof AbstractPanel) {
            showByDefault = ((AbstractPanel)c).isShowByDefault();
        }
        return Model.getSingleton().getOptionsParam().getConfig().getBoolean("view.tab.pin." + this.safeName(c.getName()), showByDefault);
    }

    protected void saveTabState(AbstractPanel ap) {
        if (ap == null) {
            return;
        }
        Model.getSingleton().getOptionsParam().getConfig().setProperty("view.tab.pin." + this.safeName(ap.getName()), (Object)ap.isPinned());
        try {
            Model.getSingleton().getOptionsParam().getConfig().save();
        }
        catch (ConfigurationException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public boolean isTabVisible(Component c) {
        if (!this.fullTabList.contains(c)) {
            return false;
        }
        return !this.removedTabList.contains(c);
    }

    public void setVisible(Component c, boolean visible) {
        if (visible) {
            if (this.removedTabList.contains(c)) {
                if (c instanceof AbstractPanel) {
                    AbstractPanel panel = (AbstractPanel)c;
                    this.addTab(c.getName(), panel.getIcon(), panel, panel.isHideable(), true, panel.getTabIndex());
                } else {
                    int index;
                    for (index = this.fullTabList.indexOf(c); index >= 0 && (index <= 0 || this.removedTabList.contains(this.fullTabList.get(index - 1))); --index) {
                    }
                    this.addTab(c.getName(), null, c, true, true, index);
                }
                this.removedTabList.remove(c);
            }
        } else if (!this.removedTabList.contains(c)) {
            this.remove(c);
            this.removedTabList.add(c);
        }
        this.handleHiddenTabListTab();
    }

    @Override
    public void addTab(String title, Icon icon, Component c) {
        if (c instanceof AbstractPanel) {
            this.addTab((AbstractPanel)c);
        } else {
            this.addTab(title, icon, c, false, true, this.getTabCount());
        }
    }

    public void addTab(AbstractPanel panel) {
        boolean visible = !panel.isHideable() || this.isTabPinned(panel);
        this.addTab(panel.getName(), panel.getIcon(), panel, panel.isHideable(), visible, panel.getTabIndex());
    }

    public void addTab(String title, Icon icon, Component c, boolean hideable, boolean visible, int index) {
        if (c instanceof AbstractPanel) {
            ((AbstractPanel)c).setParent(this);
            ((AbstractPanel)c).setTabIndex(index);
            ((AbstractPanel)c).setHideable(hideable);
        }
        if (index == -1 || index > this.getTabCount()) {
            index = this.getTabCount();
        }
        if (icon instanceof ImageIcon) {
            icon = DisplayUtils.getScaledIcon((ImageIcon)icon);
        }
        super.insertTab(title, icon, c, c.getName(), index);
        if (!this.fullTabList.contains(c)) {
            this.fullTabList.add(c);
        }
        int pos = this.indexOfComponent(c);
        this.setTabComponentAt(pos, new TabbedPanelTab(this, title, icon, c, hideable, this.isTabPinned(c)));
        if (!visible) {
            this.setVisible(c, false);
        } else {
            this.removedTabList.remove(c);
        }
        this.handleHiddenTabListTab();
        if ((index == 0 || this.getTabCount() == 1) && this.indexOfComponent(c) != -1) {
            this.setSelectedComponent(c);
        }
    }

    private void handleHiddenTabListTab() {
        if (this.indexOfComponent(this.hiddenComponent) >= 0) {
            super.remove(this.hiddenComponent);
        }
        if (this.removedTabList.size() > 0) {
            super.addTab("", PLUS_ICON, this.hiddenComponent);
        }
    }

    public void setTabLocked(AbstractPanel panel, boolean lock) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            TabbedPanelTab jp;
            Component tabCom = this.getTabComponentAt(i);
            if (tabCom == null || !(tabCom instanceof TabbedPanelTab) || !tabCom.isVisible() || !panel.equals((jp = (TabbedPanelTab)tabCom).getAbstractPanel())) continue;
            jp.setLocked(!lock);
        }
    }

    @Override
    public void setIconAt(int index, Icon icon) {
        Component c;
        Component tabCom = this.getTabComponentAt(index);
        if (tabCom != null && tabCom instanceof JPanel && (c = ((JPanel)tabCom).getComponent(0)) != null && c instanceof JLabel) {
            ((JLabel)c).setIcon(icon);
        }
    }

    @Override
    public void setTitleAt(int index, String title) {
        Component tabCom = this.getTabComponentAt(index);
        if (tabCom != null && tabCom instanceof JPanel) {
            Component c = ((JPanel)tabCom).getComponent(0);
            if (c != null && c instanceof JLabel) {
                ((JLabel)c).setText(title);
            }
        } else {
            super.setTitleAt(index, title);
        }
    }

    public List<Component> getTabList() {
        return Collections.unmodifiableList(this.fullTabList);
    }

    public List<Component> getSortedTabList() {
        ArrayList<Component> copy = new ArrayList<Component>(this.fullTabList);
        Collections.sort(copy, new Comparator<Component>(){

            @Override
            public int compare(Component o1, Component o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return copy;
    }

    public void removeTab(AbstractPanel panel) {
        this.remove(panel);
        this.fullTabList.remove(panel);
        if (this.removedTabList.remove(panel)) {
            this.handleHiddenTabListTab();
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.removedTabList.clear();
        this.removedTabList.addAll(this.fullTabList);
        this.handleHiddenTabListTab();
    }

    public void setShowTabNames(boolean showTabNames) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            String title = showTabNames ? this.getComponentAt(i).getName() : "";
            this.setTitleAt(i, title);
        }
    }

    @Override
    protected void fireStateChanged() {
        super.fireStateChanged();
        Component comp = this.getSelectedComponent();
        if (comp instanceof AbstractPanel) {
            ((AbstractPanel)comp).tabSelected();
        }
    }

    public boolean isActive() {
        return false;
    }

    public List<AbstractPanel> getPanels() {
        ArrayList<AbstractPanel> panels = new ArrayList<AbstractPanel>();
        for (Component component : this.fullTabList) {
            if (!(component instanceof AbstractPanel)) continue;
            panels.add((AbstractPanel)component);
        }
        return panels;
    }

    public List<AbstractPanel> getVisiblePanels() {
        List<AbstractPanel> panels = this.getPanels();
        Iterator<AbstractPanel> it = panels.iterator();
        while (it.hasNext()) {
            if (!this.removedTabList.contains(it.next())) continue;
            it.remove();
        }
        return panels;
    }

    public void setVisiblePanels(List<AbstractPanel> panels) {
        this.removeAll();
        for (Component component : this.fullTabList) {
            AbstractPanel ap;
            if (panels.contains(component)) {
                this.setVisible(component, true);
                continue;
            }
            if (!(component instanceof AbstractPanel) || TabbedPanel2.canHidePanel(ap = (AbstractPanel)component)) continue;
            this.setVisible(component, true);
        }
        if (this.getSelectedComponent() == null && this.getTabCount() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public void setPanelsVisible(boolean visible) {
        for (Component component : this.fullTabList) {
            if (!(component instanceof AbstractPanel)) continue;
            AbstractPanel ap = (AbstractPanel)component;
            boolean canChangeVisibility = true;
            if (!visible) {
                canChangeVisibility = TabbedPanel2.canHidePanel(ap);
            }
            if (!canChangeVisibility) continue;
            this.setVisible(component, visible);
        }
    }

    private static boolean canHidePanel(AbstractPanel panel) {
        return panel.isHideable() && !panel.isPinned();
    }
}

