/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JCheckBoxTree
extends JTree {
    private static final long serialVersionUID = -4194122328392241790L;
    HashMap<TreePath, CheckedNode> nodesCheckingState;
    HashSet<TreePath> checkedPaths = new HashSet();

    public void addCheckChangeEventListener(CheckChangeEventListener listener) {
        this.listenerList.add(CheckChangeEventListener.class, listener);
    }

    public void removeCheckChangeEventListener(CheckChangeEventListener listener) {
        this.listenerList.remove(CheckChangeEventListener.class, listener);
    }

    void fireCheckChangeEvent(CheckChangeEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != CheckChangeEventListener.class) continue;
            ((CheckChangeEventListener)listeners[i + 1]).checkStateChanged(evt);
        }
    }

    @Override
    public void setModel(TreeModel newModel) {
        this.resetCheckingState(newModel != null ? (DefaultMutableTreeNode)newModel.getRoot() : null);
        super.setModel(newModel);
    }

    public TreePath[] getCheckedPaths() {
        return this.checkedPaths.toArray(new TreePath[this.checkedPaths.size()]);
    }

    public boolean isChecked(TreePath path) {
        CheckedNode cn = this.nodesCheckingState.get(path);
        return cn.isSelected;
    }

    public boolean isSelectedPartially(TreePath path) {
        CheckedNode cn = this.nodesCheckingState.get(path);
        return cn.isSelected && cn.hasChildren && !cn.allChildrenSelected;
    }

    private void resetCheckingState(DefaultMutableTreeNode rootNode) {
        this.nodesCheckingState = new HashMap();
        this.checkedPaths = new HashSet();
        if (rootNode == null) {
            return;
        }
        this.addSubtreeToCheckingStateTracking(rootNode);
    }

    private void addSubtreeToCheckingStateTracking(DefaultMutableTreeNode node) {
        Object[] path = node.getPath();
        TreePath tp = new TreePath(path);
        CheckedNode cn = new CheckedNode(false, node.getChildCount() > 0, false);
        this.nodesCheckingState.put(tp, cn);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.addSubtreeToCheckingStateTracking((DefaultMutableTreeNode)tp.pathByAddingChild(node.getChildAt(i)).getLastPathComponent());
        }
    }

    public JCheckBoxTree() {
        this.setToggleClickCount(0);
        CheckBoxCellRenderer cellRenderer = new CheckBoxCellRenderer();
        this.setCellRenderer(cellRenderer);
        DefaultTreeSelectionModel dtsm = new DefaultTreeSelectionModel(){
            private static final long serialVersionUID = -8190634240451667286L;

            @Override
            public void setSelectionPath(TreePath path) {
            }

            @Override
            public void addSelectionPath(TreePath path) {
            }

            @Override
            public void removeSelectionPath(TreePath path) {
            }

            @Override
            public void setSelectionPaths(TreePath[] pPaths) {
            }
        };
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                TreePath tp = JCheckBoxTree.this.getPathForLocation(arg0.getX(), arg0.getY());
                if (tp == null) {
                    return;
                }
                if (!JCheckBoxTree.this.nodesCheckingState.get((Object)tp).isCheckBoxEnabled) {
                    return;
                }
                boolean checkMode = !JCheckBoxTree.this.nodesCheckingState.get((Object)tp).isSelected;
                JCheckBoxTree.this.checkSubTree(tp, checkMode);
                JCheckBoxTree.this.updatePredecessorsWithCheckMode(tp, checkMode);
                JCheckBoxTree.this.fireCheckChangeEvent(new CheckChangeEvent(new Object()));
                JCheckBoxTree.this.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        this.setSelectionModel(dtsm);
    }

    protected void updatePredecessorsWithCheckMode(TreePath tp, boolean check) {
        TreePath parentPath = tp.getParentPath();
        if (parentPath == null) {
            return;
        }
        CheckedNode parentCheckedNode = this.nodesCheckingState.get(parentPath);
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)parentPath.getLastPathComponent();
        parentCheckedNode.allChildrenSelected = true;
        parentCheckedNode.isSelected = false;
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            TreePath childPath = parentPath.pathByAddingChild(parentNode.getChildAt(i));
            CheckedNode childCheckedNode = this.nodesCheckingState.get(childPath);
            if (!this.allSelected(childCheckedNode)) {
                parentCheckedNode.allChildrenSelected = false;
            }
            if (!childCheckedNode.isSelected) continue;
            parentCheckedNode.isSelected = true;
        }
        if (parentCheckedNode.isSelected) {
            this.checkedPaths.add(parentPath);
        } else {
            this.checkedPaths.remove(parentPath);
        }
        this.updatePredecessorsWithCheckMode(parentPath, check);
    }

    private boolean allSelected(CheckedNode checkedNode) {
        if (!checkedNode.isSelected) {
            return false;
        }
        if (checkedNode.hasChildren) {
            return checkedNode.allChildrenSelected;
        }
        return true;
    }

    public void checkSubTree(TreePath tp, boolean check) {
        CheckedNode cn = this.nodesCheckingState.get(tp);
        cn.isSelected = check;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.checkSubTree(tp.pathByAddingChild(node.getChildAt(i)), check);
        }
        cn.allChildrenSelected = check;
        if (check) {
            this.checkedPaths.add(tp);
        } else {
            this.checkedPaths.remove(tp);
        }
        this.updatePredecessorsAllChildrenSelectedState(tp);
    }

    public void expandAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    public void collapseAll() {
        for (int i = this.getRowCount(); i >= 0; --i) {
            this.collapseRow(i);
        }
    }

    public boolean isSelectedFully(TreePath path) {
        CheckedNode cn = this.nodesCheckingState.get(path);
        return this.allSelected(cn);
    }

    public void check(TreePath tp, boolean check) {
        CheckedNode cn = this.nodesCheckingState.get(tp);
        cn.isSelected = check;
        if (check) {
            this.checkedPaths.add(tp);
        } else {
            this.checkedPaths.remove(tp);
        }
        this.updatePredecessorsAllChildrenSelectedState(tp);
    }

    private void updatePredecessorsAllChildrenSelectedState(TreePath tp) {
        TreePath parentPath = tp.getParentPath();
        if (parentPath == null) {
            return;
        }
        CheckedNode parentCheckedNode = this.nodesCheckingState.get(parentPath);
        parentCheckedNode.allChildrenSelected = true;
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)parentPath.getLastPathComponent();
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            TreePath childPath = parentPath.pathByAddingChild(parentNode.getChildAt(i));
            CheckedNode childCheckedNode = this.nodesCheckingState.get(childPath);
            if (this.allSelected(childCheckedNode)) continue;
            parentCheckedNode.allChildrenSelected = false;
            break;
        }
        this.updatePredecessorsAllChildrenSelectedState(parentPath);
    }

    public void setCheckBoxEnabled(TreePath tp, boolean enabled) {
        this.nodesCheckingState.get((Object)tp).isCheckBoxEnabled = enabled;
        this.repaint();
    }

    public static void main(String[] params) {
        JFrame f = new JFrame();
        f.setSize(new Dimension(500, 500));
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.setSize(new Dimension(500, 500));
        f.getContentPane().add(p);
        JCheckBoxTree cbt = new JCheckBoxTree();
        cbt.setShowsRootHandles(true);
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(cbt);
        p.add((Component)scroll, "Center");
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Tech");
        DefaultMutableTreeNode db = new DefaultMutableTreeNode("Db");
        root.add(db);
        db.add(new DefaultMutableTreeNode("HypersonicSQL"));
        db.add(new DefaultMutableTreeNode("MsSQL"));
        db.add(new DefaultMutableTreeNode("MySQL"));
        db.add(new DefaultMutableTreeNode("Oracle"));
        db.add(new DefaultMutableTreeNode("PostgreSQL"));
        DefaultMutableTreeNode os = new DefaultMutableTreeNode("OS");
        root.add(os);
        os.add(new DefaultMutableTreeNode("Linux"));
        DefaultMutableTreeNode ws = new DefaultMutableTreeNode("WS");
        root.add(ws);
        DefaultTreeModel model = new DefaultTreeModel(root);
        cbt.setModel(model);
        f.setVisible(true);
    }

    private class CheckBoxCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private static final long serialVersionUID = -7341833835878991719L;
        JCheckBox checkBox;
        JLabel altLabel;

        public CheckBoxCellRenderer() {
            this.setLayout(new BorderLayout());
            this.checkBox = new JCheckBox();
            this.altLabel = new JLabel("");
            this.add((Component)this.checkBox, "Center");
            this.add((Component)this.altLabel, "East");
            this.setOpaque(false);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            TreePath tp = new TreePath(node.getPath());
            this.altLabel.setText(obj != null ? obj.toString() : "");
            this.altLabel.setForeground(UIManager.getColor(selected ? "Tree.selectionForeground" : "Tree.textForeground"));
            CheckedNode cn = JCheckBoxTree.this.nodesCheckingState.get(tp);
            if (cn == null) {
                this.checkBox.setVisible(false);
                return this;
            }
            if (cn.isCheckBoxEnabled) {
                this.checkBox.setSelected(cn.isSelected);
                this.checkBox.setOpaque(cn.isSelected && cn.hasChildren && !cn.allChildrenSelected);
                this.checkBox.setVisible(true);
                this.checkBox.setEnabled(true);
            } else {
                this.checkBox.setVisible(false);
                this.checkBox.setEnabled(false);
            }
            return this;
        }
    }

    public static interface CheckChangeEventListener
    extends EventListener {
        public void checkStateChanged(CheckChangeEvent var1);
    }

    public class CheckChangeEvent
    extends EventObject {
        private static final long serialVersionUID = -8100230309044193368L;

        public CheckChangeEvent(Object source) {
            super(source);
        }
    }

    private class CheckedNode {
        boolean isSelected;
        boolean hasChildren;
        boolean allChildrenSelected;
        boolean isCheckBoxEnabled = true;

        public CheckedNode(boolean isSelected_, boolean hasChildren_, boolean allChildrenSelected_) {
            this.isSelected = isSelected_;
            this.hasChildren = hasChildren_;
            this.allChildrenSelected = allChildrenSelected_;
        }
    }
}

