/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpStatusCode;
import org.zaproxy.zap.spider.filters.ParseFilter;

public class DefaultParseFilter
extends ParseFilter {
    public static final int MAX_RESPONSE_BODY_SIZE = 512000;
    private static final Pattern svnSQLiteFilenamePattern = Pattern.compile(".*/\\.svn/wc.db$");
    private static final Pattern svnXMLFilenamePattern = Pattern.compile(".*/\\.svn/entries$");
    private static final Pattern gitFilenamePattern = Pattern.compile(".*/\\.git/index$");

    @Override
    public boolean isFiltered(HttpMessage responseMessage) {
        try {
            String fullfilename = responseMessage.getRequestHeader().getURI().getPath();
            if (fullfilename == null) {
                fullfilename = "";
            }
            Matcher svnSQLiteFilenameMatcher = svnSQLiteFilenamePattern.matcher(fullfilename);
            Matcher svnXMLFilenameMatcher = svnXMLFilenamePattern.matcher(fullfilename);
            Matcher gitFilenameMatcher = gitFilenamePattern.matcher(fullfilename);
            if (svnSQLiteFilenameMatcher.find() || svnXMLFilenameMatcher.find() || gitFilenameMatcher.find()) {
                return false;
            }
        }
        catch (URIException e) {
            log.error((Object)e);
        }
        if (responseMessage.getResponseBody().length() > 512000) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource too large: " + responseMessage.getRequestHeader().getURI()));
            }
            return true;
        }
        if (HttpStatusCode.isRedirection(responseMessage.getResponseHeader().getStatusCode())) {
            return false;
        }
        if (!responseMessage.getResponseHeader().isText()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource is not text: " + responseMessage.getRequestHeader().getURI()));
            }
            return true;
        }
        return false;
    }
}

