/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.httpclient.URI;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.common.AbstractParam;
import org.zaproxy.zap.extension.api.ZapApiIgnore;
import org.zaproxy.zap.spider.DomainAlwaysInScopeMatcher;

public class SpiderParam
extends AbstractParam {
    private static final String SPIDER_MAX_DEPTH = "spider.maxDepth";
    private static final String SPIDER_THREAD = "spider.thread";
    private static final String SPIDER_POST_FORM = "spider.postform";
    private static final String SPIDER_PROCESS_FORM = "spider.processform";
    private static final String SPIDER_SKIP_URL = "spider.skipurl";
    private static final String SPIDER_REQUEST_WAIT = "spider.requestwait";
    private static final String SPIDER_PARSE_COMMENTS = "spider.parseComments";
    private static final String SPIDER_PARSE_ROBOTS_TXT = "spider.parseRobotsTxt";
    private static final String SPIDER_PARSE_SITEMAP_XML = "spider.parseSitemapXml";
    private static final String SPIDER_PARSE_SVN_ENTRIES = "spider.parseSVNentries";
    private static final String SPIDER_PARSE_GIT = "spider.parseGit";
    private static final String SPIDER_HANDLE_PARAMETERS = "spider.handleParameters";
    private static final String SPIDER_HANDLE_ODATA_PARAMETERS = "spider.handleODataParameters";
    private static final String DOMAIN_ALWAYS_IN_SCOPE_KEY = "spider.domainsAlwaysInScope";
    private static final String ALL_DOMAINS_ALWAYS_IN_SCOPE_KEY = "spider.domainsAlwaysInScope.domainAlwaysInScope";
    private static final String DOMAIN_ALWAYS_IN_SCOPE_VALUE_KEY = "name";
    private static final String DOMAIN_ALWAYS_IN_SCOPE_REGEX_KEY = "regex";
    private static final String DOMAIN_ALWAYS_IN_SCOPE_ENABLED_KEY = "enabled";
    private static final String CONFIRM_REMOVE_DOMAIN_ALWAYS_IN_SCOPE = "spider.confirmRemoveDomainAlwaysInScope";
    private static final String MAX_SCANS_IN_UI = "spider.maxScansInUI";
    private static final String SHOW_ADV_DIALOG = "spider.advDialog";
    private static final String MAX_DURATION = "spider.maxDuration";
    private static final String MAX_CHILDREN = "spider.maxChildren";
    private static final String SPIDER_SENDER_REFERER_HEADER = "spider.sendRefererHeader";
    private int maxDepth = 5;
    private int threadCount = 2;
    private boolean parseComments = true;
    private boolean parseRobotsTxt = true;
    private boolean parseSitemapXml = true;
    private boolean parseSVNentries = false;
    private boolean parseGit = false;
    private boolean processForm = true;
    private boolean postForm = false;
    private int requestWait = 200;
    private String skipURL = "";
    private Pattern patternSkipURL = null;
    private String userAgent = null;
    private HandleParametersOption handleParametersVisited = HandleParametersOption.USE_ALL;
    private boolean handleODataParametersVisited = false;
    private int maxDuration = 0;
    private int maxChildren;
    private List<DomainAlwaysInScopeMatcher> domainsAlwaysInScope = new ArrayList<DomainAlwaysInScopeMatcher>(0);
    private List<DomainAlwaysInScopeMatcher> domainsAlwaysInScopeEnabled = new ArrayList<DomainAlwaysInScopeMatcher>(0);
    private boolean confirmRemoveDomainAlwaysInScope;
    private int maxScansInUI = 5;
    private boolean showAdvancedDialog = false;
    private static final Logger log = Logger.getLogger(SpiderParam.class);
    private boolean sendRefererHeader = true;

    @Override
    protected void parse() {
        this.updateOptions();
        try {
            this.threadCount = this.getConfig().getInt(SPIDER_THREAD, 2);
        }
        catch (ConversionException e) {
            log.error((Object)("Error while parsing config file: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.maxDepth = this.getConfig().getInt(SPIDER_MAX_DEPTH, 5);
        }
        catch (ConversionException e) {
            log.error((Object)("Error while parsing config file: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.maxDuration = this.getConfig().getInt(MAX_DURATION, 0);
        }
        catch (ConversionException e) {
            log.error((Object)("Error while parsing config file: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.maxChildren = this.getConfig().getInt(MAX_CHILDREN, 0);
        }
        catch (ConversionException e) {
            log.error((Object)("Error while parsing config file: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.maxScansInUI = this.getConfig().getInt(MAX_SCANS_IN_UI, 5);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.showAdvancedDialog = this.getConfig().getBoolean(SHOW_ADV_DIALOG, false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.processForm = this.getConfig().getBoolean(SPIDER_PROCESS_FORM, false);
        }
        catch (ConversionException e) {
            log.error((Object)("Error while parsing config file: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.postForm = this.getConfig().getBoolean(SPIDER_POST_FORM, false);
        }
        catch (ConversionException e) {
            log.info((Object)"Warning while parsing config file: spider.postform was not in the expected format due to an upgrade. Converting  it!");
            if (!this.getConfig().getProperty(SPIDER_POST_FORM).toString().equals("0")) {
                this.getConfig().setProperty(SPIDER_POST_FORM, (Object)"true");
                this.postForm = true;
            }
            this.getConfig().setProperty(SPIDER_POST_FORM, (Object)"false");
            this.postForm = false;
        }
        try {
            this.requestWait = this.getConfig().getInt(SPIDER_REQUEST_WAIT, 200);
        }
        catch (ConversionException e) {
            log.error((Object)("Error while parsing config file: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.parseComments = this.getConfig().getBoolean(SPIDER_PARSE_COMMENTS, true);
        }
        catch (ConversionException e) {
            log.error((Object)("Error while parsing config file: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.parseRobotsTxt = this.getConfig().getBoolean(SPIDER_PARSE_ROBOTS_TXT, true);
        }
        catch (Exception e) {
            log.error((Object)("Error while parsing config file: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.parseSitemapXml = this.getConfig().getBoolean(SPIDER_PARSE_SITEMAP_XML, true);
        }
        catch (Exception e) {
            log.error((Object)("Error while parsing config file: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.parseSVNentries = this.getConfig().getBoolean(SPIDER_PARSE_SVN_ENTRIES, false);
        }
        catch (Exception e) {
            log.error((Object)("Error while parsing config file: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.parseGit = this.getConfig().getBoolean(SPIDER_PARSE_GIT, false);
        }
        catch (Exception e) {
            log.error((Object)("Error while parsing config file: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.setSkipURLString(this.getConfig().getString(SPIDER_SKIP_URL, ""));
        }
        catch (ConversionException e) {
            log.error((Object)("Error while parsing config file: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.setHandleParameters(HandleParametersOption.valueOf(this.getConfig().getString(SPIDER_HANDLE_PARAMETERS, HandleParametersOption.USE_ALL.toString())));
        }
        catch (ConversionException e) {
            log.error((Object)("Error while parsing config file: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.handleODataParametersVisited = this.getConfig().getBoolean(SPIDER_HANDLE_ODATA_PARAMETERS, false);
        }
        catch (ConversionException e) {
            log.error((Object)("Error while parsing config file: " + e.getMessage()), (Throwable)e);
        }
        this.loadDomainsAlwaysInScope();
        try {
            this.confirmRemoveDomainAlwaysInScope = this.getConfig().getBoolean(CONFIRM_REMOVE_DOMAIN_ALWAYS_IN_SCOPE, true);
        }
        catch (ConversionException e) {
            log.error((Object)("Error while loading the confirm \"domain always in scope\" remove option: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.sendRefererHeader = this.getConfig().getBoolean(SPIDER_SENDER_REFERER_HEADER, true);
        }
        catch (ConversionException e) {
            log.error((Object)("Error while parsing config file: " + e.getMessage()), (Throwable)e);
            this.sendRefererHeader = true;
        }
    }

    private void updateOptions() {
        String oldDomainsInScope = "spider.scope";
        if (this.getConfig().containsKey("spider.scope")) {
            this.migrateOldDomainsInScopeOption(this.getConfig().getString("spider.scope", ""));
            this.getConfig().clearProperty("spider.scope");
        }
    }

    private void migrateOldDomainsInScopeOption(String oldDomainsInScope) {
        List<DomainAlwaysInScopeMatcher> domainsInScope = SpiderParam.convertOldDomainsInScopeOption(oldDomainsInScope);
        if (!domainsInScope.isEmpty()) {
            this.setDomainsAlwaysInScope(domainsInScope);
        }
    }

    private static List<DomainAlwaysInScopeMatcher> convertOldDomainsInScopeOption(String oldDomainsInScope) {
        String[] names;
        if (oldDomainsInScope == null || oldDomainsInScope.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DomainAlwaysInScopeMatcher> domainsInScope = new ArrayList<DomainAlwaysInScopeMatcher>();
        for (String name : names = oldDomainsInScope.split(";")) {
            String domain = name.trim();
            if (domain.isEmpty()) continue;
            if (domain.contains("*")) {
                domain = domain.replace(".", "\\.").replace("+", "\\+").replace("*", ".*?");
                try {
                    Pattern pattern = Pattern.compile(domain, 2);
                    domainsInScope.add(new DomainAlwaysInScopeMatcher(pattern));
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)("Failed to migrate a domain always in scope, name: " + name), (Throwable)e);
                }
                continue;
            }
            domainsInScope.add(new DomainAlwaysInScopeMatcher(domain));
        }
        domainsInScope.trimToSize();
        return domainsInScope;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
        this.getConfig().setProperty(SPIDER_MAX_DEPTH, (Object)Integer.toString(this.maxDepth));
    }

    @Deprecated
    public String getScopeText() {
        StringBuilder scopeTextStringBuilder = new StringBuilder("");
        for (DomainAlwaysInScopeMatcher domainInScope : this.domainsAlwaysInScope) {
            if (domainInScope.isRegex()) continue;
            scopeTextStringBuilder.append(domainInScope.getValue()).append(';');
        }
        return scopeTextStringBuilder.toString();
    }

    @Deprecated
    public String getScope() {
        StringBuilder scopeTextStringBuilder = new StringBuilder();
        for (DomainAlwaysInScopeMatcher domainInScope : this.domainsAlwaysInScope) {
            if (domainInScope.isRegex()) {
                scopeTextStringBuilder.append("\\Q").append(domainInScope.getValue()).append("\\E");
            } else {
                scopeTextStringBuilder.append(domainInScope.getValue());
            }
            scopeTextStringBuilder.append('|');
        }
        if (scopeTextStringBuilder.length() != 0) {
            scopeTextStringBuilder.append("(");
            scopeTextStringBuilder.replace(scopeTextStringBuilder.length() - 1, scopeTextStringBuilder.length() - 1, ")$");
        }
        return scopeTextStringBuilder.toString();
    }

    @Deprecated
    public void setScopeString(String scope) {
        this.setDomainsAlwaysInScope(SpiderParam.convertOldDomainsInScopeOption(scope));
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int thread) {
        this.threadCount = thread;
        this.getConfig().setProperty(SPIDER_THREAD, (Object)Integer.toString(this.threadCount));
    }

    public boolean isPostForm() {
        return this.postForm;
    }

    public void setPostForm(boolean postForm) {
        this.postForm = postForm;
        this.getConfig().setProperty(SPIDER_POST_FORM, (Object)Boolean.toString(postForm));
    }

    public boolean isProcessForm() {
        return this.processForm;
    }

    public void setProcessForm(boolean processForm) {
        this.processForm = processForm;
        this.getConfig().setProperty(SPIDER_PROCESS_FORM, (Object)Boolean.toString(processForm));
    }

    public void setSkipURLString(String skipURL) {
        this.skipURL = skipURL;
        this.getConfig().setProperty(SPIDER_SKIP_URL, (Object)this.skipURL);
        this.parseSkipURL(this.skipURL);
    }

    public String getSkipURLString() {
        return this.skipURL;
    }

    public boolean isSkipURL(URI uri) {
        if (this.patternSkipURL == null || uri == null) {
            return false;
        }
        String sURI = uri.toString();
        return this.patternSkipURL.matcher(sURI).find();
    }

    private void parseSkipURL(String skipURL) {
        this.patternSkipURL = null;
        if (skipURL == null || skipURL.equals("")) {
            return;
        }
        skipURL = skipURL.replaceAll("\\.", "\\\\.");
        skipURL = skipURL.replaceAll("\\*", ".*?").replaceAll("(\\s+$)|(^\\s+)", "");
        skipURL = "\\A(" + skipURL.replaceAll("\\s+", "|") + ")";
        this.patternSkipURL = Pattern.compile(skipURL, 10);
    }

    public int getRequestWaitTime() {
        return this.requestWait;
    }

    public void setRequestWaitTime(int requestWait) {
        this.requestWait = requestWait;
        this.getConfig().setProperty(SPIDER_REQUEST_WAIT, (Object)Integer.toString(requestWait));
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean isParseComments() {
        return this.parseComments;
    }

    public void setParseComments(boolean parseComments) {
        this.parseComments = parseComments;
        this.getConfig().setProperty(SPIDER_PARSE_COMMENTS, (Object)Boolean.toString(parseComments));
    }

    public boolean isParseRobotsTxt() {
        return this.parseRobotsTxt;
    }

    public boolean isParseSitemapXml() {
        return this.parseSitemapXml;
    }

    public boolean isParseSVNEntries() {
        return this.parseSVNentries;
    }

    public boolean isParseGit() {
        return this.parseGit;
    }

    public void setParseRobotsTxt(boolean parseRobotsTxt) {
        this.parseRobotsTxt = parseRobotsTxt;
        this.getConfig().setProperty(SPIDER_PARSE_ROBOTS_TXT, (Object)Boolean.toString(parseRobotsTxt));
    }

    public void setParseSitemapXml(boolean parseSitemapXml) {
        this.parseSitemapXml = parseSitemapXml;
        this.getConfig().setProperty(SPIDER_PARSE_SITEMAP_XML, (Object)Boolean.toString(parseSitemapXml));
    }

    public void setParseSVNEntries(boolean parseSVNentries) {
        this.parseSVNentries = parseSVNentries;
        this.getConfig().setProperty(SPIDER_PARSE_SVN_ENTRIES, (Object)Boolean.toString(parseSVNentries));
    }

    public void setParseGit(boolean parseGit) {
        this.parseGit = parseGit;
        this.getConfig().setProperty(SPIDER_PARSE_GIT, (Object)Boolean.toString(parseGit));
    }

    public HandleParametersOption getHandleParameters() {
        return this.handleParametersVisited;
    }

    public void setHandleParameters(HandleParametersOption handleParametersVisited) {
        this.handleParametersVisited = handleParametersVisited;
        this.getConfig().setProperty(SPIDER_HANDLE_PARAMETERS, (Object)handleParametersVisited.toString());
    }

    public void setHandleParameters(String handleParametersVisited) {
        this.handleParametersVisited = HandleParametersOption.valueOf(handleParametersVisited);
        this.getConfig().setProperty(SPIDER_HANDLE_PARAMETERS, (Object)this.handleParametersVisited.toString());
    }

    public boolean isHandleODataParametersVisited() {
        return this.handleODataParametersVisited;
    }

    public void setHandleODataParametersVisited(boolean handleODataParametersVisited) {
        this.handleODataParametersVisited = handleODataParametersVisited;
        this.getConfig().setProperty(SPIDER_HANDLE_ODATA_PARAMETERS, (Object)Boolean.toString(handleODataParametersVisited));
    }

    @ZapApiIgnore
    public List<DomainAlwaysInScopeMatcher> getDomainsAlwaysInScope() {
        return this.domainsAlwaysInScope;
    }

    @ZapApiIgnore
    public List<DomainAlwaysInScopeMatcher> getDomainsAlwaysInScopeEnabled() {
        return this.domainsAlwaysInScopeEnabled;
    }

    public void setDomainsAlwaysInScope(List<DomainAlwaysInScopeMatcher> domainsAlwaysInScope) {
        if (domainsAlwaysInScope == null || domainsAlwaysInScope.isEmpty()) {
            ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_DOMAINS_ALWAYS_IN_SCOPE_KEY);
            this.domainsAlwaysInScope = Collections.emptyList();
            this.domainsAlwaysInScopeEnabled = Collections.emptyList();
            return;
        }
        this.domainsAlwaysInScope = new ArrayList<DomainAlwaysInScopeMatcher>(domainsAlwaysInScope);
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_DOMAINS_ALWAYS_IN_SCOPE_KEY);
        int size = domainsAlwaysInScope.size();
        ArrayList<DomainAlwaysInScopeMatcher> enabledExcludedDomains = new ArrayList<DomainAlwaysInScopeMatcher>(size);
        for (int i = 0; i < size; ++i) {
            String elementBaseKey = "spider.domainsAlwaysInScope.domainAlwaysInScope(" + i + ").";
            DomainAlwaysInScopeMatcher excludedDomain = domainsAlwaysInScope.get(i);
            this.getConfig().setProperty(elementBaseKey + DOMAIN_ALWAYS_IN_SCOPE_VALUE_KEY, (Object)excludedDomain.getValue());
            this.getConfig().setProperty(elementBaseKey + DOMAIN_ALWAYS_IN_SCOPE_REGEX_KEY, (Object)excludedDomain.isRegex());
            this.getConfig().setProperty(elementBaseKey + DOMAIN_ALWAYS_IN_SCOPE_ENABLED_KEY, (Object)excludedDomain.isEnabled());
            if (!excludedDomain.isEnabled()) continue;
            enabledExcludedDomains.add(excludedDomain);
        }
        enabledExcludedDomains.trimToSize();
        this.domainsAlwaysInScopeEnabled = enabledExcludedDomains;
    }

    private void loadDomainsAlwaysInScope() {
        List fields = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(ALL_DOMAINS_ALWAYS_IN_SCOPE_KEY);
        this.domainsAlwaysInScope = new ArrayList<DomainAlwaysInScopeMatcher>(fields.size());
        ArrayList<DomainAlwaysInScopeMatcher> domainsInScopeEnabled = new ArrayList<DomainAlwaysInScopeMatcher>(fields.size());
        for (HierarchicalConfiguration sub : fields) {
            String value = sub.getString(DOMAIN_ALWAYS_IN_SCOPE_VALUE_KEY, "");
            if ("".equals(value)) {
                log.warn((Object)"Failed to read an spider domain in scope entry, required value is empty.");
            }
            DomainAlwaysInScopeMatcher excludedDomain = null;
            boolean regex = sub.getBoolean(DOMAIN_ALWAYS_IN_SCOPE_REGEX_KEY, false);
            if (regex) {
                try {
                    Pattern pattern = DomainAlwaysInScopeMatcher.createPattern(value);
                    excludedDomain = new DomainAlwaysInScopeMatcher(pattern);
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)("Failed to read an spider domain in scope entry with regex: " + value), (Throwable)e);
                }
            } else {
                excludedDomain = new DomainAlwaysInScopeMatcher(value);
            }
            if (excludedDomain == null) continue;
            excludedDomain.setEnabled(sub.getBoolean(DOMAIN_ALWAYS_IN_SCOPE_ENABLED_KEY, true));
            this.domainsAlwaysInScope.add(excludedDomain);
            if (!excludedDomain.isEnabled()) continue;
            domainsInScopeEnabled.add(excludedDomain);
        }
        domainsInScopeEnabled.trimToSize();
        this.domainsAlwaysInScopeEnabled = domainsInScopeEnabled;
    }

    @ZapApiIgnore
    public boolean isConfirmRemoveDomainAlwaysInScope() {
        return this.confirmRemoveDomainAlwaysInScope;
    }

    @ZapApiIgnore
    public void setConfirmRemoveDomainAlwaysInScope(boolean confirmRemove) {
        this.confirmRemoveDomainAlwaysInScope = confirmRemove;
        this.getConfig().setProperty(CONFIRM_REMOVE_DOMAIN_ALWAYS_IN_SCOPE, (Object)this.confirmRemoveDomainAlwaysInScope);
    }

    public int getMaxScansInUI() {
        return this.maxScansInUI;
    }

    public void setMaxScansInUI(int maxScansInUI) {
        this.maxScansInUI = maxScansInUI;
        this.getConfig().setProperty(MAX_SCANS_IN_UI, (Object)this.maxScansInUI);
    }

    public boolean isShowAdvancedDialog() {
        return this.showAdvancedDialog;
    }

    public void setShowAdvancedDialog(boolean showAdvancedDialog) {
        this.showAdvancedDialog = showAdvancedDialog;
        this.getConfig().setProperty(SHOW_ADV_DIALOG, (Object)this.showAdvancedDialog);
    }

    public boolean isSendRefererHeader() {
        return this.sendRefererHeader;
    }

    public void setSendRefererHeader(boolean send) {
        if (send == this.sendRefererHeader) {
            return;
        }
        this.sendRefererHeader = send;
        this.getConfig().setProperty(SPIDER_SENDER_REFERER_HEADER, (Object)this.sendRefererHeader);
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    public void setMaxDuration(int maxDuration) {
        this.maxDuration = maxDuration;
        this.getConfig().setProperty(MAX_DURATION, (Object)maxDuration);
    }

    public int getMaxChildren() {
        return this.maxChildren;
    }

    public void setMaxChildren(int maxChildren) {
        this.maxChildren = maxChildren;
        this.getConfig().setProperty(MAX_CHILDREN, (Object)maxChildren);
    }

    public static enum HandleParametersOption {
        IGNORE_COMPLETELY,
        IGNORE_VALUE,
        USE_ALL;


        public String getName() {
            switch (this) {
                case IGNORE_COMPLETELY: {
                    return Constant.messages.getString("spider.options.value.handleparameters.ignoreAll");
                }
                case IGNORE_VALUE: {
                    return Constant.messages.getString("spider.options.value.handleparameters.ignoreValue");
                }
                case USE_ALL: {
                    return Constant.messages.getString("spider.options.value.handleparameters.useAll");
                }
            }
            return null;
        }
    }
}

