/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.uiutils;

import java.awt.EventQueue;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.View;

public class ExtensionUiUtils
extends ExtensionAdaptor
implements SessionChangedListener {
    public static final String NAME = "ExtensionUiUtils";
    private static final Logger LOGGER = Logger.getLogger(ExtensionUiUtils.class);

    public ExtensionUiUtils() {
        super(NAME);
        this.setOrder(200);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.addSessionListener(this);
        }
    }

    @Override
    public void sessionChanged(final Session session) {
        if (EventQueue.isDispatchThread()) {
            this.sessionChangedEventHandler(session);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionUiUtils.this.sessionChangedEventHandler(session);
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void sessionChangedEventHandler(Session session) {
        View.getSingleton().getMainFrame().getMainMenuBar().sessionChanged(session);
        View.getSingleton().getMainFrame().getMainToolbarPanel().sessionChanged(session);
    }

    @Override
    public void sessionAboutToChange(Session session) {
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    @Override
    public boolean isCore() {
        return true;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("uiutils.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }
}

