/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.stats;

import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;

public class StatsParam
extends AbstractParam {
    private static final Logger LOGGER = Logger.getLogger(StatsParam.class);
    private static final String STATS_BASE_KEY = "stats";
    private static final String IN_MEMORY_STATS_KEY = "stats.inmemory";
    private static final String STATSD_HOST_KEY = "stats.statsd.host";
    private static final String STATSD_PORT_KEY = "stats.statsd.port";
    private static final String STATSD_PREFIX_KEY = "stats.statsd.prefix";
    private static final int DEFAULT_STATSD_PORT = 8125;
    private static final String DEFAULT_STATSD_PREFIX = "zap";
    private boolean inMemory = true;
    private String statsdHost = "";
    private int statsdPort = 8125;
    private String statsdPrefix = "zap";

    public boolean isInMemoryEnabled() {
        return this.inMemory;
    }

    public void setInMemoryEnabled(boolean inMemory) {
        this.inMemory = inMemory;
        this.getConfig().setProperty(IN_MEMORY_STATS_KEY, (Object)inMemory);
    }

    public boolean isStatsdEnabled() {
        return this.statsdHost != null && this.statsdHost.length() > 0;
    }

    public String getStatsdHost() {
        return this.statsdHost;
    }

    public void setStatsdHost(String statsdHost) {
        this.statsdHost = statsdHost;
        this.getConfig().setProperty(STATSD_HOST_KEY, (Object)statsdHost);
    }

    public int getStatsdPort() {
        return this.statsdPort;
    }

    public void setStatsdPort(int statsdPort) {
        this.statsdPort = statsdPort;
        this.getConfig().setProperty(STATSD_PORT_KEY, (Object)statsdPort);
    }

    public String getStatsdPrefix() {
        return this.statsdPrefix;
    }

    public void setStatsdPrefix(String statsdPrefix) {
        this.statsdPrefix = statsdPrefix;
        this.getConfig().setProperty(STATSD_PREFIX_KEY, (Object)statsdPrefix);
    }

    @Override
    protected void parse() {
        try {
            this.inMemory = this.getConfig().getBoolean(IN_MEMORY_STATS_KEY, true);
            this.statsdHost = this.getConfig().getString(STATSD_HOST_KEY, "");
            this.statsdPort = this.getConfig().getInt(STATSD_PORT_KEY, 8125);
            this.statsdPrefix = this.getConfig().getString(STATSD_PREFIX_KEY, DEFAULT_STATSD_PREFIX);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

