/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import net.htmlparser.jericho.MasonTagTypes;
import net.htmlparser.jericho.MicrosoftTagTypes;
import net.htmlparser.jericho.PHPTagTypes;
import net.htmlparser.jericho.Source;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.pscan.OptionsPassiveScan;
import org.zaproxy.zap.extension.pscan.PassiveScanParam;
import org.zaproxy.zap.extension.pscan.PassiveScanner;
import org.zaproxy.zap.extension.pscan.PassiveScannerList;

public class PassiveScanThread
extends Thread
implements ProxyListener,
SessionChangedListener {
    private static final Logger logger = Logger.getLogger(PassiveScanThread.class);
    public static final int PROXY_LISTENER_ORDER = 5001;
    private OptionsPassiveScan options = null;
    private PassiveScannerList scannerList = null;
    private int currentId = 1;
    private int lastId = -1;
    private int mainSleep = 5000;
    private int postSleep = 200;
    private volatile boolean shutDown = false;
    private final ExtensionHistory extHist;
    private final ExtensionAlert extAlert;
    private final PassiveScanParam pscanOptions;
    private TableHistory historyTable = null;
    private HistoryReference href = null;
    private Session session;

    @Deprecated
    public PassiveScanThread(PassiveScannerList passiveScannerList, ExtensionHistory extHist, ExtensionAlert extensionAlert) {
        this(passiveScannerList, extHist, extensionAlert, new PassiveScanParam());
    }

    public PassiveScanThread(PassiveScannerList passiveScannerList, ExtensionHistory extHist, ExtensionAlert extensionAlert, PassiveScanParam pscanOptions) {
        super("ZAP-PassiveScanner");
        this.setDaemon(true);
        if (extensionAlert == null) {
            throw new IllegalArgumentException("Parameter extensionAlert must not be null.");
        }
        this.scannerList = passiveScannerList;
        MicrosoftTagTypes.register();
        PHPTagTypes.register();
        PHPTagTypes.PHP_SHORT.deregister();
        MasonTagTypes.register();
        this.extAlert = extensionAlert;
        this.extHist = extHist;
        this.pscanOptions = pscanOptions;
    }

    @Override
    public void run() {
        this.historyTable = Model.getSingleton().getDb().getTableHistory();
        this.session = Model.getSingleton().getSession();
        this.lastId = this.currentId = this.getLastHistoryId();
        while (!this.shutDown) {
            try {
                if (this.href != null || this.lastId > this.currentId) {
                    ++this.currentId;
                } else {
                    try {
                        Thread.sleep(this.mainSleep);
                        if (this.shutDown) {
                            return;
                        }
                        this.lastId = this.getLastHistoryId();
                    }
                    catch (InterruptedException e) {
                        try {
                            Thread.sleep(this.postSleep);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                try {
                    this.href = this.getHistoryReference(this.currentId);
                }
                catch (Exception e) {
                    if (this.shutDown) {
                        return;
                    }
                    logger.error((Object)("Failed to read record " + this.currentId + " from History table"), (Throwable)e);
                }
                if (this.href == null || this.pscanOptions.isScanOnlyInScope() && !this.session.isInScope(this.href)) continue;
                try {
                    HttpMessage msg = this.href.getHttpMessage();
                    String response = msg.getResponseHeader().toString() + msg.getResponseBody().toString();
                    Source src = new Source((CharSequence)response);
                    for (PassiveScanner scanner : this.scannerList.list()) {
                        try {
                            if (this.shutDown) {
                                return;
                            }
                            if (!scanner.isEnabled() || !scanner.appliesToHistoryType(this.href.getHistoryType())) continue;
                            scanner.setParent(this);
                            scanner.scanHttpRequestSend(msg, this.href.getHistoryId());
                            if (!msg.isResponseFromTargetHost()) continue;
                            scanner.scanHttpResponseReceive(msg, this.href.getHistoryId(), src);
                        }
                        catch (Throwable e) {
                            if (this.shutDown) {
                                return;
                            }
                            logger.error((Object)("Scanner " + scanner.getName() + " failed on record " + this.currentId + " from History table: " + this.href.getMethod() + " " + this.href.getURI()), e);
                        }
                    }
                }
                catch (Exception e) {
                    if (HistoryReference.getTemporaryTypes().contains(this.href.getHistoryType())) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Temporary record " + this.currentId + " no longer available:"), (Throwable)e);
                        continue;
                    }
                    logger.error((Object)("Parser failed on record " + this.currentId + " from History table"), (Throwable)e);
                }
            }
            catch (Exception e) {
                if (this.shutDown) {
                    return;
                }
                logger.error((Object)("Failed on record " + this.currentId + " from History table"), (Throwable)e);
            }
        }
    }

    private HistoryReference getHistoryReference(int historyReferenceId) {
        if (this.extHist != null) {
            return this.extHist.getHistoryReference(historyReferenceId);
        }
        try {
            return new HistoryReference(historyReferenceId);
        }
        catch (DatabaseException | HttpMalformedHeaderException e) {
            return null;
        }
    }

    private int getLastHistoryId() {
        return this.historyTable.lastIndex();
    }

    protected int getRecordsToScan() {
        return this.getLastHistoryId() - this.getLastScannedId();
    }

    private int getLastScannedId() {
        if (this.currentId > this.lastId) {
            return this.currentId - 1;
        }
        return this.currentId;
    }

    public void raiseAlert(int id, Alert alert) {
        if (this.shutDown) {
            return;
        }
        if (this.currentId != id) {
            logger.error((Object)("Alert id != currentId! " + id + " " + this.currentId));
        }
        alert.setSource(Alert.Source.PASSIVE);
        this.extAlert.alertFound(alert, this.href);
    }

    private void notifyHistoryItemChanged(HistoryReference historyReference) {
        if (this.extHist != null) {
            this.extHist.notifyHistoryItemChanged(historyReference);
        }
    }

    public void addTag(int id, String tag) {
        if (this.shutDown) {
            return;
        }
        try {
            if (!this.href.getTags().contains(tag)) {
                this.href.addTag(tag);
                this.notifyHistoryItemChanged(this.href);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public int getArrangeableListenerOrder() {
        return 5001;
    }

    @Override
    public boolean onHttpRequestSend(HttpMessage msg) {
        return true;
    }

    @Override
    public boolean onHttpResponseReceive(HttpMessage msg) {
        this.interrupt();
        return true;
    }

    @Override
    public void sessionChanged(Session session) {
        this.historyTable = Model.getSingleton().getDb().getTableHistory();
        this.href = null;
        this.lastId = this.currentId = this.historyTable.lastIndex();
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    public void shutdown() {
        this.shutDown = true;
    }

    @Override
    public void sessionAboutToChange(Session session) {
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }
}

