/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.keyboard;

import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.keyboard.KeyboardAPI;
import org.zaproxy.zap.extension.keyboard.KeyboardMapping;
import org.zaproxy.zap.extension.keyboard.KeyboardParam;
import org.zaproxy.zap.extension.keyboard.KeyboardShortcut;
import org.zaproxy.zap.extension.keyboard.OptionsKeyboardShortcutPanel;
import org.zaproxy.zap.utils.DesktopUtils;
import org.zaproxy.zap.view.ZapMenuItem;

public class ExtensionKeyboard
extends ExtensionAdaptor {
    private static final Logger logger = Logger.getLogger(ExtensionKeyboard.class);
    public static final String NAME = "ExtensionKeyboard";
    private OptionsKeyboardShortcutPanel optionsKeyboardPanel = null;
    private KeyboardParam keyboardParam = null;
    private ReferenceMap map = new ReferenceMap();
    private KeyboardAPI api = null;

    public ExtensionKeyboard() {
        this.initialize();
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(2000);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        if (this.getView() != null) {
            extensionHook.addOptionsParamSet(this.getKeyboardParam());
            extensionHook.getHookView().addOptionPanel(this.getOptionsKeyboardPanel());
            this.api = new KeyboardAPI(this);
            extensionHook.addApiImplementor(this.api);
        }
    }

    protected KeyboardParam getKeyboardParam() {
        if (this.keyboardParam == null) {
            this.keyboardParam = new KeyboardParam();
        }
        return this.keyboardParam;
    }

    @Override
    public void optionsLoaded() {
        if (View.isInitialised()) {
            logger.info((Object)"Initializing keyboard shortcuts");
            this.initAllMenuItems(View.getSingleton().getMainFrame().getMainMenuBar().getMenuFile());
            this.initAllMenuItems(View.getSingleton().getMainFrame().getMainMenuBar().getMenuEdit());
            this.initAllMenuItems(View.getSingleton().getMainFrame().getMainMenuBar().getMenuAnalyse());
            this.initAllMenuItems(View.getSingleton().getMainFrame().getMainMenuBar().getMenuReport());
            this.initAllMenuItems(View.getSingleton().getMainFrame().getMainMenuBar().getMenuTools());
            this.initAllMenuItems(View.getSingleton().getMainFrame().getMainMenuBar().getMenuView());
            this.initAllMenuItems(View.getSingleton().getMainFrame().getMainMenuBar().getMenuHelp());
        }
    }

    public void registerMenuItem(ZapMenuItem zme) {
        KeyboardMapping mapping = this.menuToMapping(zme);
        String identifier = mapping.getIdentifier();
        if (identifier != null) {
            this.map.put((Object)identifier, (Object)mapping);
        } else {
            logger.warn((Object)("ZapMenuItem \"" + mapping.getName() + "\" has a null identifier."));
        }
    }

    private void initAllMenuItems(JMenu menu) {
        for (Component c : menu.getMenuComponents()) {
            if (c instanceof ZapMenuItem) {
                this.registerMenuItem((ZapMenuItem)c);
                continue;
            }
            if (c instanceof JMenu) {
                this.initAllMenuItems((JMenu)c);
                continue;
            }
            if (!(c instanceof JMenuItem)) continue;
            JMenuItem menuItem = (JMenuItem)c;
            logger.debug((Object)("Unable to set accelerators on menu " + menuItem.getText()));
        }
    }

    private KeyboardMapping menuToMapping(ZapMenuItem menuItem) {
        KeyStroke ks = this.getKeyboardParam().getShortcut(menuItem.getIdenfifier());
        if (ks != null) {
            if (ks.getKeyCode() == 0) {
                logger.debug((Object)("Cleaning menu " + menuItem.getIdenfifier() + " accelerator"));
                menuItem.setAccelerator(null);
            } else {
                logger.debug((Object)("Setting menu " + menuItem.getIdenfifier() + " accelerator to " + ks.toString()));
                menuItem.setAccelerator(ks);
            }
        }
        return new KeyboardMapping(menuItem);
    }

    public List<KeyboardShortcut> getShortcuts() {
        return this.getShortcuts(false);
    }

    public List<KeyboardShortcut> getShortcuts(boolean reset) {
        if (View.isInitialised()) {
            ArrayList<KeyboardShortcut> kss = new ArrayList<KeyboardShortcut>();
            this.addAllMenuItems(kss, View.getSingleton().getMainFrame().getMainMenuBar().getMenuFile(), reset);
            this.addAllMenuItems(kss, View.getSingleton().getMainFrame().getMainMenuBar().getMenuEdit(), reset);
            this.addAllMenuItems(kss, View.getSingleton().getMainFrame().getMainMenuBar().getMenuAnalyse(), reset);
            this.addAllMenuItems(kss, View.getSingleton().getMainFrame().getMainMenuBar().getMenuReport(), reset);
            this.addAllMenuItems(kss, View.getSingleton().getMainFrame().getMainMenuBar().getMenuTools(), reset);
            this.addAllMenuItems(kss, View.getSingleton().getMainFrame().getMainMenuBar().getMenuView(), reset);
            this.addAllMenuItems(kss, View.getSingleton().getMainFrame().getMainMenuBar().getMenuHelp(), reset);
            return kss;
        }
        return null;
    }

    private void addAllMenuItems(List<KeyboardShortcut> kss, JMenu menu, boolean reset) {
        for (Component c : menu.getMenuComponents()) {
            if (c instanceof ZapMenuItem) {
                kss.add(this.menuToShortcut((ZapMenuItem)c, reset));
                continue;
            }
            if (c instanceof JMenu) {
                this.addAllMenuItems(kss, (JMenu)c, reset);
                continue;
            }
            if (!(c instanceof JMenuItem)) continue;
            JMenuItem menuItem = (JMenuItem)c;
            logger.debug((Object)("Unable to set accelerators on menu " + menuItem.getText()));
        }
    }

    private KeyboardShortcut menuToShortcut(ZapMenuItem menuItem, boolean reset) {
        if (reset) {
            return new KeyboardShortcut(menuItem.getIdenfifier(), menuItem.getText(), menuItem.getDefaultAccelerator());
        }
        KeyStroke ks = this.getKeyboardParam().getShortcut(menuItem.getIdenfifier());
        if (ks != null) {
            if (ks.getKeyCode() == 0) {
                logger.debug((Object)("Cleaning menu " + menuItem.getIdenfifier() + " accelerator"));
                menuItem.setAccelerator(null);
            } else {
                logger.debug((Object)("Setting menu " + menuItem.getIdenfifier() + " accelerator to " + ks.toString()));
                menuItem.setAccelerator(ks);
            }
        }
        return new KeyboardShortcut(menuItem.getIdenfifier(), menuItem.getText(), menuItem.getAccelerator());
    }

    public KeyStroke getShortcut(String identifier) {
        KeyboardMapping mapping = (KeyboardMapping)this.map.get((Object)identifier);
        if (mapping == null) {
            return null;
        }
        return mapping.getKeyStroke();
    }

    public void setShortcut(String identifier, KeyStroke ks) {
        KeyboardMapping mapping = (KeyboardMapping)this.map.get((Object)identifier);
        if (mapping == null) {
            logger.error((Object)("No mapping found for keyboard shortcut: " + identifier));
            return;
        }
        mapping.setKeyStroke(ks);
        this.getKeyboardParam().setShortcut(identifier, ks);
    }

    private OptionsKeyboardShortcutPanel getOptionsKeyboardPanel() {
        if (this.optionsKeyboardPanel == null) {
            this.optionsKeyboardPanel = new OptionsKeyboardShortcutPanel(this);
        }
        return this.optionsKeyboardPanel;
    }

    public void displayCheatsheetSortedByAction() {
        try {
            DesktopUtils.openUrlInBrowser(this.api.getCheatSheetActionURI());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void displayCheatsheetSortedByKey() {
        try {
            DesktopUtils.openUrlInBrowser(this.api.getCheatSheetKeyURI());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("keyboard.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }
}

