/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.posttable;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;

public class RequestPostTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -3239987476977015394L;
    private static final String[] columnNames = new String[]{Constant.messages.getString("http.panel.view.table.paramName"), Constant.messages.getString("http.panel.view.table.paramValue")};
    private static final Pattern pSeparator = Pattern.compile("([^=&]+)[=]([^=&]*)");
    private Vector<String[]> listPair = new Vector();
    private boolean editable = true;
    private boolean isChanged = false;
    private static final Logger logger = Logger.getLogger(RequestPostTableModel.class);

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.listPair.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        String[] cell = this.listPair.get(row);
        return cell[col];
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    public synchronized void setText(String body) {
        this.isChanged = false;
        this.listPair.clear();
        String name = null;
        String value = null;
        Matcher matcher = pSeparator.matcher(body);
        int cnt = 0;
        while (matcher.find()) {
            ++cnt;
            String[] cell = new String[2];
            try {
                name = URLDecoder.decode(matcher.group(1), "8859_1");
                value = URLDecoder.decode(matcher.group(2), "8859_1");
                cell[0] = name;
                cell[1] = value;
                this.listPair.add(cell);
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (cnt == 0) {
            if (body.isEmpty() && this.editable) {
                this.listPair.add(new String[]{"", ""});
            }
        } else if (this.editable) {
            this.listPair.add(new String[]{"", ""});
        }
        this.fireTableDataChanged();
    }

    public synchronized String getText() {
        StringBuilder sb = new StringBuilder();
        boolean hasValues = false;
        for (int i = 0; i < this.listPair.size(); ++i) {
            String[] cell = this.listPair.get(i);
            try {
                String name = URLEncoder.encode(cell[0], "UTF8");
                String value = URLEncoder.encode(cell[1], "UTF8");
                if (name.length() <= 0) continue;
                if (hasValues) {
                    sb.append('&');
                }
                sb.append(name);
                sb.append('=');
                sb.append(value);
                hasValues = true;
                continue;
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.isEditable();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (row < this.listPair.size() - 1) {
            String[] cells = this.listPair.get(row);
            cells[col] = (String)value;
            this.fireTableCellUpdated(row, col);
            this.isChanged = true;
        } else if (!value.equals("")) {
            String[] cells = this.listPair.get(row);
            cells[col] = (String)value;
            String[] nCells = new String[]{"", ""};
            this.listPair.add(nCells);
            this.fireTableCellUpdated(row, col);
            this.isChanged = true;
        }
    }

    public boolean hasChanged() {
        return this.isChanged;
    }
}

