/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.history;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.SiteNode;
import org.zaproxy.zap.view.widgets.WritableFileChooser;

public class PopupMenuExportURLs
extends ExtensionPopupMenuItem {
    private static final long serialVersionUID = 1L;
    protected ExtensionHistory extension = null;
    private static Logger log = Logger.getLogger(PopupMenuExportURLs.class);

    public PopupMenuExportURLs(String menuItem) {
        super(menuItem);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenuExportURLs.this.performAction();
            }
        });
    }

    protected void performAction() {
        File file = this.getOutputFile();
        if (file == null) {
            return;
        }
        this.writeURLs(file, this.getOutputSet((SiteNode)this.extension.getView().getSiteTreePanel().getTreeSite().getModel().getRoot()));
    }

    public void setExtension(ExtensionHistory extension) {
        this.extension = extension;
    }

    protected SortedSet<String> getOutputSet(SiteNode startingPoint) {
        TreeSet<String> outputSet = new TreeSet<String>();
        Enumeration<TreeNode> en = startingPoint.preorderEnumeration();
        while (en.hasMoreElements()) {
            HistoryReference nodeHR;
            SiteNode node = (SiteNode)en.nextElement();
            if (node.isRoot() || (nodeHR = node.getHistoryReference()) == null || HistoryReference.getTemporaryTypes().contains(nodeHR.getHistoryType())) continue;
            outputSet.add(nodeHR.getURI().toString());
        }
        return outputSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeURLs(File file, SortedSet<String> aSet) {
        boolean html = file.getName().toLowerCase().endsWith(".htm") || file.getName().toLowerCase().endsWith(".html");
        BufferedWriter fw = null;
        try {
            fw = new BufferedWriter(new FileWriter(file, false));
            for (String item : aSet) {
                item = html ? this.wrapHTML(item) : item;
                fw.write(item);
                fw.newLine();
            }
        }
        catch (Exception e1) {
            log.warn((Object)e1.getStackTrace(), (Throwable)e1);
            this.extension.getView().showWarningDialog(Constant.messages.getString("file.save.error") + file.getAbsolutePath());
        }
        finally {
            try {
                fw.close();
            }
            catch (Exception e2) {
                log.warn((Object)e2.getStackTrace(), (Throwable)e2);
            }
        }
    }

    private String wrapHTML(String input) {
        StringBuilder sb = new StringBuilder(50);
        sb.append("<a href=\"").append(input).append("\">");
        sb.append(input).append("</a><br>");
        return sb.toString();
    }

    protected File getOutputFile() {
        WritableFileChooser chooser = new WritableFileChooser(this.extension.getModel().getOptionsParam().getUserDirectory());
        FileNameExtensionFilter textFilesFilter = new FileNameExtensionFilter(Constant.messages.getString("file.format.ascii"), "txt");
        FileNameExtensionFilter htmlFilesFilter = new FileNameExtensionFilter(Constant.messages.getString("file.format.html"), "html", "htm");
        chooser.addChoosableFileFilter(textFilesFilter);
        chooser.addChoosableFileFilter(htmlFilesFilter);
        chooser.setFileFilter(textFilesFilter);
        File file = null;
        int rc = chooser.showSaveDialog(this.extension.getView().getMainFrame());
        if (rc == 0) {
            file = chooser.getSelectedFile();
            if (file == null) {
                return file;
            }
            this.extension.getModel().getOptionsParam().setUserDirectory(chooser.getCurrentDirectory());
            String fileNameLc = file.getAbsolutePath().toLowerCase();
            if (!(fileNameLc.endsWith(".txt") || fileNameLc.endsWith(".htm") || fileNameLc.endsWith(".html"))) {
                String ext = htmlFilesFilter.equals(chooser.getFileFilter()) ? ".html" : ".txt";
                file = new File(file.getAbsolutePath() + ext);
            }
            return file;
        }
        return file;
    }
}

