/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ext;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.Extension;
import org.zaproxy.zap.control.ExtensionFactory;

public class OptionsExtensionTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final String[] columnNames = new String[]{Constant.messages.getString("options.ext.label.enabled"), Constant.messages.getString("options.ext.label.core"), Constant.messages.getString("options.ext.label.author"), Constant.messages.getString("options.ext.label.extension")};
    private List<Extension> extensions = ExtensionFactory.getAllExtensions();
    private static Logger log = Logger.getLogger(OptionsExtensionTableModel.class);

    public OptionsExtensionTableModel() {
        Collections.sort(this.extensions, new Comparator<Extension>(){

            @Override
            public int compare(Extension ext0, Extension ext1) {
                if (ext0 == null || ext1 == null) {
                    return 0;
                }
                return ext0.getUIName().compareTo(ext1.getUIName());
            }
        });
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.extensions.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Extension ext = this.getExtension(row);
        if (ext != null) {
            try {
                switch (col) {
                    case 0: {
                        return ext.isEnabled();
                    }
                    case 1: {
                        if (ext.isCore()) {
                            return Constant.messages.getString("options.ext.label.iscore");
                        }
                        return "";
                    }
                    case 2: {
                        return ext.getAuthor();
                    }
                    case 3: {
                        return ext.getUIName();
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed on extension " + ext.getName()), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            if (this.getExtension(rowIndex).isCore() && this.getExtension(rowIndex).isEnabled()) {
                return false;
            }
            List<Class<?>> deps = this.getExtension(rowIndex).getDependencies();
            for (Class<?> dep : deps) {
                Extension ext = this.getExtension(dep);
                if (ext != null && ext.isEnabled()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Extension getExtension(Class<?> c) {
        for (Extension ext : this.extensions) {
            if (!ext.getClass().equals(c)) continue;
            return ext;
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            this.getExtension(row).setEnabled((Boolean)value);
            this.fireTableCellUpdated(row, col);
            this.enableDependants(this.getExtension(row), (Boolean)value);
        }
    }

    private void enableDependants(Extension extension, Boolean enabled) {
        int row = 0;
        for (Extension ext : this.extensions) {
            if (ext.getDependencies().contains(extension.getClass())) {
                ext.setEnabled(enabled);
                this.fireTableCellUpdated(row, 0);
                this.enableDependants(ext, enabled);
            }
            ++row;
        }
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public Class<?> getColumnClass(int c) {
        if (c == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    protected Extension getExtension(int row) {
        return this.extensions.get(row);
    }

    protected Extension getExtension(String name) {
        for (Extension ext : this.extensions) {
            if (!ext.getName().equals(name)) continue;
            return ext;
        }
        return null;
    }

    protected List<Extension> getExtensions() {
        return this.extensions;
    }
}

