/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.callback;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;

public class CallbackParam
extends AbstractParam {
    private static final Logger logger = Logger.getLogger(CallbackParam.class);
    private static final String PROXY_BASE_KEY = "callback";
    private static final String LOCAL_ADDRESS_KEY = "callback.localaddr";
    private static final String REMOTE_ADDRESS_KEY = "callback.remoteaddr";
    private static final String PORT_KEY = "callback.port";
    private String localAddress;
    private String remoteAddress;
    private int port;

    @Override
    protected void parse() {
        try {
            this.localAddress = this.getConfig().getString(LOCAL_ADDRESS_KEY, "0.0.0.0");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            this.remoteAddress = this.getConfig().getString(REMOTE_ADDRESS_KEY, this.getDefaultAddress());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            this.port = this.getConfig().getInt(PORT_KEY, 0);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private String getDefaultAddress() {
        List<String> addrs = this.getAvailableAddresses(false);
        for (String addr : addrs) {
            if (addr.contains(":") || addr.equals("localhost") || addr.equals("127.0.0.1")) continue;
            return addr;
        }
        if (addrs.size() > 0) {
            return addrs.get(0);
        }
        return "localhost";
    }

    public List<String> getAvailableAddresses(boolean remoteOnly) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface n = e.nextElement();
                if (n.isLoopback() || !n.isUp()) continue;
                Enumeration<InetAddress> ee = n.getInetAddresses();
                while (ee.hasMoreElements()) {
                    InetAddress i = ee.nextElement();
                    if (remoteOnly && i.isSiteLocalAddress()) continue;
                    String addr = i.getHostAddress();
                    if (addr.indexOf(37) > 0) {
                        addr = addr.substring(0, addr.indexOf(37));
                    }
                    list.add(addr);
                }
            }
        }
        catch (SocketException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        return list;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(String localAddress) {
        if (this.localAddress.equals(localAddress)) {
            return;
        }
        this.localAddress = localAddress.trim();
        this.getConfig().setProperty(LOCAL_ADDRESS_KEY, (Object)this.localAddress);
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(String remoteAddress) {
        if (this.remoteAddress.equals(remoteAddress)) {
            return;
        }
        this.remoteAddress = remoteAddress.trim();
        this.getConfig().setProperty(REMOTE_ADDRESS_KEY, (Object)this.remoteAddress);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        if (this.port == port) {
            return;
        }
        this.port = port;
        this.getConfig().setProperty(PORT_KEY, (Object)Integer.toString(this.port));
    }
}

