/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.authentication;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.authentication.FormBasedAuthenticationMethodType;
import org.zaproxy.zap.authentication.HttpAuthenticationMethodType;
import org.zaproxy.zap.authentication.ManualAuthenticationMethodType;
import org.zaproxy.zap.authentication.ScriptBasedAuthenticationMethodType;
import org.zaproxy.zap.extension.authentication.AuthenticationAPI;
import org.zaproxy.zap.extension.authentication.ContextAuthenticationPanel;
import org.zaproxy.zap.extension.authentication.PopupFlagLoggedInIndicatorMenu;
import org.zaproxy.zap.extension.authentication.PopupFlagLoggedOutIndicatorMenu;
import org.zaproxy.zap.extension.stdmenus.PopupContextMenuItemFactory;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.ContextDataFactory;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.ContextPanelFactory;

public class ExtensionAuthentication
extends ExtensionAdaptor
implements ContextPanelFactory,
ContextDataFactory {
    public static final int EXTENSION_ORDER = 52;
    public static final String NAME = "ExtensionAuthentication";
    private static final Logger log = Logger.getLogger(ExtensionAuthentication.class);
    List<AuthenticationMethodType> authenticationMethodTypes;
    private Map<Integer, ContextAuthenticationPanel> contextPanelsMap = new HashMap<Integer, ContextAuthenticationPanel>();
    private PopupContextMenuItemFactory popupFlagLoggedInIndicatorMenuFactory;
    private PopupContextMenuItemFactory popupFlagLoggedOutIndicatorMenuFactory;
    AuthenticationAPI api;

    public ExtensionAuthentication() {
        this.initialize();
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(52);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        Model.getSingleton().addContextDataFactory(this);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupFlagLoggedInIndicatorMenu());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupFlagLoggedOutIndicatorMenu());
            this.getView().addContextPanelFactory(this);
        }
        this.loadAuthenticationMethodTypes(extensionHook);
        this.api = new AuthenticationAPI(this);
        extensionHook.addApiImplementor(this.api);
    }

    @Override
    public AbstractContextPropertiesPanel getContextPanel(Context context) {
        ContextAuthenticationPanel panel = this.contextPanelsMap.get(context.getIndex());
        if (panel == null) {
            panel = new ContextAuthenticationPanel(this, context);
            this.contextPanelsMap.put(context.getIndex(), panel);
        }
        return panel;
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    private PopupContextMenuItemFactory getPopupFlagLoggedInIndicatorMenu() {
        if (this.popupFlagLoggedInIndicatorMenuFactory == null) {
            this.popupFlagLoggedInIndicatorMenuFactory = new PopupContextMenuItemFactory("dd - " + Constant.messages.getString("context.flag.popup")){
                private static final long serialVersionUID = 2453839120088204122L;

                @Override
                public ExtensionPopupMenuItem getContextMenu(Context context, String parentMenu) {
                    return new PopupFlagLoggedInIndicatorMenu(context);
                }
            };
        }
        return this.popupFlagLoggedInIndicatorMenuFactory;
    }

    private PopupContextMenuItemFactory getPopupFlagLoggedOutIndicatorMenu() {
        if (this.popupFlagLoggedOutIndicatorMenuFactory == null) {
            this.popupFlagLoggedOutIndicatorMenuFactory = new PopupContextMenuItemFactory("dd - " + Constant.messages.getString("context.flag.popup")){
                private static final long serialVersionUID = 2453839120088204123L;

                @Override
                public ExtensionPopupMenuItem getContextMenu(Context context, String parentMenu) {
                    return new PopupFlagLoggedOutIndicatorMenu(context);
                }
            };
        }
        return this.popupFlagLoggedOutIndicatorMenuFactory;
    }

    private void loadAuthenticationMethodTypes(ExtensionHook hook) {
        this.authenticationMethodTypes = new ArrayList<AuthenticationMethodType>();
        this.authenticationMethodTypes.add(new FormBasedAuthenticationMethodType());
        this.authenticationMethodTypes.add(new HttpAuthenticationMethodType());
        this.authenticationMethodTypes.add(new ManualAuthenticationMethodType());
        this.authenticationMethodTypes.add(new ScriptBasedAuthenticationMethodType());
        for (AuthenticationMethodType a : this.authenticationMethodTypes) {
            a.hook(hook);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded authentication method types: " + this.authenticationMethodTypes));
        }
    }

    public List<AuthenticationMethodType> getAuthenticationMethodTypes() {
        return this.authenticationMethodTypes;
    }

    public AuthenticationMethodType getAuthenticationMethodTypeForIdentifier(int id) {
        for (AuthenticationMethodType t : this.getAuthenticationMethodTypes()) {
            if (t.getUniqueIdentifier() != id) continue;
            return t;
        }
        return null;
    }

    public URI getLoginRequestURIForContext(Context ctx) {
        if (!(ctx.getAuthenticationMethod() instanceof FormBasedAuthenticationMethodType.FormBasedAuthenticationMethod)) {
            return null;
        }
        FormBasedAuthenticationMethodType.FormBasedAuthenticationMethod method = (FormBasedAuthenticationMethodType.FormBasedAuthenticationMethod)ctx.getAuthenticationMethod();
        try {
            return new URI(method.getLoginRequestURL(), false);
        }
        catch (NullPointerException | URIException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void loadContextData(Session session, Context context) {
        try {
            AuthenticationMethodType t;
            List<String> typeL = session.getContextDataStrings(context.getIndex(), 200);
            if (typeL != null && typeL.size() > 0 && (t = this.getAuthenticationMethodTypeForIdentifier(Integer.parseInt(typeL.get(0)))) != null) {
                List<String> logoutIndicatorL;
                context.setAuthenticationMethod(t.loadMethodFromSession(session, context.getIndex()));
                List<String> loginIndicatorL = session.getContextDataStrings(context.getIndex(), 206);
                if (loginIndicatorL != null && loginIndicatorL.size() > 0) {
                    context.getAuthenticationMethod().setLoggedInIndicatorPattern(loginIndicatorL.get(0));
                }
                if ((logoutIndicatorL = session.getContextDataStrings(context.getIndex(), 207)) != null && logoutIndicatorL.size() > 0) {
                    context.getAuthenticationMethod().setLoggedOutIndicatorPattern(logoutIndicatorL.get(0));
                }
            }
        }
        catch (DatabaseException e) {
            log.error((Object)"Unable to load Authentication method.", (Throwable)e);
        }
    }

    @Override
    public void persistContextData(Session session, Context context) {
        try {
            AuthenticationMethodType t = context.getAuthenticationMethod().getType();
            session.setContextData(context.getIndex(), 200, Integer.toString(t.getUniqueIdentifier()));
            if (context.getAuthenticationMethod().getLoggedInIndicatorPattern() != null) {
                session.setContextData(context.getIndex(), 206, context.getAuthenticationMethod().getLoggedInIndicatorPattern().toString());
            }
            if (context.getAuthenticationMethod().getLoggedOutIndicatorPattern() != null) {
                session.setContextData(context.getIndex(), 207, context.getAuthenticationMethod().getLoggedOutIndicatorPattern().toString());
            }
            t.persistMethodToSession(session, context.getIndex(), context.getAuthenticationMethod());
        }
        catch (DatabaseException e) {
            log.error((Object)"Unable to persist Authentication method.", (Throwable)e);
        }
    }

    @Override
    public void discardContexts() {
        this.contextPanelsMap.clear();
    }

    @Override
    public void discardContext(Context ctx) {
        this.contextPanelsMap.remove(ctx.getIndex());
    }

    @Override
    public void exportContextData(Context ctx, Configuration config) {
        config.setProperty("context.authentication.type", (Object)ctx.getAuthenticationMethod().getType().getUniqueIdentifier());
        if (ctx.getAuthenticationMethod().getLoggedInIndicatorPattern() != null) {
            config.setProperty("context.authentication.loggedin", (Object)ctx.getAuthenticationMethod().getLoggedInIndicatorPattern().toString());
        }
        if (ctx.getAuthenticationMethod().getLoggedOutIndicatorPattern() != null) {
            config.setProperty("context.authentication.loggedout", (Object)ctx.getAuthenticationMethod().getLoggedOutIndicatorPattern().toString());
        }
        ctx.getAuthenticationMethod().getType().exportData(config, ctx.getAuthenticationMethod());
    }

    @Override
    public void importContextData(Context ctx, Configuration config) throws ConfigurationException {
        ctx.setAuthenticationMethod(this.getAuthenticationMethodTypeForIdentifier(config.getInt("context.authentication.type")).createAuthenticationMethod(ctx.getIndex()));
        String str = config.getString("context.authentication.loggedin", "");
        if (str.length() > 0) {
            ctx.getAuthenticationMethod().setLoggedInIndicatorPattern(str);
        }
        if ((str = config.getString("context.authentication.loggedout", "")).length() > 0) {
            ctx.getAuthenticationMethod().setLoggedOutIndicatorPattern(str);
        }
        ctx.getAuthenticationMethod().getType().importData(config, ctx.getAuthenticationMethod());
    }
}

