/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.Plugin;
import org.zaproxy.zap.extension.ascan.ActiveScan;
import org.zaproxy.zap.extension.ascan.ScanProgressActionIcon;
import org.zaproxy.zap.extension.ascan.ScanProgressItem;

public class ScanProgressTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final String[] columnNames = new String[]{Constant.messages.getString("ascan.progress.table.name"), Constant.messages.getString("ascan.policy.table.strength"), Constant.messages.getString("ascan.progress.table.progress"), Constant.messages.getString("ascan.progress.table.time"), Constant.messages.getString("ascan.progress.table.reqs"), Constant.messages.getString("ascan.progress.table.status")};
    private List<ScanProgressItem> values;
    private List<ScanProgressActionIcon> actions = new ArrayList<ScanProgressActionIcon>();
    private ScanProgressActionIcon focusedAction = null;
    private String totRequests;
    private String totTime;

    public ScanProgressTableModel() {
        this.values = new ArrayList<ScanProgressItem>();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        if (this.values == null) {
            return 0;
        }
        return this.values.size() + 2;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row < this.values.size()) {
            ScanProgressItem item = this.values.get(row);
            switch (col) {
                case 0: {
                    return item.getNameLabel();
                }
                case 1: {
                    return item.getAttackStrenghtLabel();
                }
                case 2: {
                    if (item.isCompleted() || item.isRunning() || item.isSkipped()) {
                        return item;
                    }
                    return null;
                }
                case 3: {
                    return this.getElapsedTimeLabel(item.getElapsedTime());
                }
                case 4: {
                    return item.getReqCount();
                }
                case 5: {
                    ScanProgressActionIcon action = null;
                    if (item.isCompleted() || item.isRunning() || item.isSkipped()) {
                        if (row < this.actions.size()) {
                            action = this.actions.get(row);
                            action.updateStatus(item);
                        } else {
                            action = new ScanProgressActionIcon(item);
                            this.actions.add(action);
                        }
                    }
                    return action;
                }
            }
            return null;
        }
        if (row == this.values.size()) {
            return null;
        }
        if (row == this.values.size() + 1) {
            switch (col) {
                case 0: {
                    return Constant.messages.getString("ascan.progress.label.totals");
                }
                case 3: {
                    return this.totTime;
                }
                case 4: {
                    return this.totRequests;
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public Class<?> getColumnClass(int c) {
        switch (c) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return ScanProgressItem.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return ScanProgressActionIcon.class;
            }
        }
        return null;
    }

    public List<ScanProgressItem> getValues() {
        return this.values;
    }

    public void setFocusedAction(ScanProgressActionIcon actionIcon) {
        this.focusedAction = actionIcon;
    }

    public ScanProgressActionIcon getFocusedAction() {
        return this.focusedAction;
    }

    public void updateValues(ActiveScan scan, HostProcess hp) {
        this.values.clear();
        for (Plugin plugin : hp.getCompleted()) {
            this.values.add(new ScanProgressItem(hp, plugin, 3));
        }
        for (Plugin plugin : hp.getRunning()) {
            this.values.add(new ScanProgressItem(hp, plugin, 2));
        }
        for (Plugin plugin : hp.getPending()) {
            this.values.add(new ScanProgressItem(hp, plugin, 1));
        }
        Date end = scan.getTimeFinished() == null ? new Date() : scan.getTimeFinished();
        long elapsed = end.getTime() - scan.getTimeStarted().getTime();
        this.totTime = this.getElapsedTimeLabel(elapsed);
        this.totRequests = Integer.toString(scan.getTotalRequests());
        this.fireTableDataChanged();
    }

    private String getElapsedTimeLabel(long elapsed) {
        return elapsed >= 0L ? String.format("%02d:%02d.%03d", elapsed / 60000L, elapsed % 60000L / 1000L, elapsed % 1000L) : null;
    }
}

