/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.awt.Dimension;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.extension.ascan.ScanProgressItem;

public class ScanProgressActionIcon
extends JLabel {
    private static final long serialVersionUID = 1L;
    private static final ImageIcon completedIcon = new ImageIcon(ZAP.class.getResource("/resource/icon/10/102.png"));
    private static final ImageIcon skippedIcon = new ImageIcon(ZAP.class.getResource("/resource/icon/10/150.png"));
    private static final ImageIcon skipIcon = new ImageIcon(ZAP.class.getResource("/resource/icon/16/skip1_16.png"));
    private static final ImageIcon focusedSkipIcon = new ImageIcon(ZAP.class.getResource("/resource/icon/16/skip1_focused_16.png"));
    private static final ImageIcon pressedSkipIcon = new ImageIcon(ZAP.class.getResource("/resource/icon/16/skip1_pressed_16.png"));
    public static final int CLICKABLE_ICON_WIDTH = 24;
    public static final int CLICKABLE_ICON_HEIGHT = 16;
    private static final int STATE_NORMAL = 0;
    private static final int STATE_FOCUSED = 1;
    private static final int STATE_PRESSED = 2;
    private int state;
    private ScanProgressItem item;

    public ScanProgressActionIcon(ScanProgressItem item) {
        this.item = item;
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.setPreferredSize(new Dimension(24, 16));
        this.changeIcon();
    }

    public void updateStatus(ScanProgressItem item) {
        this.item = item;
        this.changeIcon();
    }

    private void changeIcon() {
        if (this.item.isSkipped()) {
            this.setIcon(skippedIcon);
            this.setToolTipText(this.getSkipText());
        } else if (this.item.isRunning()) {
            ImageIcon icon = null;
            switch (this.state) {
                case 0: {
                    icon = skipIcon;
                    break;
                }
                case 1: {
                    icon = focusedSkipIcon;
                    break;
                }
                case 2: {
                    icon = pressedSkipIcon;
                }
            }
            this.setIcon(icon);
            this.setToolTipText(Constant.messages.getString("ascan.progress.label.skipaction"));
        } else {
            this.setIcon(completedIcon);
            this.setToolTipText(Constant.messages.getString("ascan.progress.label.completed"));
        }
    }

    private String getSkipText() {
        String reason = this.item.getSkippedReason();
        if (reason != null) {
            return Constant.messages.getString("ascan.progress.label.skippedWithReason", reason);
        }
        return Constant.messages.getString("ascan.progress.label.skipped");
    }

    public void invokeAction() {
        this.item.skip();
    }

    public void setPressed() {
        this.state = 2;
        this.changeIcon();
    }

    public void setReleased() {
        if (this.state == 2) {
            this.state = 1;
            this.changeIcon();
        }
    }

    public void setOver() {
        if (this.state == 0) {
            this.state = 1;
            this.changeIcon();
        }
    }

    public void setNormal() {
        this.state = 0;
        this.changeIcon();
    }

    @Override
    public String toString() {
        if (this.item.isSkipped()) {
            return this.getSkipText();
        }
        return this.item.getStatusLabel();
    }
}

