/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.utils.XMLStringUtil;

public class ApiException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final Type type;
    private final String detail;
    private final Logger logger = Logger.getLogger(this.getClass());

    public ApiException(Type type) {
        this(type, null, null);
    }

    public ApiException(Type type, Throwable cause) {
        this(type, null, cause);
    }

    public ApiException(Type type, String detail) {
        this(type, detail, null);
    }

    public ApiException(Type type, String detail, Throwable cause) {
        super(type.name().toLowerCase(), cause);
        this.type = type;
        this.detail = detail;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean incDetails) {
        if (!incDetails) {
            return Constant.messages.getString("api.error." + super.getMessage());
        }
        if (this.detail != null) {
            return Constant.messages.getString("api.error." + super.getMessage()) + " (" + super.getMessage() + ") : " + this.detail;
        }
        return Constant.messages.getString("api.error." + super.getMessage()) + " (" + super.getMessage() + ")";
    }

    public String toString(API.Format format, boolean incDetails) {
        switch (format) {
            case HTML: 
            case UI: {
                return StringEscapeUtils.escapeHtml((String)this.toString(incDetails));
            }
            case XML: {
                try {
                    DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                    Document doc = docBuilder.newDocument();
                    Element rootElement = doc.createElement("Exception");
                    doc.appendChild(rootElement);
                    rootElement.setAttribute("type", "exception");
                    rootElement.setAttribute("code", this.getMessage());
                    if (incDetails && this.detail != null) {
                        rootElement.setAttribute("detail", XMLStringUtil.escapeControlChrs(this.detail));
                    }
                    rootElement.appendChild(doc.createTextNode(XMLStringUtil.escapeControlChrs(this.toString(incDetails))));
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    DOMSource source = new DOMSource(doc);
                    StringWriter sw = new StringWriter();
                    StreamResult result = new StreamResult(sw);
                    transformer.transform(source, result);
                    return sw.toString();
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                    break;
                }
            }
            case JSON: {
                return this.toJSON(incDetails).toString();
            }
        }
        return null;
    }

    private JSONObject toJSON(boolean incDetails) {
        JSONObject ja = new JSONObject();
        ja.put((Object)"code", (Object)super.getMessage());
        ja.put((Object)"message", (Object)Constant.messages.getString("api.error." + super.getMessage()));
        if (incDetails && this.detail != null) {
            ja.put((Object)"detail", (Object)this.detail);
        }
        return ja;
    }

    public static enum Type {
        BAD_FORMAT,
        BAD_TYPE,
        NO_IMPLEMENTOR,
        BAD_ACTION,
        BAD_VIEW,
        BAD_OTHER,
        INTERNAL_ERROR,
        MISSING_PARAMETER,
        URL_NOT_FOUND,
        HREF_NOT_FOUND,
        SCAN_IN_PROGRESS,
        DISABLED,
        ALREADY_EXISTS,
        DOES_NOT_EXIST,
        ILLEGAL_PARAMETER,
        CONTEXT_NOT_FOUND,
        CONTENT_TYPE_NOT_SUPPORTED,
        USER_NOT_FOUND,
        URL_NOT_IN_CONTEXT,
        BAD_API_KEY,
        SCRIPT_NOT_FOUND,
        BAD_SCRIPT_FORMAT,
        NO_ACCESS,
        MODE_VIOLATION,
        BAD_EXTERNAL_DATA;

    }
}

