/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.proxy.ProxyParam;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpInputStream;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpOutputStream;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.view.View;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiOther;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.api.OptionsParamApi;
import org.zaproxy.zap.extension.api.WebUI;

public class API {
    public static String API_DOMAIN = "zap";
    public static String API_URL = "http://" + API_DOMAIN + "/";
    public static String API_URL_S = "https://" + API_DOMAIN + "/";
    public static String API_KEY_PARAM = "apikey";
    public static String API_NONCE_PARAM = "apinonce";
    private static Pattern patternParam = Pattern.compile("&", 2);
    private static final String CALL_BACK_URL = "/zapCallBackUrl/";
    private static final String STATUS_OK = "200 OK";
    private static final String STATUS_BAD_REQUEST = "400 Bad Request";
    private static final String STATUS_INTERNAL_SERVER_ERROR = "500 Internal Server Error";
    private Map<String, ApiImplementor> implementors = new HashMap<String, ApiImplementor>();
    private static API api = null;
    private WebUI webUI = new WebUI(this);
    private Map<String, ApiImplementor> callBacks = new HashMap<String, ApiImplementor>();
    private Map<String, ApiImplementor> shortcuts = new HashMap<String, ApiImplementor>();
    private Map<String, Nonce> nonces = Collections.synchronizedMap(new HashMap());
    private OptionsParamApi optionsParamApi;
    private Random random = new SecureRandom();
    private static final Logger logger = Logger.getLogger(API.class);

    private static synchronized API newInstance() {
        if (api == null) {
            api = new API();
        }
        return api;
    }

    public static API getInstance() {
        if (api == null) {
            API.newInstance();
        }
        return api;
    }

    public void registerApiImplementor(ApiImplementor impl) {
        if (this.implementors.get(impl.getPrefix()) != null) {
            logger.error((Object)("Second attempt to register API implementor with prefix of " + impl.getPrefix()));
            return;
        }
        this.implementors.put(impl.getPrefix(), impl);
        for (String shortcut : impl.getApiShortcuts()) {
            logger.debug((Object)("Registering API shortcut: " + shortcut));
            if (this.shortcuts.containsKey(shortcut)) {
                logger.error((Object)("Duplicate API shortcut: " + shortcut));
            }
            this.shortcuts.put("/" + shortcut, impl);
        }
    }

    public void removeApiImplementor(ApiImplementor impl) {
        if (!this.implementors.containsKey(impl.getPrefix())) {
            logger.warn((Object)("Attempting to remove an API implementor not registered, with prefix: " + impl.getPrefix()));
            return;
        }
        this.implementors.remove(impl.getPrefix());
        for (String shortcut : impl.getApiShortcuts()) {
            String key = "/" + shortcut;
            if (!this.shortcuts.containsKey(key)) continue;
            logger.debug((Object)("Removing registered API shortcut: " + shortcut));
            this.shortcuts.remove(key);
        }
    }

    public boolean isEnabled() {
        return !View.isInitialised() || this.getOptionsParamApi().isEnabled();
    }

    private OptionsParamApi getOptionsParamApi() {
        if (this.optionsParamApi == null) {
            this.optionsParamApi = Model.getSingleton().getOptionsParam().getApiParam();
        }
        return this.optionsParamApi;
    }

    void setOptionsParamApi(OptionsParamApi optionsParamApi) {
        this.optionsParamApi = optionsParamApi;
    }

    public boolean handleApiRequest(HttpRequestHeader requestHeader, HttpInputStream httpIn, HttpOutputStream httpOut) throws IOException {
        return this.handleApiRequest(requestHeader, httpIn, httpOut, false);
    }

    private boolean isPermittedAddr(HttpRequestHeader requestHeader) {
        if (this.getOptionsParamApi().isPermittedAddress(requestHeader.getSenderAddress().getHostAddress())) {
            if (this.getOptionsParamApi().isPermittedAddress(requestHeader.getHostName())) {
                return true;
            }
            logger.warn((Object)("Request to API URL " + requestHeader.getURI().toString() + " with host header " + requestHeader.getHostName() + " not permitted"));
            return false;
        }
        logger.warn((Object)("Request to API URL " + requestHeader.getURI().toString() + " from " + requestHeader.getSenderAddress().getHostAddress() + " not permitted"));
        return false;
    }

    public boolean handleApiRequest(HttpRequestHeader requestHeader, HttpInputStream httpIn, HttpOutputStream httpOut, boolean force) throws IOException {
        String path;
        String url = requestHeader.getURI().toString();
        Format format = Format.OTHER;
        ApiImplementor callbackImpl = null;
        ApiImplementor shortcutImpl = null;
        if (url.contains(CALL_BACK_URL)) {
            if (!this.isPermittedAddr(requestHeader)) {
                return true;
            }
            logger.debug((Object)("handleApiRequest Callback: " + url));
            for (Map.Entry<String, ApiImplementor> callback : this.callBacks.entrySet()) {
                if (!url.startsWith((String)callback.getKey())) continue;
                callbackImpl = (ApiImplementor)callback.getValue();
                break;
            }
        }
        if ((path = requestHeader.getURI().getPath()) != null) {
            for (Map.Entry<String, ApiImplementor> shortcut : this.shortcuts.entrySet()) {
                if (!path.startsWith(shortcut.getKey())) continue;
                shortcutImpl = shortcut.getValue();
                break;
            }
        }
        if (!(shortcutImpl != null || callbackImpl != null || url.startsWith(API_URL) || url.startsWith(API_URL_S) || force)) {
            return false;
        }
        if (!this.isPermittedAddr(requestHeader)) {
            return true;
        }
        if (this.getOptionsParamApi().isSecureOnly() && !requestHeader.isSecure()) {
            logger.debug((Object)"handleApiRequest rejecting insecure request");
            return true;
        }
        logger.debug((Object)("handleApiRequest " + url));
        HttpMessage msg = new HttpMessage();
        msg.setRequestHeader(requestHeader);
        if (requestHeader.getContentLength() > 0) {
            msg.setRequestBody(httpIn.readRequestBody(requestHeader));
        }
        String component = null;
        ApiImplementor impl = null;
        RequestType reqType = null;
        String contentType = "text/plain; charset=UTF-8";
        String response = "";
        String name = null;
        boolean error = false;
        try {
            JSONObject params = API.getParams(requestHeader.getURI().getEscapedQuery());
            if (shortcutImpl != null) {
                if (!(this.getOptionsParamApi().isDisableKey() || this.getOptionsParamApi().isNoKeyForSafeOps() || this.hasValidKey(requestHeader, params))) {
                    throw new ApiException(ApiException.Type.BAD_API_KEY);
                }
                msg = shortcutImpl.handleShortcut(msg);
            } else if (callbackImpl != null) {
                response = callbackImpl.handleCallBack(msg);
            } else {
                String[] elements = url.split("/");
                if (elements.length > 3 && elements[3].equalsIgnoreCase("favicon.ico")) {
                    if (!this.getOptionsParamApi().isUiEnabled()) {
                        throw new ApiException(ApiException.Type.DISABLED);
                    }
                    InputStream is = API.class.getResourceAsStream("/resource/zap.ico");
                    byte[] icon = new byte[is.available()];
                    is.read(icon);
                    is.close();
                    msg.setResponseHeader(API.getDefaultResponseHeader(contentType));
                    msg.getResponseHeader().setContentLength(icon.length);
                    httpOut.write(msg.getResponseHeader());
                    httpOut.write(icon);
                    httpOut.flush();
                    httpOut.close();
                    httpIn.close();
                    return true;
                }
                if (elements.length > 3) {
                    try {
                        format = Format.valueOf(elements[3].toUpperCase());
                        switch (format) {
                            case JSON: {
                                contentType = "application/json; charset=UTF-8";
                                break;
                            }
                            case JSONP: {
                                contentType = "application/javascript; charset=UTF-8";
                                break;
                            }
                            case XML: {
                                contentType = "text/xml; charset=UTF-8";
                                break;
                            }
                            case HTML: {
                                contentType = "text/html; charset=UTF-8";
                                break;
                            }
                            case UI: {
                                contentType = "text/html; charset=UTF-8";
                                break;
                            }
                        }
                    }
                    catch (IllegalArgumentException e) {
                        format = Format.HTML;
                        throw new ApiException(ApiException.Type.BAD_FORMAT);
                    }
                }
                if (elements.length > 4 && (impl = this.implementors.get(component = elements[4])) == null) {
                    throw new ApiException(ApiException.Type.NO_IMPLEMENTOR);
                }
                if (elements.length > 5) {
                    try {
                        reqType = RequestType.valueOf(elements[5]);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ApiException(ApiException.Type.BAD_TYPE);
                    }
                }
                if (elements.length > 6 && (name = elements[6]) != null && name.indexOf("?") > 0) {
                    name = name.substring(0, name.indexOf("?"));
                }
                if (format.equals((Object)Format.UI)) {
                    if (!this.isEnabled() || !this.getOptionsParamApi().isUiEnabled()) {
                        throw new ApiException(ApiException.Type.DISABLED);
                    }
                    response = this.webUI.handleRequest(component, impl, reqType, name);
                    contentType = "text/html; charset=UTF-8";
                } else if (name != null) {
                    if (!this.isEnabled()) {
                        throw new ApiException(ApiException.Type.DISABLED);
                    }
                    if (requestHeader.getMethod().equalsIgnoreCase("POST")) {
                        String contentTypeHeader = requestHeader.getHeader("Content-Type");
                        if (contentTypeHeader != null && contentTypeHeader.equals("application/x-www-form-urlencoded")) {
                            params = API.getParams(msg.getRequestBody().toString());
                        } else {
                            throw new ApiException(ApiException.Type.CONTENT_TYPE_NOT_SUPPORTED);
                        }
                    }
                    if (format.equals((Object)Format.JSONP)) {
                        if (!this.getOptionsParamApi().isEnableJSONP()) {
                            throw new ApiException(ApiException.Type.DISABLED);
                        }
                        if (!this.hasValidKey(requestHeader, params)) {
                            throw new ApiException(ApiException.Type.BAD_API_KEY);
                        }
                    }
                    block10 : switch (reqType) {
                        case action: {
                            ApiResponse res;
                            List<String> mandatoryParams;
                            if (!this.getOptionsParamApi().isDisableKey() && !this.hasValidKey(requestHeader, params)) {
                                throw new ApiException(ApiException.Type.BAD_API_KEY);
                            }
                            ApiAction action = impl.getApiAction(name);
                            if (action != null && (mandatoryParams = action.getMandatoryParamNames()) != null) {
                                for (String param : mandatoryParams) {
                                    if (params.has(param) && params.getString(param).length() != 0) continue;
                                    throw new ApiException(ApiException.Type.MISSING_PARAMETER, param);
                                }
                            }
                            if ((res = impl.handleApiOptionAction(name, params)) == null) {
                                res = impl.handleApiAction(name, params);
                            }
                            switch (format) {
                                case JSON: {
                                    response = res.toJSON().toString();
                                    break block10;
                                }
                                case JSONP: {
                                    response = this.getJsonpWrapper(res.toJSON().toString());
                                    break block10;
                                }
                                case XML: {
                                    response = this.responseToXml(name, res);
                                    break block10;
                                }
                                case HTML: {
                                    response = this.responseToHtml(name, res);
                                    break block10;
                                }
                            }
                            break;
                        }
                        case view: {
                            List<String> mandatoryParams;
                            ApiResponse res;
                            if (!(this.getOptionsParamApi().isDisableKey() || this.getOptionsParamApi().isNoKeyForSafeOps() || this.hasValidKey(requestHeader, params))) {
                                throw new ApiException(ApiException.Type.BAD_API_KEY);
                            }
                            ApiView view = impl.getApiView(name);
                            if (view != null && (mandatoryParams = view.getMandatoryParamNames()) != null) {
                                for (String param : mandatoryParams) {
                                    if (params.has(param) && params.getString(param).length() != 0) continue;
                                    throw new ApiException(ApiException.Type.MISSING_PARAMETER, param);
                                }
                            }
                            if ((res = impl.handleApiOptionView(name, params)) == null) {
                                res = impl.handleApiView(name, params);
                            }
                            switch (format) {
                                case JSON: {
                                    response = res.toJSON().toString();
                                    break block10;
                                }
                                case JSONP: {
                                    response = this.getJsonpWrapper(res.toJSON().toString());
                                    break block10;
                                }
                                case XML: {
                                    response = this.responseToXml(name, res);
                                    break block10;
                                }
                                case HTML: {
                                    response = this.responseToHtml(name, res);
                                    break block10;
                                }
                            }
                            break;
                        }
                        case other: {
                            ApiOther other = impl.getApiOther(name);
                            if (other != null) {
                                if (!(this.getOptionsParamApi().isDisableKey() || this.getOptionsParamApi().isNoKeyForSafeOps() && !other.isRequiresApiKey() || this.hasValidKey(requestHeader, params))) {
                                    throw new ApiException(ApiException.Type.BAD_API_KEY);
                                }
                                List<String> mandatoryParams = other.getMandatoryParamNames();
                                if (mandatoryParams != null) {
                                    for (String param : mandatoryParams) {
                                        if (params.has(param) && params.getString(param).length() != 0) continue;
                                        throw new ApiException(ApiException.Type.MISSING_PARAMETER, param);
                                    }
                                }
                            }
                            msg = impl.handleApiOther(msg, name, params);
                        }
                    }
                } else {
                    if (!this.isEnabled() || !this.getOptionsParamApi().isUiEnabled()) {
                        throw new ApiException(ApiException.Type.DISABLED);
                    }
                    response = this.webUI.handleRequest(requestHeader.getURI(), this.isEnabled());
                    format = Format.UI;
                    contentType = "text/html; charset=UTF-8";
                }
            }
            logger.debug((Object)("handleApiRequest returning: " + response));
        }
        catch (Exception e) {
            ApiException exception;
            if (!this.getOptionsParamApi().isReportPermErrors() && e instanceof ApiException && ((exception = (ApiException)e).getType().equals((Object)ApiException.Type.DISABLED) || exception.getType().equals((Object)ApiException.Type.BAD_API_KEY))) {
                return true;
            }
            this.handleException(msg, format, contentType, e);
            error = true;
        }
        if (!error && !format.equals((Object)Format.OTHER) && shortcutImpl == null) {
            msg.setResponseHeader(API.getDefaultResponseHeader(contentType));
            msg.setResponseBody(response);
            msg.getResponseHeader().setContentLength(msg.getResponseBody().length());
        }
        if (impl != null) {
            impl.addCustomHeaders(name, reqType, msg);
        }
        httpOut.write(msg.getResponseHeader());
        httpOut.write(msg.getResponseBody().getBytes());
        httpOut.flush();
        httpOut.close();
        httpIn.close();
        return true;
    }

    public String getBaseURL(Format format, String prefix, RequestType type, String name, boolean proxy) {
        String apiPath = format.name() + "/" + prefix + "/" + type.name() + "/" + name + "/";
        String base = API_URL;
        if (this.getOptionsParamApi().isSecureOnly()) {
            base = API_URL_S;
        }
        if (!proxy) {
            ProxyParam proxyParam = Model.getSingleton().getOptionsParam().getProxyParam();
            base = this.getOptionsParamApi().isSecureOnly() ? "https://" + proxyParam.getProxyIp() + ":" + proxyParam.getProxyPort() + "/" : "http://" + proxyParam.getProxyIp() + ":" + proxyParam.getProxyPort() + "/";
        }
        if (!RequestType.view.equals((Object)type)) {
            return base + apiPath + "/?" + API_NONCE_PARAM + "=" + this.getOneTimeNonce(apiPath) + "&";
        }
        return base + apiPath;
    }

    private String responseToHtml(String name, ApiResponse res) {
        StringBuilder sb = new StringBuilder();
        sb.append("<head>\n");
        sb.append("</head>\n");
        sb.append("<body>\n");
        res.toHTML(sb);
        sb.append("</body>\n");
        return sb.toString();
    }

    private String responseToXml(String name, ApiResponse res) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement(name);
            doc.appendChild(rootElement);
            res.toXML(doc, rootElement);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            transformer.transform(source, result);
            return sw.toString();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static JSONObject getParams(String params) throws ApiException {
        JSONObject jp = new JSONObject();
        if (params == null || params.length() == 0) {
            return jp;
        }
        String[] keyValue = patternParam.split(params);
        String key = null;
        String value = null;
        int pos = 0;
        for (int i = 0; i < keyValue.length; ++i) {
            key = null;
            pos = keyValue[i].indexOf(61);
            if (pos > 0) {
                try {
                    key = URLDecoder.decode(keyValue[i].substring(0, pos), "UTF-8");
                    value = URLDecoder.decode(keyValue[i].substring(pos + 1), "UTF-8");
                    jp.put((Object)key, (Object)value);
                }
                catch (UnsupportedEncodingException | IllegalArgumentException e) {
                    ApiException apiException = new ApiException(ApiException.Type.ILLEGAL_PARAMETER, params, e);
                    logger.error((Object)apiException.getMessage(), (Throwable)apiException);
                }
                continue;
            }
            ApiException e = new ApiException(ApiException.Type.ILLEGAL_PARAMETER, params);
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return jp;
    }

    private String getJsonpWrapper(String json) {
        return "zapJsonpResult (" + json + " )";
    }

    public Map<String, ApiImplementor> getImplementors() {
        return Collections.unmodifiableMap(this.implementors);
    }

    public String getCallBackUrl(ApiImplementor impl, String site) {
        String url = site + CALL_BACK_URL + this.random.nextLong();
        this.callBacks.put(url, impl);
        return url;
    }

    public String getOneTimeNonce(String apiUrl) {
        String nonce = Long.toHexString(this.random.nextLong());
        this.nonces.put(nonce, new Nonce(nonce, apiUrl, true));
        return nonce;
    }

    public String getLongLivedNonce(String apiUrl) {
        String nonce = Long.toHexString(this.random.nextLong());
        this.nonces.put(nonce, new Nonce(nonce, apiUrl, false));
        return nonce;
    }

    public boolean hasValidKey(HttpMessage msg) {
        try {
            return this.hasValidKey(msg.getRequestHeader(), API.getParams(msg.getRequestHeader().getURI().getEscapedQuery()));
        }
        catch (ApiException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasValidKey(HttpRequestHeader reqHeader, JSONObject params) {
        try {
            String apiPath;
            try {
                apiPath = reqHeader.getURI().getPath();
            }
            catch (URIException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                boolean bl = false;
                Map<String, Nonce> map = this.nonces;
                synchronized (map) {
                    for (Map.Entry<String, Nonce> entry : this.nonces.entrySet()) {
                        if (entry.getValue().isValid()) continue;
                        this.nonces.remove(entry.getKey());
                    }
                }
                return bl;
            }
            String nonceParam = reqHeader.getHeader("X-ZAP-API-Nonce");
            if (nonceParam == null && params.has(API_NONCE_PARAM)) {
                nonceParam = params.getString(API_NONCE_PARAM);
            }
            if (nonceParam != null) {
                Nonce nonce = this.nonces.get(nonceParam);
                if (nonce == null) {
                    logger.warn((Object)("API nonce " + nonceParam + " not found in request from " + reqHeader.getSenderAddress().getHostAddress()));
                    boolean bl = false;
                    return bl;
                }
                if (nonce.isOneTime()) {
                    this.nonces.remove(nonceParam);
                }
                if (!nonce.isValid()) {
                    logger.warn((Object)("API nonce " + nonce.getNonceKey() + " expired at " + nonce.getExpires().toString() + " in request from " + reqHeader.getSenderAddress().getHostAddress()));
                    boolean bl = false;
                    return bl;
                }
                if (!apiPath.equals(nonce.getApiPath())) {
                    logger.warn((Object)("API nonce path was " + nonce.getApiPath() + " but call was for " + apiPath + " in request from " + reqHeader.getSenderAddress().getHostAddress()));
                    boolean bl = false;
                    return bl;
                }
            } else {
                String keyParam = reqHeader.getHeader("X-ZAP-API-Key");
                if (keyParam == null && params.has(API_KEY_PARAM)) {
                    keyParam = params.getString(API_KEY_PARAM);
                }
                if (!this.getOptionsParamApi().getKey().equals(keyParam)) {
                    logger.warn((Object)("API key incorrect or not supplied: " + keyParam + " in request from " + reqHeader.getSenderAddress().getHostAddress()));
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Map<String, Nonce> map = this.nonces;
            synchronized (map) {
                for (Map.Entry<String, Nonce> entry : this.nonces.entrySet()) {
                    if (entry.getValue().isValid()) continue;
                    this.nonces.remove(entry.getKey());
                }
            }
        }
    }

    public static String getDefaultResponseHeader(String contentType) {
        return API.getDefaultResponseHeader(contentType, 0);
    }

    public static String getDefaultResponseHeader(String contentType, int contentLength) {
        return API.getDefaultResponseHeader(STATUS_OK, contentType, contentLength, false);
    }

    public static String getDefaultResponseHeader(String contentType, int contentLength, boolean canCache) {
        return API.getDefaultResponseHeader(STATUS_OK, contentType, contentLength, canCache);
    }

    public static String getDefaultResponseHeader(String responseStatus, String contentType, int contentLength) {
        return API.getDefaultResponseHeader(responseStatus, contentType, contentLength, false);
    }

    public static String getDefaultResponseHeader(String responseStatus, String contentType, int contentLength, boolean canCache) {
        StringBuilder sb = new StringBuilder(250);
        sb.append("HTTP/1.1 ").append(responseStatus).append("\r\n");
        if (!canCache) {
            sb.append("Pragma: no-cache\r\n");
            sb.append("Cache-Control: no-cache\r\n");
        }
        sb.append("Content-Security-Policy: default-src 'none'; script-src 'self'; connect-src 'self'; child-src 'self'; img-src 'self' data:; font-src 'self' data:; style-src 'self'\r\n");
        sb.append("Referrer-Policy: no-referrer\r\n");
        sb.append("Access-Control-Allow-Methods: GET,POST,OPTIONS\r\n");
        sb.append("Access-Control-Allow-Headers: ZAP-Header\r\n");
        sb.append("X-Frame-Options: DENY\r\n");
        sb.append("X-XSS-Protection: 1; mode=block\r\n");
        sb.append("X-Content-Type-Options: nosniff\r\n");
        sb.append("X-Clacks-Overhead: GNU Terry Pratchett\r\n");
        sb.append("Content-Length: ").append(contentLength).append("\r\n");
        sb.append("Content-Type: ").append(contentType).append("\r\n");
        return sb.toString();
    }

    private void handleException(HttpMessage msg, Format format, String contentType, Exception cause) {
        String responseStatus = STATUS_INTERNAL_SERVER_ERROR;
        if (format == Format.OTHER) {
            boolean logError = true;
            if (cause instanceof ApiException) {
                switch (((ApiException)cause).getType()) {
                    case DISABLED: {
                        responseStatus = STATUS_BAD_REQUEST;
                        logger.warn((Object)"ApiException while handling API request:", (Throwable)cause);
                        logError = false;
                        break;
                    }
                    case BAD_TYPE: 
                    case NO_IMPLEMENTOR: 
                    case BAD_API_KEY: 
                    case MISSING_PARAMETER: 
                    case BAD_ACTION: 
                    case BAD_VIEW: 
                    case BAD_OTHER: {
                        responseStatus = STATUS_BAD_REQUEST;
                        logger.warn((Object)"API 'other' malformed request:", (Throwable)cause);
                        logError = false;
                        break;
                    }
                }
            }
            if (logError) {
                logger.error((Object)"API 'other' endpoint didn't handle exception:", (Throwable)cause);
            }
        } else {
            ApiException exception;
            if (cause instanceof ApiException) {
                exception = (ApiException)cause;
                if (!ApiException.Type.INTERNAL_ERROR.equals((Object)exception.getType())) {
                    responseStatus = STATUS_BAD_REQUEST;
                    logger.warn((Object)"ApiException while handling API request:", (Throwable)cause);
                }
            } else {
                exception = new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)cause);
                logger.error((Object)"Exception while handling API request:", (Throwable)cause);
            }
            String response = exception.toString(format, this.getOptionsParamApi().isIncErrorDetails());
            msg.getResponseBody().setCharset(API.getCharset(contentType));
            msg.getResponseBody().setBody(response);
        }
        try {
            msg.setResponseHeader(API.getDefaultResponseHeader(responseStatus, contentType, msg.getResponseBody().length()));
        }
        catch (HttpMalformedHeaderException e) {
            logger.warn((Object)"Failed to build API error response:", (Throwable)e);
        }
    }

    private static String getCharset(String contentType) {
        int idx = contentType.indexOf("charset=");
        if (idx == -1) {
            return "UTF-8";
        }
        return contentType.substring(idx + 8);
    }

    private class Nonce {
        private final String nonceKey;
        private final String apiPath;
        private final boolean oneTime;
        private final Date expires;

        public Nonce(String nonceKey, String apiStr, boolean oneTime) {
            this.nonceKey = nonceKey;
            this.apiPath = apiStr;
            this.oneTime = oneTime;
            this.expires = DateUtils.addSeconds((Date)new Date(), (int)API.this.getOptionsParamApi().getNonceTimeToLiveInSecs());
        }

        public String getNonceKey() {
            return this.nonceKey;
        }

        public String getApiPath() {
            return this.apiPath;
        }

        public boolean isOneTime() {
            return this.oneTime;
        }

        public boolean isValid() {
            return !this.oneTime || this.expires.after(new Date());
        }

        public Date getExpires() {
            return this.expires;
        }
    }

    public static enum RequestType {
        action,
        view,
        other;

    }

    public static enum Format {
        XML,
        HTML,
        JSON,
        JSONP,
        UI,
        OTHER;

    }
}

