/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.util.Collections;
import java.util.Comparator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.parosproxy.paros.core.scanner.Alert;

public class AlertNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;
    private final Comparator<AlertNode> childComparator;
    private String nodeName = null;
    private int risk = -1;
    private Alert alert;

    public AlertNode(int risk, String nodeName) {
        this(risk, nodeName, null);
    }

    public AlertNode(int risk, String nodeName, Comparator<AlertNode> childComparator) {
        this.nodeName = nodeName;
        this.setRisk(risk);
        this.childComparator = childComparator;
    }

    @Override
    public void setUserObject(Object userObject) {
        if (!(userObject instanceof Alert)) {
            throw new IllegalArgumentException("Parameter userObject must be an Alert.");
        }
        this.alert = (Alert)userObject;
    }

    @Override
    public Alert getUserObject() {
        return this.alert;
    }

    @Override
    public AlertNode getChildAt(int index) {
        return (AlertNode)super.getChildAt(index);
    }

    @Override
    public AlertNode getParent() {
        return (AlertNode)super.getParent();
    }

    @Override
    public void add(MutableTreeNode newChild) {
        if (!(newChild instanceof AlertNode)) {
            throw new IllegalArgumentException("Parameter newChild must be an AlertNode.");
        }
        super.add(newChild);
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        if (!(newChild instanceof AlertNode)) {
            throw new IllegalArgumentException("Parameter newChild must be an AlertNode.");
        }
        super.insert(newChild, childIndex);
    }

    @Override
    public int getIndex(TreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!(aChild instanceof AlertNode)) {
            return -1;
        }
        if (!this.isNodeChild(aChild)) {
            return -1;
        }
        int idx = this.findIndex((AlertNode)aChild);
        if (idx < 0) {
            return -1;
        }
        return idx;
    }

    public int findIndex(AlertNode aChild) {
        if (this.children == null) {
            return -1;
        }
        int idx = Collections.binarySearch(this.children, aChild, this.childComparator);
        return idx;
    }

    @Override
    public String toString() {
        if (this.getChildCount() > 1) {
            return this.nodeName + " (" + this.getChildCount() + ")";
        }
        return this.nodeName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setRisk(int risk) {
        this.risk = risk;
    }

    public int getRisk() {
        return this.risk;
    }
}

