/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.Vector;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.HelpUtilities;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.extension.ExtensionLoader;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnLoader;
import org.zaproxy.zap.control.CoreFunctionality;
import org.zaproxy.zap.extension.ext.ExtensionParam;
import org.zaproxy.zap.extension.help.ExtensionHelp;

public class ExtensionFactory {
    private static Logger log = Logger.getLogger(ExtensionFactory.class);
    private static Vector<Extension> listAllExtension = new Vector();
    private static TreeMap<String, Extension> mapAllExtension = new TreeMap();
    private static TreeMap<Integer, Extension> mapOrderToExtension = new TreeMap();
    private static List<Extension> unorderedExtensions = new ArrayList<Extension>();
    private static AddOnLoader addOnLoader = null;

    private static AddOnLoader getAddOnLoader(List<File> extraDirs) {
        if (addOnLoader == null) {
            File[] dirs = new File[extraDirs.size() + 2];
            dirs[0] = new File(Constant.getZapInstall(), "plugin");
            dirs[1] = new File(Constant.getZapHome(), "plugin");
            for (int i = 0; i < extraDirs.size(); ++i) {
                dirs[2 + i] = extraDirs.get(i);
            }
            addOnLoader = new AddOnLoader(dirs);
            log.info((Object)("Installed add-ons: " + addOnLoader.getAddOnCollection().getInstalledAddOns()));
        } else {
            log.error((Object)"AddOnLoader initialised without additional directories");
        }
        return addOnLoader;
    }

    public static AddOnLoader getAddOnLoader() {
        if (addOnLoader == null) {
            addOnLoader = new AddOnLoader(new File[]{new File(Constant.getZapInstall(), "plugin"), new File(Constant.getZapHome(), "plugin")});
            log.info((Object)("Installed add-ons: " + addOnLoader.getAddOnCollection().getInstalledAddOns()));
        }
        return addOnLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void loadAllExtension(ExtensionLoader extensionLoader, OptionsParam optionsParam) {
        log.info((Object)"Loading extensions");
        ArrayList<Extension> listExts = new ArrayList<Extension>(CoreFunctionality.getBuiltInExtensions());
        listExts.addAll(ExtensionFactory.getAddOnLoader(optionsParam.getCheckForUpdatesParam().getAddonDirectories()).getExtensions());
        ExtensionParam extParam = optionsParam.getExtensionParam();
        TreeMap<String, Extension> treeMap = mapAllExtension;
        synchronized (treeMap) {
            mapAllExtension.clear();
            for (int i = 0; i < listExts.size(); ++i) {
                Extension extension = (Extension)listExts.get(i);
                if (mapAllExtension.containsKey(extension.getName())) {
                    if (mapAllExtension.get(extension.getName()).getClass().equals(extension.getClass())) {
                        log.error((Object)("Duplicate extension: " + extension.getName() + " " + extension.getClass().getCanonicalName()));
                        continue;
                    }
                    log.error((Object)("Duplicate extension name: " + extension.getName() + " " + extension.getClass().getCanonicalName() + " " + mapAllExtension.get(extension.getName()).getClass().getCanonicalName()));
                }
                if (extension.isDepreciated()) {
                    log.debug((Object)("Depreciated extension " + extension.getName()));
                    continue;
                }
                extension.setEnabled(extParam.isExtensionEnabled(extension.getName()));
                listAllExtension.add(extension);
                mapAllExtension.put(extension.getName(), extension);
                int order = extension.getOrder();
                if (order == 0) {
                    unorderedExtensions.add(extension);
                    continue;
                }
                if (mapOrderToExtension.containsKey(order)) {
                    log.error((Object)("Duplicate order " + order + " " + mapOrderToExtension.get(order).getName() + "/" + mapOrderToExtension.get(order).getClass().getCanonicalName() + " already registered, " + extension.getName() + "/" + extension.getClass().getCanonicalName() + " will be added as an unordered extension"));
                    unorderedExtensions.add(extension);
                    continue;
                }
                mapOrderToExtension.put(order, extension);
            }
            for (Integer order : mapOrderToExtension.keySet()) {
                Extension ext = mapOrderToExtension.get(order);
                if (ext.isEnabled()) {
                    log.debug((Object)("Ordered extension " + order + " " + ext.getName()));
                }
                ExtensionFactory.loadMessagesAndAddExtension(extensionLoader, ext);
            }
            for (Extension ext : unorderedExtensions) {
                if (ext.isEnabled()) {
                    log.debug((Object)("Unordered extension " + ext.getName()));
                }
                ExtensionFactory.loadMessagesAndAddExtension(extensionLoader, ext);
            }
        }
        log.info((Object)"Extensions loaded");
    }

    private static void loadMessagesAndAddExtension(ExtensionLoader extensionLoader, Extension extension) {
        ExtensionFactory.loadMessages(extension);
        if (extension.isEnabled() && extension.supportsDb(Model.getSingleton().getDb().getType()) && (extension.supportsLowMemory() || !Constant.isLowMemoryOptionSet())) {
            extensionLoader.addExtension(extension);
            ExtensionFactory.intitializeHelpSet(extension);
        } else if (!extension.supportsDb(Model.getSingleton().getDb().getType())) {
            log.debug((Object)("Not loading extension " + extension.getName() + ": doesnt support " + Model.getSingleton().getDb().getType()));
        } else if (extension.supportsLowMemory() || !Constant.isLowMemoryOptionSet()) {
            log.debug((Object)("Not loading extension " + extension.getName() + ": doesnt support low memory option"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void addAddOnExtension(ExtensionLoader extensionLoader, Configuration config, Extension extension) {
        TreeMap<String, Extension> treeMap = mapAllExtension;
        synchronized (treeMap) {
            ExtensionFactory.addExtensionImpl(extension);
            if (extension.isEnabled()) {
                log.debug((Object)("Adding new extension " + extension.getName()));
            }
            ExtensionFactory.loadMessagesAndAddExtension(extensionLoader, extension);
        }
    }

    private static void addExtensionImpl(Extension extension) {
        if (mapAllExtension.containsKey(extension.getName())) {
            if (mapAllExtension.get(extension.getName()).getClass().equals(extension.getClass())) {
                log.debug((Object)("Duplicate extension: " + extension.getName() + " " + extension.getClass().getCanonicalName()));
                extension.setEnabled(false);
                return;
            }
            log.error((Object)("Duplicate extension name: " + extension.getName() + " " + extension.getClass().getCanonicalName() + " " + mapAllExtension.get(extension.getName()).getClass().getCanonicalName()));
        }
        if (extension.isDepreciated()) {
            log.debug((Object)("Depreciated extension " + extension.getName()));
            return;
        }
        ExtensionParam extensionParam = Model.getSingleton().getOptionsParam().getExtensionParam();
        extension.setEnabled(extensionParam.isExtensionEnabled(extension.getName()));
        listAllExtension.add(extension);
        mapAllExtension.put(extension.getName(), extension);
        int order = extension.getOrder();
        if (order == 0) {
            unorderedExtensions.add(extension);
        } else if (mapOrderToExtension.containsKey(order)) {
            log.error((Object)("Duplicate order " + order + " " + mapOrderToExtension.get(order).getName() + "/" + mapOrderToExtension.get(order).getClass().getCanonicalName() + " already registered, " + extension.getName() + "/" + extension.getClass().getCanonicalName() + " will be added as an unordered extension"));
            unorderedExtensions.add(extension);
        } else {
            mapOrderToExtension.put(order, extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List<Extension> loadAddOnExtensions(ExtensionLoader extensionLoader, Configuration config, AddOn addOn) {
        List<Extension> listExts = ExtensionFactory.getAddOnLoader().getExtensions(addOn);
        TreeMap<String, Extension> treeMap = mapAllExtension;
        synchronized (treeMap) {
            for (Extension extension : listExts) {
                ExtensionFactory.addExtensionImpl(extension);
            }
            for (Extension ext : listExts) {
                if (ext.isEnabled()) {
                    log.debug((Object)("Adding new extension " + ext.getName()));
                }
                ExtensionFactory.loadMessagesAndAddExtension(extensionLoader, ext);
            }
        }
        return listExts;
    }

    private static void loadMessages(Extension ext) {
        ResourceBundle msg = ExtensionFactory.getExtensionResourceBundle(ext);
        if (msg != null) {
            ext.setMessages(msg);
            Constant.messages.addMessageBundle(ext.getI18nPrefix(), ext.getMessages());
        }
    }

    private static ResourceBundle getExtensionResourceBundle(Extension ext) {
        String extensionPackage = ext.getClass().getPackage().getName();
        ClassLoader classLoader = ext.getClass().getClassLoader();
        try {
            String name = extensionPackage + ".resources." + "Messages";
            return ExtensionFactory.getPropertiesResourceBundle(name, classLoader);
        }
        catch (MissingResourceException ignore) {
            String oldLocation = extensionPackage + "." + "Messages";
            try {
                return ExtensionFactory.getPropertiesResourceBundle(oldLocation, classLoader);
            }
            catch (MissingResourceException missingResourceException) {
                return null;
            }
        }
    }

    private static ResourceBundle getPropertiesResourceBundle(String name, ClassLoader classLoader) throws MissingResourceException {
        return ResourceBundle.getBundle(name, Constant.getLocale(), classLoader, ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES));
    }

    private static void intitializeHelpSet(Extension ext) {
        HelpBroker hb = ExtensionHelp.getHelpBroker();
        if (hb == null) {
            return;
        }
        URL helpSetUrl = ExtensionFactory.getExtensionHelpSetUrl(ext);
        if (helpSetUrl != null) {
            try {
                log.debug((Object)("Load help files for extension '" + ext.getName() + "' and merge with core help."));
                HelpSet extHs = new HelpSet(ext.getClass().getClassLoader(), helpSetUrl);
                hb.getHelpSet().add(extHs);
            }
            catch (HelpSetException e) {
                log.error((Object)("An error occured while adding help file of extension '" + ext.getName() + "': " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static URL getExtensionHelpSetUrl(Extension extension) {
        String extensionPackage = extension.getClass().getPackage().getName().replace('.', '/') + "/";
        URL helpSetUrl = ExtensionFactory.findResource(extension.getClass().getClassLoader(), extensionPackage + "resources/help", "helpset", ".hs", Constant.getLocale());
        if (helpSetUrl == null) {
            helpSetUrl = ExtensionFactory.findResource(extension.getClass().getClassLoader(), extensionPackage + "resource/help", "helpset", ".hs", Constant.getLocale());
        }
        return helpSetUrl;
    }

    public static List<Extension> getAllExtensions() {
        return listAllExtension;
    }

    public static Extension getExtension(String name) {
        Extension test = mapAllExtension.get(name);
        return test;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unloadAddOnExtension(Extension extension) {
        TreeMap<String, Extension> treeMap = mapAllExtension;
        synchronized (treeMap) {
            ExtensionFactory.unloadMessages(extension);
            ExtensionFactory.unloadHelpSet(extension);
            mapAllExtension.remove(extension.getName());
            listAllExtension.remove(extension);
            boolean isUnordered = true;
            Iterator<Extension> it = mapOrderToExtension.values().iterator();
            while (it.hasNext()) {
                if (it.next() != extension) continue;
                it.remove();
                isUnordered = false;
                break;
            }
            if (isUnordered) {
                unorderedExtensions.remove(extension);
            }
        }
    }

    private static void unloadMessages(Extension extension) {
        ResourceBundle msg = extension.getMessages();
        if (msg != null) {
            Constant.messages.removeMessageBundle(extension.getI18nPrefix());
        }
    }

    private static void unloadHelpSet(Extension ext) {
        HelpBroker hb = ExtensionHelp.getHelpBroker();
        if (hb == null) {
            return;
        }
        URL helpSetUrl = ExtensionFactory.getExtensionHelpSetUrl(ext);
        if (helpSetUrl != null) {
            HelpSet baseHelpSet = hb.getHelpSet();
            Enumeration helpSets = baseHelpSet.getHelpSets();
            while (helpSets.hasMoreElements()) {
                HelpSet extensionHelpSet = (HelpSet)helpSets.nextElement();
                if (!helpSetUrl.equals(extensionHelpSet.getHelpSetURL())) continue;
                baseHelpSet.remove(extensionHelpSet);
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static URL findResource(ClassLoader cl, String packageName, String fileName, String fileExtension, Locale locale) {
        Enumeration candidateLocales = HelpUtilities.getCandidates((Locale)locale);
        while (candidateLocales.hasMoreElements()) {
            String candidateLocale = (String)candidateLocales.nextElement();
            String resource = packageName + candidateLocale + '/' + fileName + candidateLocale + fileExtension;
            URL url = cl == null ? ClassLoader.getSystemResource(resource) : cl.getResource(resource);
            if (url == null) continue;
            try {
                InputStream is = url.openConnection().getInputStream();
                Throwable throwable = null;
                try {
                    if (is == null || is.read() == -1) continue;
                    URL uRL = url;
                    return uRL;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (Throwable throwable7) {}
        }
        return null;
    }
}

