/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.extension.Extension;
import org.zaproxy.zap.Version;
import org.zaproxy.zap.control.AddOnClassnames;
import org.zaproxy.zap.control.BaseZapAddOnXmlData;
import org.zaproxy.zap.control.ZapAddOnXmlFile;
import org.zaproxy.zap.control.ZapRelease;
import org.zaproxy.zap.control.ZapReleaseComparitor;
import org.zaproxy.zap.control.ZapVersionsAddOnEntry;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;

public class AddOn {
    public static final String MANIFEST_FILE_NAME = "ZapAddOn.xml";
    private static ZapRelease v2_4 = new ZapRelease("2.4.0");
    public static final String FILE_EXTENSION = ".zap";
    private String id;
    private String name;
    private String description;
    private String author;
    private int fileVersion;
    private Version version;
    private Status status;
    private String changes;
    private File file;
    private URL url;
    private URL info;
    private long size;
    private boolean hasZapAddOnEntry;
    private boolean manifestRead;
    private String notBeforeVersion;
    private String notFromVersion;
    private String hash;
    private InstallationStatus installationStatus;
    private List<String> extensions;
    private List<BaseZapAddOnXmlData.ExtensionWithDeps> extensionsWithDeps;
    private List<Extension> loadedExtensions;
    private List<String> ascanrules;
    private List<AbstractPlugin> loadedAscanrules;
    private boolean loadedAscanRulesSet;
    private List<String> pscanrules;
    private List<PluginPassiveScanner> loadedPscanrules;
    private boolean loadedPscanRulesSet;
    private List<String> files;
    private AddOnClassnames addOnClassnames;
    private BaseZapAddOnXmlData.Dependencies dependencies;
    private static final Logger logger = Logger.getLogger(AddOn.class);

    @Deprecated
    public static boolean isAddOn(String fileName) {
        if (!AddOn.isAddOnFileName(fileName)) {
            return false;
        }
        if (fileName.substring(0, fileName.indexOf(".")).split("-").length < 3) {
            return false;
        }
        String[] strArray = fileName.substring(0, fileName.indexOf(".")).split("-");
        try {
            Status.valueOf(strArray[1]);
            Integer.parseInt(strArray[2]);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isAddOnFileName(String fileName) {
        if (fileName == null) {
            return false;
        }
        return fileName.toLowerCase(Locale.ROOT).endsWith(FILE_EXTENSION);
    }

    @Deprecated
    public static boolean isAddOn(File f) {
        return AddOn.isAddOn(f.toPath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAddOn(Path file) {
        if (file == null) return false;
        if (file.getNameCount() == 0) {
            return false;
        }
        if (!AddOn.isAddOnFileName(file.getFileName().toString())) {
            return false;
        }
        if (!Files.isRegularFile(file, new LinkOption[0])) return false;
        if (!Files.isReadable(file)) {
            return false;
        }
        try (ZipFile zip = new ZipFile(file.toFile());){
            boolean bl = zip.getEntry(MANIFEST_FILE_NAME) != null;
            return bl;
        }
        catch (Exception e) {
            if (!logger.isDebugEnabled()) return false;
            logger.debug((Object)"Failed to obtain ZapAddOn.xml entry:", (Throwable)e);
            return false;
        }
    }

    @Deprecated
    public AddOn(String fileName) throws Exception {
        this.description = "";
        this.author = "";
        this.changes = "";
        this.file = null;
        this.url = null;
        this.info = null;
        this.size = 0L;
        this.hasZapAddOnEntry = false;
        this.notBeforeVersion = null;
        this.notFromVersion = null;
        this.hash = null;
        this.installationStatus = InstallationStatus.NOT_INSTALLED;
        this.extensions = Collections.emptyList();
        this.extensionsWithDeps = Collections.emptyList();
        this.ascanrules = Collections.emptyList();
        this.loadedAscanrules = Collections.emptyList();
        this.pscanrules = Collections.emptyList();
        this.loadedPscanrules = Collections.emptyList();
        this.files = Collections.emptyList();
        this.addOnClassnames = AddOnClassnames.ALL_ALLOWED;
        if (!AddOn.isAddOn(fileName)) {
            throw new Exception("Invalid ZAP add-on file " + fileName);
        }
        String[] strArray = fileName.substring(0, fileName.indexOf(".")).split("-");
        this.name = this.id = strArray[0];
        this.status = Status.valueOf(strArray[1]);
        this.fileVersion = Integer.parseInt(strArray[2]);
    }

    @Deprecated
    public AddOn(File file) throws Exception {
        this(file.toPath());
    }

    public AddOn(Path file) throws IOException {
        this.description = "";
        this.author = "";
        this.changes = "";
        this.file = null;
        this.url = null;
        this.info = null;
        this.size = 0L;
        this.hasZapAddOnEntry = false;
        this.notBeforeVersion = null;
        this.notFromVersion = null;
        this.hash = null;
        this.installationStatus = InstallationStatus.NOT_INSTALLED;
        this.extensions = Collections.emptyList();
        this.extensionsWithDeps = Collections.emptyList();
        this.ascanrules = Collections.emptyList();
        this.loadedAscanrules = Collections.emptyList();
        this.pscanrules = Collections.emptyList();
        this.loadedPscanrules = Collections.emptyList();
        this.files = Collections.emptyList();
        this.addOnClassnames = AddOnClassnames.ALL_ALLOWED;
        if (!AddOn.isAddOn(file)) {
            throw new IOException("Invalid ZAP add-on file " + (file != null ? file.toAbsolutePath() : "[null]"));
        }
        this.id = AddOn.extractAddOnId(file.getFileName().toString());
        this.file = file.toFile();
        this.loadManifestFile();
    }

    private static String extractAddOnId(String fileName) {
        return fileName.substring(0, fileName.indexOf(46)).split("-")[0];
    }

    private void loadManifestFile() throws IOException {
        this.manifestRead = true;
        if (this.file.exists()) {
            try (ZipFile zip = new ZipFile(this.file);){
                ZipEntry zapAddOnEntry = zip.getEntry(MANIFEST_FILE_NAME);
                if (zapAddOnEntry == null) {
                    throw new IOException("Add-on does not have the ZapAddOn.xml file.");
                }
                try (InputStream zis = zip.getInputStream(zapAddOnEntry);){
                    ZapAddOnXmlFile zapAddOnXml = new ZapAddOnXmlFile(zis);
                    this.name = zapAddOnXml.getName();
                    this.fileVersion = zapAddOnXml.getPackageVersion();
                    this.version = zapAddOnXml.getVersion();
                    this.status = Status.valueOf(zapAddOnXml.getStatus());
                    this.description = zapAddOnXml.getDescription();
                    this.changes = zapAddOnXml.getChanges();
                    this.author = zapAddOnXml.getAuthor();
                    this.notBeforeVersion = zapAddOnXml.getNotBeforeVersion();
                    this.notFromVersion = zapAddOnXml.getNotFromVersion();
                    this.dependencies = zapAddOnXml.getDependencies();
                    this.ascanrules = zapAddOnXml.getAscanrules();
                    this.extensions = zapAddOnXml.getExtensions();
                    this.extensionsWithDeps = zapAddOnXml.getExtensionsWithDeps();
                    this.files = zapAddOnXml.getFiles();
                    this.pscanrules = zapAddOnXml.getPscanrules();
                    this.addOnClassnames = zapAddOnXml.getAddOnClassnames();
                    this.hasZapAddOnEntry = true;
                }
            }
        }
    }

    public AddOn(String id, File baseDir, SubnodeConfiguration xmlData) throws MalformedURLException, IOException {
        ZapVersionsAddOnEntry addOnData;
        block3: {
            this.description = "";
            this.author = "";
            this.changes = "";
            this.file = null;
            this.url = null;
            this.info = null;
            this.size = 0L;
            this.hasZapAddOnEntry = false;
            this.notBeforeVersion = null;
            this.notFromVersion = null;
            this.hash = null;
            this.installationStatus = InstallationStatus.NOT_INSTALLED;
            this.extensions = Collections.emptyList();
            this.extensionsWithDeps = Collections.emptyList();
            this.ascanrules = Collections.emptyList();
            this.loadedAscanrules = Collections.emptyList();
            this.pscanrules = Collections.emptyList();
            this.loadedPscanrules = Collections.emptyList();
            this.files = Collections.emptyList();
            this.addOnClassnames = AddOnClassnames.ALL_ALLOWED;
            this.id = id;
            addOnData = new ZapVersionsAddOnEntry((HierarchicalConfiguration)xmlData);
            this.name = addOnData.getName();
            this.description = addOnData.getDescription();
            this.author = addOnData.getAuthor();
            this.fileVersion = addOnData.getPackageVersion();
            this.dependencies = addOnData.getDependencies();
            this.extensionsWithDeps = addOnData.getExtensionsWithDeps();
            this.version = addOnData.getVersion();
            this.status = Status.valueOf(addOnData.getStatus());
            this.changes = addOnData.getChanges();
            this.url = new URL(addOnData.getUrl());
            this.file = new File(baseDir, addOnData.getFile());
            this.size = addOnData.getSize();
            this.notBeforeVersion = addOnData.getNotBeforeVersion();
            this.notFromVersion = addOnData.getNotFromVersion();
            if (addOnData.getInfo() != null && !addOnData.getInfo().isEmpty()) {
                try {
                    this.info = new URL(addOnData.getInfo());
                }
                catch (Exception ignore) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug((Object)("Wrong info URL for add-on \"" + this.name + "\":"), (Throwable)ignore);
                }
            }
        }
        this.hash = addOnData.getHash();
        this.loadManifestFile();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getFileVersion() {
        return this.fileVersion;
    }

    public Version getVersion() {
        return this.version;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getChanges() {
        return this.changes;
    }

    public void setChanges(String changes) {
        this.changes = changes;
    }

    public String getNormalisedFileName() {
        return this.getId() + "-" + this.getFileVersion() + FILE_EXTENSION;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setInstallationStatus(InstallationStatus installationStatus) {
        if (installationStatus == null) {
            throw new IllegalArgumentException("Parameter installationStatus must not be null.");
        }
        this.installationStatus = installationStatus;
    }

    public InstallationStatus getInstallationStatus() {
        return this.installationStatus;
    }

    public boolean hasZapAddOnEntry() {
        block3: {
            if (!this.hasZapAddOnEntry && !this.manifestRead) {
                try {
                    this.loadManifestFile();
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug((Object)("Failed to read the ZapAddOn.xml file of " + this.id + ":"), (Throwable)e);
                }
            }
        }
        return this.hasZapAddOnEntry;
    }

    public AddOnClassnames getAddOnClassnames() {
        return this.addOnClassnames;
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public List<String> getExtensionsWithDeps() {
        if (this.extensionsWithDeps.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> extensionClassnames = new ArrayList<String>(this.extensionsWithDeps.size());
        for (BaseZapAddOnXmlData.ExtensionWithDeps extension : this.extensionsWithDeps) {
            extensionClassnames.add(extension.getClassname());
        }
        return extensionClassnames;
    }

    public AddOnClassnames getExtensionAddOnClassnames(String classname) {
        if (this.extensionsWithDeps.isEmpty() || classname == null || classname.isEmpty()) {
            return AddOnClassnames.ALL_ALLOWED;
        }
        for (BaseZapAddOnXmlData.ExtensionWithDeps extension : this.extensionsWithDeps) {
            if (!classname.equals(extension.getClassname())) continue;
            return extension.getAddOnClassnames();
        }
        return AddOnClassnames.ALL_ALLOWED;
    }

    public boolean hasExtensionsWithDeps() {
        return !this.extensionsWithDeps.isEmpty();
    }

    public List<Extension> getLoadedExtensionsWithDeps() {
        List<String> classnames = this.getExtensionsWithDeps();
        ArrayList<Extension> loadedExtensions = new ArrayList<Extension>(this.extensionsWithDeps.size());
        for (Extension extension : this.getLoadedExtensions()) {
            if (!classnames.contains(extension.getClass().getCanonicalName())) continue;
            loadedExtensions.add(extension);
        }
        loadedExtensions.trimToSize();
        return loadedExtensions;
    }

    public List<Extension> getLoadedExtensions() {
        if (this.loadedExtensions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.loadedExtensions);
    }

    public void addLoadedExtension(Extension extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Parameter extension must not be null.");
        }
        if (this.loadedExtensions == null) {
            this.loadedExtensions = new ArrayList<Extension>(1);
        }
        if (!this.loadedExtensions.contains(extension)) {
            this.loadedExtensions.add(extension);
            extension.setAddOn(this);
        }
    }

    public void removeLoadedExtension(Extension extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Parameter extension must not be null.");
        }
        if (this.loadedExtensions != null && this.loadedExtensions.contains(extension)) {
            this.loadedExtensions.remove(extension);
            extension.setAddOn(null);
        }
    }

    public List<String> getAscanrules() {
        return this.ascanrules;
    }

    public List<AbstractPlugin> getLoadedAscanrules() {
        return this.loadedAscanrules;
    }

    void setLoadedAscanrules(List<AbstractPlugin> ascanrules) {
        if (ascanrules == null) {
            throw new IllegalArgumentException("Parameter ascanrules must not be null.");
        }
        if (ascanrules.isEmpty()) {
            this.loadedAscanrules = Collections.emptyList();
            return;
        }
        for (AbstractPlugin ascanrule : ascanrules) {
            ascanrule.setStatus(this.getStatus());
        }
        this.loadedAscanrules = Collections.unmodifiableList(new ArrayList<AbstractPlugin>(ascanrules));
    }

    boolean isLoadedAscanrulesSet() {
        return this.loadedAscanRulesSet;
    }

    void setLoadedAscanrulesSet(boolean ascanrulesSet) {
        this.loadedAscanRulesSet = ascanrulesSet;
    }

    public List<String> getPscanrules() {
        return this.pscanrules;
    }

    public List<PluginPassiveScanner> getLoadedPscanrules() {
        return this.loadedPscanrules;
    }

    void setLoadedPscanrules(List<PluginPassiveScanner> pscanrules) {
        if (pscanrules == null) {
            throw new IllegalArgumentException("Parameter pscanrules must not be null.");
        }
        if (pscanrules.isEmpty()) {
            this.loadedPscanrules = Collections.emptyList();
            return;
        }
        for (PluginPassiveScanner pscanrule : pscanrules) {
            pscanrule.setStatus(this.getStatus());
        }
        this.loadedPscanrules = Collections.unmodifiableList(new ArrayList<PluginPassiveScanner>(pscanrules));
    }

    boolean isLoadedPscanrulesSet() {
        return this.loadedPscanRulesSet;
    }

    void setLoadedPscanrulesSet(boolean pscanrulesSet) {
        this.loadedPscanRulesSet = pscanrulesSet;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public boolean isSameAddOn(AddOn addOn) {
        return this.getId().equals(addOn.getId());
    }

    public boolean isUpdateTo(AddOn addOn) throws IllegalArgumentException {
        if (!this.isSameAddOn(addOn)) {
            throw new IllegalArgumentException("Different addons: " + this.getId() + " != " + addOn.getId());
        }
        if (this.getFileVersion() > addOn.getFileVersion()) {
            return true;
        }
        return this.getStatus().ordinal() > addOn.getStatus().ordinal();
    }

    @Deprecated
    public boolean canLoad() {
        return false;
    }

    public boolean canLoadInCurrentVersion() {
        return this.canLoadInVersion(Constant.PROGRAM_VERSION);
    }

    public boolean canRunInCurrentJavaVersion() {
        return this.canRunInJavaVersion(SystemUtils.JAVA_VERSION);
    }

    public boolean canRunInJavaVersion(String javaVersion) {
        if (this.dependencies == null) {
            return true;
        }
        String requiredVersion = this.dependencies.getJavaVersion();
        if (requiredVersion == null) {
            return true;
        }
        if (javaVersion == null) {
            return false;
        }
        return AddOn.getJavaVersion(javaVersion) >= AddOn.getJavaVersion(requiredVersion);
    }

    public AddOnRunRequirements calculateRunRequirements(Collection<AddOn> availableAddOns) {
        AddOnRunRequirements requirements = new AddOnRunRequirements(this);
        AddOn.calculateRunRequirementsImpl(availableAddOns, requirements, null, this);
        if (requirements.isRunnable()) {
            AddOn.checkExtensionsWithDeps(availableAddOns, requirements, this);
        }
        return requirements;
    }

    private static void calculateRunRequirementsImpl(Collection<AddOn> availableAddOns, BaseRunRequirements requirements, AddOn parent, AddOn addOn) {
        AddOn installedVersion = AddOn.getAddOn(availableAddOns, addOn.getId());
        if (installedVersion != null && !addOn.equals(installedVersion)) {
            requirements.setIssue(BaseRunRequirements.DependencyIssue.OLDER_VERSION, installedVersion);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Add-on " + addOn + " not runnable, old version still installed: " + installedVersion));
            }
            return;
        }
        if (!requirements.addDependency(parent, addOn)) {
            logger.warn((Object)("Cyclic dependency detected with: " + requirements.getDependencies()));
            requirements.setIssue(BaseRunRequirements.DependencyIssue.CYCLIC, requirements.getDependencies());
            return;
        }
        if (addOn.dependencies == null) {
            return;
        }
        if (!addOn.canRunInCurrentJavaVersion()) {
            requirements.setMinimumJavaVersionIssue(addOn, addOn.dependencies.getJavaVersion());
        }
        for (BaseZapAddOnXmlData.AddOnDep dependency : addOn.dependencies.getAddOns()) {
            String addOnId = dependency.getId();
            if (addOnId == null) continue;
            AddOn addOnDep = AddOn.getAddOn(availableAddOns, addOnId);
            if (addOnDep == null) {
                requirements.setIssue(BaseRunRequirements.DependencyIssue.MISSING, addOnId);
                return;
            }
            if (dependency.getNotBeforeVersion() > -1 && addOnDep.fileVersion < dependency.getNotBeforeVersion()) {
                requirements.setIssue(BaseRunRequirements.DependencyIssue.PACKAGE_VERSION_NOT_BEFORE, addOnDep, dependency.getNotBeforeVersion());
                return;
            }
            if (dependency.getNotFromVersion() > -1 && addOnDep.fileVersion > dependency.getNotFromVersion()) {
                requirements.setIssue(BaseRunRequirements.DependencyIssue.PACKAGE_VERSION_NOT_FROM, addOnDep, dependency.getNotFromVersion());
                return;
            }
            if (!(dependency.getSemVer().isEmpty() || addOnDep.version != null && addOnDep.version.matches(dependency.getSemVer()))) {
                requirements.setIssue(BaseRunRequirements.DependencyIssue.VERSION, addOnDep, dependency.getSemVer());
                return;
            }
            AddOn.calculateRunRequirementsImpl(availableAddOns, requirements, addOn, addOnDep);
            if (!requirements.hasDependencyIssue()) continue;
            return;
        }
    }

    private static void checkExtensionsWithDeps(Collection<AddOn> availableAddOns, AddOnRunRequirements requirements, AddOn addOn) {
        if (addOn.extensionsWithDeps.isEmpty()) {
            return;
        }
        for (BaseZapAddOnXmlData.ExtensionWithDeps extension : addOn.extensionsWithDeps) {
            AddOn.calculateExtensionRunRequirements(extension, availableAddOns, requirements, addOn);
        }
    }

    private static void calculateExtensionRunRequirements(BaseZapAddOnXmlData.ExtensionWithDeps extension, Collection<AddOn> availableAddOns, AddOnRunRequirements requirements, AddOn addOn) {
        ExtensionRunRequirements extensionRequirements = new ExtensionRunRequirements(addOn, extension.getClassname());
        requirements.addExtensionRequirements(extensionRequirements);
        for (BaseZapAddOnXmlData.AddOnDep dependency : extension.getDependencies()) {
            String addOnId = dependency.getId();
            if (addOnId == null) continue;
            AddOn addOnDep = AddOn.getAddOn(availableAddOns, addOnId);
            if (addOnDep == null) {
                if (addOn.hasOnlyOneExtensionWithDependencies()) {
                    requirements.setIssue(BaseRunRequirements.DependencyIssue.MISSING, addOnId);
                    return;
                }
                extensionRequirements.setIssue(BaseRunRequirements.DependencyIssue.MISSING, addOnId);
                continue;
            }
            if (dependency.getNotBeforeVersion() > -1 && addOnDep.fileVersion < dependency.getNotBeforeVersion()) {
                if (addOn.hasOnlyOneExtensionWithDependencies()) {
                    requirements.setIssue(BaseRunRequirements.DependencyIssue.PACKAGE_VERSION_NOT_BEFORE, addOnDep, dependency.getNotBeforeVersion());
                    return;
                }
                extensionRequirements.setIssue(BaseRunRequirements.DependencyIssue.PACKAGE_VERSION_NOT_BEFORE, addOnDep, dependency.getNotBeforeVersion());
                continue;
            }
            if (dependency.getNotFromVersion() > -1 && addOnDep.fileVersion > dependency.getNotFromVersion()) {
                if (addOn.hasOnlyOneExtensionWithDependencies()) {
                    requirements.setIssue(BaseRunRequirements.DependencyIssue.PACKAGE_VERSION_NOT_FROM, addOnDep, dependency.getNotFromVersion());
                    return;
                }
                extensionRequirements.setIssue(BaseRunRequirements.DependencyIssue.PACKAGE_VERSION_NOT_FROM, addOnDep, dependency.getNotFromVersion());
                continue;
            }
            if (!(dependency.getSemVer().isEmpty() || addOnDep.version != null && addOnDep.version.matches(dependency.getSemVer()))) {
                if (addOn.hasOnlyOneExtensionWithDependencies()) {
                    requirements.setIssue(BaseRunRequirements.DependencyIssue.VERSION, addOnDep, dependency.getSemVer());
                    return;
                }
                extensionRequirements.setIssue(BaseRunRequirements.DependencyIssue.VERSION, addOnDep, dependency.getSemVer());
                continue;
            }
            AddOn.calculateRunRequirementsImpl(availableAddOns, extensionRequirements, addOn, addOnDep);
        }
    }

    private boolean hasOnlyOneExtensionWithDependencies() {
        if (this.extensionsWithDeps.size() != 1) {
            return false;
        }
        return this.extensions.isEmpty() && this.files.isEmpty() && this.pscanrules.isEmpty() && this.ascanrules.isEmpty();
    }

    public AddOnRunRequirements calculateExtensionRunRequirements(Extension extension, Collection<AddOn> availableAddOns) {
        return this.calculateExtensionRunRequirements(extension.getClass().getCanonicalName(), availableAddOns);
    }

    public AddOnRunRequirements calculateExtensionRunRequirements(String classname, Collection<AddOn> availableAddOns) {
        AddOnRunRequirements requirements = new AddOnRunRequirements(this);
        for (BaseZapAddOnXmlData.ExtensionWithDeps extensionWithDeps : this.extensionsWithDeps) {
            if (!extensionWithDeps.getClassname().equals(classname)) continue;
            AddOn.calculateExtensionRunRequirements(extensionWithDeps, availableAddOns, requirements, this);
            break;
        }
        return requirements;
    }

    public boolean dependsOn(Extension extension, AddOn addOn) {
        String classname = extension.getClass().getCanonicalName();
        for (BaseZapAddOnXmlData.ExtensionWithDeps extensionWithDeps : this.extensionsWithDeps) {
            if (!extensionWithDeps.getClassname().equals(classname)) continue;
            return AddOn.dependsOn(extensionWithDeps.getDependencies(), addOn);
        }
        return false;
    }

    private static boolean dependsOn(List<BaseZapAddOnXmlData.AddOnDep> dependencies, AddOn addOn) {
        for (BaseZapAddOnXmlData.AddOnDep dependency : dependencies) {
            if (!dependency.getId().equals(addOn.id)) continue;
            if (dependency.getNotBeforeVersion() > -1 && addOn.fileVersion < dependency.getNotBeforeVersion()) {
                return false;
            }
            if (dependency.getNotFromVersion() > -1 && addOn.fileVersion > dependency.getNotFromVersion()) {
                return false;
            }
            if (!dependency.getSemVer().isEmpty()) {
                if (addOn.version == null) {
                    return false;
                }
                if (!addOn.version.matches(dependency.getSemVer())) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean isExtensionLoaded(String classname) {
        ArrayList<Extension> allExtensions = new ArrayList<Extension>(this.getLoadedExtensions().size() + this.getLoadedExtensionsWithDeps().size());
        allExtensions.addAll(this.getLoadedExtensions());
        allExtensions.addAll(this.getLoadedExtensionsWithDeps());
        for (Extension extension : this.getLoadedExtensions()) {
            if (!classname.equals(extension.getClass().getCanonicalName())) continue;
            return true;
        }
        return false;
    }

    public String getMinimumJavaVersion() {
        if (this.dependencies == null) {
            return "";
        }
        return this.dependencies.getJavaVersion();
    }

    private static AddOn getAddOn(Collection<AddOn> addOns, String id) {
        for (AddOn addOn : addOns) {
            if (!addOn.getId().equals(id)) continue;
            return addOn;
        }
        return null;
    }

    public boolean canLoadInVersion(String zapVersion) {
        if (this.notBeforeVersion == null || this.notBeforeVersion.isEmpty()) {
            return false;
        }
        ZapReleaseComparitor zrc = new ZapReleaseComparitor();
        ZapRelease zr = new ZapRelease(zapVersion);
        ZapRelease notBeforeRelease = new ZapRelease(this.notBeforeVersion);
        if (zrc.compare(zr, notBeforeRelease) < 0) {
            return false;
        }
        if (zrc.compare(notBeforeRelease, v2_4) < 0) {
            return false;
        }
        if (this.notFromVersion != null && this.notFromVersion.length() > 0) {
            ZapRelease notFromRelease = new ZapRelease(this.notFromVersion);
            return zrc.compare(zr, notFromRelease) < 0;
        }
        return true;
    }

    public void setNotBeforeVersion(String notBeforeVersion) {
        this.notBeforeVersion = notBeforeVersion;
    }

    public void setNotFromVersion(String notFromVersion) {
        this.notFromVersion = notFromVersion;
    }

    public String getNotBeforeVersion() {
        return this.notBeforeVersion;
    }

    public String getNotFromVersion() {
        return this.notFromVersion;
    }

    public URL getInfo() {
        return this.info;
    }

    public void setInfo(URL info) {
        this.info = info;
    }

    public String getHash() {
        return this.hash;
    }

    public List<String> getIdsAddOnDependencies() {
        if (this.dependencies == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ids = new ArrayList<String>(this.dependencies.getAddOns().size());
        for (BaseZapAddOnXmlData.AddOnDep dep : this.dependencies.getAddOns()) {
            ids.add(dep.getId());
        }
        return ids;
    }

    public boolean dependsOn(AddOn addOn) {
        if (this.dependencies == null || this.dependencies.getAddOns().isEmpty()) {
            return false;
        }
        return AddOn.dependsOn(this.dependencies.getAddOns(), addOn);
    }

    public boolean dependsOn(Collection<AddOn> addOns) {
        if (this.dependencies == null || this.dependencies.getAddOns().isEmpty()) {
            return false;
        }
        for (AddOn addOn : addOns) {
            if (!this.dependsOn(addOn)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[id=").append(this.id);
        strBuilder.append(", fileVersion=").append(this.fileVersion);
        if (this.version != null) {
            strBuilder.append(", version=").append(this.version);
        }
        strBuilder.append(']');
        return strBuilder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + this.fileVersion;
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddOn other = (AddOn)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.fileVersion != other.fileVersion) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    private static int getJavaVersion(String javaVersion) {
        return AddOn.toVersionInt(AddOn.toJavaVersionIntArray(javaVersion, 2));
    }

    private static int[] toJavaVersionIntArray(String version, int limit) {
        if (version == null) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        String[] strings = StringUtils.split((String)version, (String)"._- ");
        int[] ints = new int[Math.min(limit, strings.length)];
        int j = 0;
        for (int i = 0; i < strings.length && j < limit; ++i) {
            String s = strings[i];
            if (s.length() <= 0) continue;
            try {
                ints[j] = Integer.parseInt(s);
                ++j;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ints.length > j) {
            int[] newInts = new int[j];
            System.arraycopy(ints, 0, newInts, 0, j);
            ints = newInts;
        }
        return ints;
    }

    private static int toVersionInt(int[] javaVersions) {
        if (javaVersions == null) {
            return 0;
        }
        int intVersion = 0;
        int len = javaVersions.length;
        if (len >= 1) {
            intVersion = javaVersions[0] * 100;
        }
        if (len >= 2) {
            intVersion += javaVersions[1] * 10;
        }
        if (len >= 3) {
            intVersion += javaVersions[2];
        }
        return intVersion;
    }

    public static class ExtensionRunRequirements
    extends BaseRunRequirements {
        private final String classname;

        private ExtensionRunRequirements(AddOn addOn, String classname) {
            super(addOn);
            this.classname = classname;
        }

        public String getClassname() {
            return this.classname;
        }
    }

    public static class AddOnRunRequirements
    extends BaseRunRequirements {
        private List<ExtensionRunRequirements> addExtensionsRequirements;

        private AddOnRunRequirements(AddOn addOn) {
            super(addOn);
        }

        public List<ExtensionRunRequirements> getExtensionRequirements() {
            if (this.addExtensionsRequirements == null) {
                this.addExtensionsRequirements = Collections.emptyList();
            }
            return this.addExtensionsRequirements;
        }

        public boolean hasExtensionsWithRunningIssues() {
            for (ExtensionRunRequirements reqs : this.getExtensionRequirements()) {
                if (reqs.isRunnable()) continue;
                return true;
            }
            return false;
        }

        protected void addExtensionRequirements(ExtensionRunRequirements extension) {
            if (this.addExtensionsRequirements == null) {
                this.addExtensionsRequirements = new ArrayList<ExtensionRunRequirements>(5);
            }
            this.addExtensionsRequirements.add(extension);
        }
    }

    public static abstract class BaseRunRequirements {
        private final AddOn addOn;
        private final DirectedGraph<AddOn, DefaultEdge> dependencyTree;
        private Set<AddOn> dependencies;
        private DependencyIssue depIssue;
        private List<Object> issueDetails;
        private String minimumJavaVersion;
        private AddOn addOnMinimumJavaVersion;
        private boolean runnable;

        private BaseRunRequirements(AddOn addOn) {
            this.addOn = addOn;
            this.dependencyTree = new DefaultDirectedGraph(DefaultEdge.class);
            this.dependencyTree.addVertex((Object)addOn);
            this.runnable = true;
            this.issueDetails = Collections.emptyList();
        }

        public AddOn getAddOn() {
            return this.addOn;
        }

        public boolean hasDependencyIssue() {
            return this.depIssue != null;
        }

        public DependencyIssue getDependencyIssue() {
            return this.depIssue;
        }

        public List<Object> getDependencyIssueDetails() {
            return this.issueDetails;
        }

        public boolean isRunnable() {
            return this.runnable;
        }

        protected void setRunnable(boolean runnable) {
            this.runnable = runnable;
        }

        public Set<AddOn> getDependencies() {
            if (this.dependencies == null) {
                this.dependencies = new HashSet<AddOn>();
                TopologicalOrderIterator it = new TopologicalOrderIterator(this.dependencyTree);
                while (it.hasNext()) {
                    this.dependencies.add((AddOn)it.next());
                }
                this.dependencies.remove(this.addOn);
            }
            return Collections.unmodifiableSet(this.dependencies);
        }

        protected void setIssue(DependencyIssue issue, Object ... details) {
            this.runnable = false;
            this.depIssue = issue;
            this.issueDetails = details != null ? Arrays.asList(details) : Collections.emptyList();
        }

        protected boolean addDependency(AddOn parent, AddOn addOn) {
            if (parent == null) {
                return true;
            }
            this.dependencyTree.addVertex((Object)parent);
            this.dependencyTree.addVertex((Object)addOn);
            this.dependencyTree.addEdge((Object)parent, (Object)addOn);
            CycleDetector cycleDetector = new CycleDetector(this.dependencyTree);
            boolean cycle = cycleDetector.detectCycles();
            if (cycle) {
                this.dependencies = cycleDetector.findCycles();
                return false;
            }
            return true;
        }

        public boolean isNewerJavaVersionRequired() {
            return this.minimumJavaVersion != null;
        }

        public String getMinimumJavaVersion() {
            return this.minimumJavaVersion;
        }

        public AddOn getAddOnMinimumJavaVersion() {
            return this.addOnMinimumJavaVersion;
        }

        protected void setMinimumJavaVersionIssue(AddOn srcAddOn, String requiredVersion) {
            this.setRunnable(false);
            if (this.minimumJavaVersion == null) {
                this.setMinimumJavaVersion(srcAddOn, requiredVersion);
            } else if (AddOn.getJavaVersion(requiredVersion) > AddOn.getJavaVersion(this.minimumJavaVersion)) {
                this.setMinimumJavaVersion(srcAddOn, requiredVersion);
            }
        }

        private void setMinimumJavaVersion(AddOn srcAddOn, String requiredVersion) {
            this.addOnMinimumJavaVersion = srcAddOn;
            this.minimumJavaVersion = requiredVersion;
        }

        public static enum DependencyIssue {
            CYCLIC,
            OLDER_VERSION,
            MISSING,
            PACKAGE_VERSION_NOT_BEFORE,
            PACKAGE_VERSION_NOT_FROM,
            VERSION;

        }
    }

    public static enum InstallationStatus {
        AVAILABLE,
        NOT_INSTALLED,
        INSTALLED,
        DOWNLOADING,
        UNINSTALLATION_FAILED,
        SOFT_UNINSTALLATION_FAILED;

    }

    public static enum Status {
        unknown,
        example,
        alpha,
        beta,
        weekly,
        release;

    }
}

