/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap;

import com.github.zafarkhaja.semver.ParseException;
import com.github.zafarkhaja.semver.Version;
import org.apache.commons.lang.Validate;

public final class Version
implements Comparable<Version> {
    private final com.github.zafarkhaja.semver.Version impl;

    public Version(String version) throws IllegalArgumentException {
        Validate.notEmpty((String)version, (String)"Parameter version must not be null nor empty.");
        try {
            this.impl = new Version.Builder(version).build();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Parameter version [" + version + "] is not valid: " + e.getMessage());
        }
    }

    public int getMajorVersion() {
        return this.impl.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.impl.getMinorVersion();
    }

    public int getPatchVersion() {
        return this.impl.getPatchVersion();
    }

    public boolean matches(String versionRange) throws IllegalArgumentException {
        Validate.notEmpty((String)versionRange, (String)"Parameter versionRange must not be null nor empty.");
        try {
            return this.impl.satisfies(versionRange);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Parameter versionRange [" + versionRange + "] is not valid: " + e.getMessage());
        }
    }

    public int hashCode() {
        return 31 + (this.impl == null ? 0 : this.impl.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        return !(this.impl == null ? other.impl != null : !this.impl.equals((Object)other.impl));
    }

    @Override
    public int compareTo(Version other) {
        if (other == null) {
            return 1;
        }
        return this.impl.compareTo(other.impl);
    }

    public String toString() {
        return this.impl.toString();
    }
}

