/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpHeader;
import org.parosproxy.paros.network.HttpMalformedHeaderException;

public class HttpResponseHeader
extends HttpHeader {
    private static final long serialVersionUID = 2812716126742059785L;
    private static final Logger log = Logger.getLogger(HttpResponseHeader.class);
    public static final String HTTP_CLIENT_BAD_REQUEST = "HTTP/1.0 400 Bad request\r\n\r\n";
    private static final String _CONTENT_TYPE_IMAGE = "image";
    private static final String _CONTENT_TYPE_TEXT = "text";
    private static final String _CONTENT_TYPE_HTML = "html";
    private static final String _CONTENT_TYPE_JAVASCRIPT = "javascript";
    private static final String _CONTENT_TYPE_JSON = "json";
    private static final String _CONTENT_TYPE_XML = "xml";
    static final Pattern patternStatusLine = Pattern.compile("(HTTP/\\d+\\.\\d+) +(\\d{3}) *([^\\x00-\\x1f\\r\\n]*)", 2);
    private static final Pattern patternPartialStatusLine = Pattern.compile("\\A *(HTTP/\\d+\\.\\d+)", 2);
    private String mStatusCodeString;
    private int mStatusCode;
    private String mReasonPhrase;

    public HttpResponseHeader() {
        this.mStatusCodeString = "";
        this.mReasonPhrase = "";
    }

    public HttpResponseHeader(String data) throws HttpMalformedHeaderException {
        super(data);
    }

    @Override
    public void clear() {
        super.clear();
        this.mStatusCodeString = "";
        this.mStatusCode = 0;
        this.mReasonPhrase = "";
    }

    @Override
    public void setMessage(String data) throws HttpMalformedHeaderException {
        super.setMessage(data);
        try {
            this.parse();
        }
        catch (HttpMalformedHeaderException e) {
            this.mMalformedHeader = true;
            throw e;
        }
    }

    @Override
    public void setVersion(String version) {
        this.mVersion = version.toUpperCase();
    }

    public int getStatusCode() {
        return this.mStatusCode;
    }

    public String getReasonPhrase() {
        return this.mReasonPhrase;
    }

    private void parse() throws HttpMalformedHeaderException {
        Matcher matcher = patternStatusLine.matcher(this.mStartLine);
        if (!matcher.find()) {
            this.mMalformedHeader = true;
            throw new HttpMalformedHeaderException("Failed to find pattern: " + patternStatusLine);
        }
        this.mVersion = matcher.group(1);
        this.mStatusCodeString = matcher.group(2);
        String tmp = matcher.group(3);
        String string = this.mReasonPhrase = tmp != null ? tmp : "";
        if (!this.mVersion.equalsIgnoreCase("HTTP/1.0") && !this.mVersion.equalsIgnoreCase("HTTP/1.1")) {
            this.mMalformedHeader = true;
            throw new HttpMalformedHeaderException("Unexpected version: " + this.mVersion);
        }
        try {
            this.mStatusCode = Integer.parseInt(this.mStatusCodeString);
        }
        catch (NumberFormatException e) {
            this.mMalformedHeader = true;
            throw new HttpMalformedHeaderException("Unexpected status code: " + this.mStatusCodeString);
        }
    }

    @Override
    public int getContentLength() {
        int len = super.getContentLength();
        if (this.mStatusCode >= 100 && this.mStatusCode < 200 || this.mStatusCode == 204 || this.mStatusCode == 304) {
            return 0;
        }
        if (this.mStatusCode >= 200 && this.mStatusCode < 300) {
            return len;
        }
        if (len > 0) {
            return len;
        }
        return 0;
    }

    public static HttpResponseHeader getError(String msg) {
        HttpResponseHeader res = null;
        try {
            res = new HttpResponseHeader(msg);
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            // empty catch block
        }
        return res;
    }

    @Override
    public boolean isImage() {
        String contentType = this.getHeader("Content-Type".toUpperCase());
        return contentType != null && contentType.toLowerCase().indexOf(_CONTENT_TYPE_IMAGE) > -1;
    }

    @Override
    public boolean isText() {
        String contentType = this.getHeader("Content-Type".toUpperCase());
        if (contentType != null) {
            if (contentType.toLowerCase().indexOf(_CONTENT_TYPE_TEXT) > -1) {
                return true;
            }
            if (contentType.toLowerCase().indexOf(_CONTENT_TYPE_HTML) > -1) {
                return true;
            }
            if (contentType.toLowerCase().indexOf(_CONTENT_TYPE_JAVASCRIPT) > -1) {
                return true;
            }
            if (contentType.toLowerCase().indexOf(_CONTENT_TYPE_JSON) > -1) {
                return true;
            }
            if (contentType.toLowerCase().indexOf(_CONTENT_TYPE_XML) > -1) {
                return true;
            }
        }
        return false;
    }

    public boolean isHtml() {
        String contentType = this.getHeader("Content-Type".toUpperCase());
        return contentType != null && contentType.toLowerCase().indexOf(_CONTENT_TYPE_HTML) > -1;
    }

    public boolean isXml() {
        String contentType = this.getHeader("Content-Type".toUpperCase());
        return contentType != null && contentType.toLowerCase().indexOf(_CONTENT_TYPE_XML) > -1;
    }

    public boolean isJson() {
        String contentType = this.getHeader("Content-Type".toUpperCase());
        return contentType != null && contentType.toLowerCase().indexOf(_CONTENT_TYPE_JSON) > -1;
    }

    public boolean isJavaScript() {
        String contentType = this.getHeader("Content-Type".toUpperCase());
        return contentType != null && contentType.toLowerCase().indexOf(_CONTENT_TYPE_JAVASCRIPT) > -1;
    }

    public static boolean isStatusLine(String data) {
        return patternPartialStatusLine.matcher(data).find();
    }

    @Override
    public String getPrimeHeader() {
        String prime = this.getVersion() + " " + this.getStatusCode();
        if (this.getReasonPhrase() != null && !this.getReasonPhrase().equals("")) {
            prime = prime + " " + this.getReasonPhrase();
        }
        return prime;
    }

    public List<HttpCookie> getHttpCookies(String defaultDomain) {
        LinkedList<HttpCookie> cookies = new LinkedList<HttpCookie>();
        Vector<String> cookiesS = this.getHeaders("Set-Cookie");
        if (cookiesS != null) {
            for (String c : cookiesS) {
                cookies.addAll(this.parseCookieString(c, defaultDomain));
            }
        }
        if ((cookiesS = this.getHeaders("Set-Cookie2")) != null) {
            for (String c : cookiesS) {
                cookies.addAll(this.parseCookieString(c, defaultDomain));
            }
        }
        return cookies;
    }

    private List<HttpCookie> parseCookieString(String c, String defaultDomain) {
        try {
            List<HttpCookie> parsedCookies = HttpCookie.parse(c);
            if (defaultDomain != null) {
                for (HttpCookie cookie : parsedCookies) {
                    if (cookie.getDomain() != null) continue;
                    cookie.setDomain(defaultDomain);
                }
            }
            return parsedCookies;
        }
        catch (IllegalArgumentException e) {
            if (c.indexOf(44) >= 0) {
                try {
                    List<HttpCookie> parsedCookies = HttpCookie.parse(c.replace(',', ';'));
                    if (defaultDomain != null) {
                        for (HttpCookie cookie : parsedCookies) {
                            if (cookie.getDomain() != null) continue;
                            cookie.setDomain(defaultDomain);
                        }
                    }
                    return parsedCookies;
                }
                catch (IllegalArgumentException e2) {
                    log.error((Object)("Failed to parse cookie: " + c), (Throwable)e);
                }
            }
            return new ArrayList<HttpCookie>();
        }
    }

    @Deprecated
    public List<HttpCookie> getHttpCookies() {
        return this.getHttpCookies(null);
    }

    public TreeSet<HtmlParameter> getCookieParams() {
        Vector<String> cookies2;
        TreeSet<HtmlParameter> set = new TreeSet<HtmlParameter>();
        Vector<String> cookies = this.getHeaders("Set-Cookie");
        if (cookies != null) {
            Iterator<String> it = cookies.iterator();
            while (it.hasNext()) {
                set.add(new HtmlParameter(it.next()));
            }
        }
        if ((cookies2 = this.getHeaders("Set-Cookie2")) != null) {
            Iterator<String> it = cookies2.iterator();
            while (it.hasNext()) {
                set.add(new HtmlParameter(it.next()));
            }
        }
        return set;
    }
}

