/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpHeader;
import org.parosproxy.paros.network.HttpMalformedHeaderException;

public class HttpRequestHeader
extends HttpHeader {
    private static final long serialVersionUID = 4156598327921777493L;
    private static final Logger log = Logger.getLogger(HttpRequestHeader.class);
    public static final String OPTIONS = "OPTIONS";
    public static final String GET = "GET";
    public static final String HEAD = "HEAD";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    public static final String TRACE = "TRACE";
    public static final String CONNECT = "CONNECT";
    public static final String[] METHODS = new String[]{"OPTIONS", "GET", "HEAD", "POST", "PUT", "DELETE", "TRACE", "CONNECT"};
    public static final String HOST = "Host";
    private static final Pattern patternRequestLine = Pattern.compile("(\\w+) +([^\\r\\n]+) +(HTTP/\\d+\\.\\d+)", 2);
    private static final Pattern patternImage = Pattern.compile("\\.(bmp|ico|jpg|jpeg|gif|tiff|tif|png)\\z", 2);
    private static final Pattern patternPartialRequestLine = Pattern.compile("\\A *(OPTIONS|GET|HEAD|POST|PUT|DELETE|TRACE|CONNECT)\\b", 2);
    private String mMethod;
    private URI mUri;
    private String mHostName;
    private InetAddress senderAddress;
    private int mHostPort;
    private boolean mIsSecure;
    private static final String DELIM = "<>#\"";
    private static final String UNWISE = "{}|\\^[]`";
    private static final String DELIM_UNWISE = "<>#\"{}|\\^[]`";

    public HttpRequestHeader() {
        this.mMethod = "";
        this.mHostName = "";
        this.mHostPort = 80;
    }

    public HttpRequestHeader(String data, boolean isSecure) throws HttpMalformedHeaderException {
        this.setMessage(data, isSecure);
    }

    public HttpRequestHeader(String data) throws HttpMalformedHeaderException {
        this.setMessage(data);
    }

    @Override
    public void clear() {
        super.clear();
        this.mMethod = "";
        this.mUri = null;
        this.mHostName = "";
        this.setHostPort(-1);
    }

    public HttpRequestHeader(String method, URI uri, String version) throws HttpMalformedHeaderException {
        this(method, uri, version, null);
    }

    public HttpRequestHeader(String method, URI uri, String version, ConnectionParam params) throws HttpMalformedHeaderException {
        this(method + " " + uri.toString() + " " + version.toUpperCase() + "\r\n" + "\r\n");
        try {
            this.setHeader(HOST, uri.getHost() + (uri.getPort() > 0 ? ":" + Integer.toString(uri.getPort()) : ""));
        }
        catch (URIException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        String userAgent = params != null ? params.getDefaultUserAgent() : "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0;)";
        this.setHeader("User-Agent", userAgent);
        this.setHeader("Pragma", "no-cache");
        if (version.equalsIgnoreCase("HTTP/1.1")) {
            this.setHeader("Cache-Control", "no-cache");
        }
        if (method.equalsIgnoreCase(POST) || method.equalsIgnoreCase(PUT)) {
            this.setHeader("Content-Type", "application/x-www-form-urlencoded");
        }
        this.setHeader("Accept-Encoding", null);
        if (version.equalsIgnoreCase("HTTP/1.1")) {
            this.setContentLength(0);
        }
    }

    public void setMessage(String data, boolean isSecure) throws HttpMalformedHeaderException {
        super.setMessage(data);
        try {
            this.parse(isSecure);
        }
        catch (HttpMalformedHeaderException e) {
            this.mMalformedHeader = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Malformed header: " + data), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.mMalformedHeader = true;
            throw new HttpMalformedHeaderException(e.getMessage());
        }
    }

    @Override
    public void setMessage(String data) throws HttpMalformedHeaderException {
        this.setMessage(data, false);
    }

    public String getMethod() {
        return this.mMethod;
    }

    public void setMethod(String method) {
        this.mMethod = method.toUpperCase();
    }

    public URI getURI() {
        return this.mUri;
    }

    public void setURI(URI uri) throws URIException {
        this.mUri = uri.getScheme() == null || uri.getScheme().equals("") ? new URI("http://" + this.getHeader(HOST) + "/" + this.mUri.toString(), true) : uri;
        this.mIsSecure = uri.getScheme().equalsIgnoreCase("https");
        this.setHostPort(this.mUri.getPort());
    }

    @Deprecated
    public boolean getSecure() {
        return this.mIsSecure;
    }

    public boolean isSecure() {
        return this.mIsSecure;
    }

    public void setSecure(boolean isSecure) throws URIException {
        this.mIsSecure = isSecure;
        if (this.mUri == null) {
            return;
        }
        URI newUri = this.mUri;
        if (this.isSecure() && this.mUri.getScheme().equalsIgnoreCase("http")) {
            newUri = new URI(this.mUri.toString().replaceFirst("http", "https"), true);
        } else if (!this.isSecure() && this.mUri.getScheme().equalsIgnoreCase("https")) {
            newUri = new URI(this.mUri.toString().replaceFirst("https", "http"), true);
        }
        if (newUri != this.mUri) {
            this.mUri = newUri;
            this.setHostPort(this.mUri.getPort());
        }
    }

    @Override
    public void setVersion(String version) {
        this.mVersion = version.toUpperCase();
    }

    @Override
    public int getContentLength() {
        if (this.mContentLength == -1) {
            return 0;
        }
        return this.mContentLength;
    }

    private void parse(boolean isSecure) throws URIException, HttpMalformedHeaderException {
        this.mIsSecure = isSecure;
        Matcher matcher = patternRequestLine.matcher(this.mStartLine);
        if (!matcher.find()) {
            this.mMalformedHeader = true;
            throw new HttpMalformedHeaderException("Failed to find pattern: " + patternRequestLine);
        }
        this.mMethod = matcher.group(1);
        String sUri = matcher.group(2);
        this.mVersion = matcher.group(3);
        if (!(this.mVersion.equalsIgnoreCase("HTTP/0.9") || this.mVersion.equalsIgnoreCase("HTTP/1.0") || this.mVersion.equalsIgnoreCase("HTTP/1.1"))) {
            this.mMalformedHeader = true;
            throw new HttpMalformedHeaderException("Unexpected version: " + this.mVersion);
        }
        this.mUri = HttpRequestHeader.parseURI(sUri);
        if (this.mUri.getScheme() == null || this.mUri.getScheme().equals("")) {
            this.mUri = new URI("http://" + this.getHeader(HOST) + this.mUri.toString(), true);
        }
        if (this.isSecure() && this.mUri.getScheme().equalsIgnoreCase("http")) {
            this.mUri = new URI(this.mUri.toString().replaceFirst("http", "https"), true);
        }
        if (this.mUri.getScheme().equalsIgnoreCase("https")) {
            this.setSecure(true);
        }
        if (this.mMethod.equalsIgnoreCase(CONNECT)) {
            String hostHeader = sUri;
            this.parseHostName(hostHeader);
        } else {
            this.mHostName = this.mUri.getHost();
            this.setHostPort(this.mUri.getPort());
        }
    }

    private void parseHostName(String hostHeader) {
        if (hostHeader == null) {
            return;
        }
        int port = -1;
        int pos = hostHeader.indexOf(58, 2);
        if (pos > -1) {
            this.mHostName = hostHeader.substring(0, pos).trim();
            try {
                port = Integer.parseInt(hostHeader.substring(pos + 1));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.mHostName = hostHeader.trim();
        }
        this.setHostPort(port);
    }

    public String getHostName() {
        String hostName;
        block2: {
            hostName = this.mHostName;
            try {
                hostName = this.mUri.getHost() != null ? this.mUri.getHost() : this.mHostName;
            }
            catch (URIException e) {
                if (!log.isDebugEnabled()) break block2;
                log.warn((Object)e);
            }
        }
        return hostName;
    }

    public int getHostPort() {
        return this.mHostPort;
    }

    private void setHostPort(int port) {
        this.mHostPort = port > -1 ? port : (this.isSecure() ? 443 : 80);
    }

    @Override
    public boolean isImage() {
        try {
            String path = this.getURI().getPath();
            if (path != null) {
                return patternImage.matcher(path).find();
            }
        }
        catch (URIException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static boolean isRequestLine(String data) {
        return patternPartialRequestLine.matcher(data).find();
    }

    @Override
    public String getPrimeHeader() {
        return this.getMethod() + " " + this.getURI().toString() + " " + this.getVersion();
    }

    public static URI parseURI(String sUri) throws URIException {
        int len = sUri.length();
        StringBuilder sb = new StringBuilder(len);
        char[] charray = new char[1];
        for (int i = 0; i < len; ++i) {
            String s;
            char ch = sUri.charAt(i);
            if (DELIM_UNWISE.indexOf(ch) >= 0) {
                charray[0] = ch;
                s = new String(charray);
                try {
                    s = URLEncoder.encode(s, "UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                sb.append(s);
                continue;
            }
            if (ch == '%') {
                try {
                    String hex = sUri.substring(i + 1, i + 3);
                    Integer.parseInt(hex, 16);
                    sb.append(ch);
                }
                catch (Exception e) {
                    charray[0] = ch;
                    s = new String(charray);
                    try {
                        s = URLEncoder.encode(s, "UTF8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    sb.append(s);
                }
                continue;
            }
            if (ch == ' ') {
                sb.append("%20");
                continue;
            }
            sb.append(ch);
        }
        URI uri = new URI(sb.toString(), true);
        return uri;
    }

    public void setGetParams(TreeSet<HtmlParameter> getParams) {
        if (this.mUri == null) {
            return;
        }
        if (getParams.isEmpty()) {
            try {
                this.mUri.setQuery("");
            }
            catch (URIException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            return;
        }
        StringBuilder sbQuery = new StringBuilder();
        for (HtmlParameter parameter : getParams) {
            if (parameter.getType() != HtmlParameter.Type.url) continue;
            sbQuery.append(parameter.getName());
            sbQuery.append('=');
            sbQuery.append(parameter.getValue());
            sbQuery.append('&');
        }
        if (sbQuery.length() <= 2) {
            try {
                this.mUri.setQuery("");
            }
            catch (URIException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            return;
        }
        String query = sbQuery.substring(0, sbQuery.length() - 1);
        try {
            this.mUri.setQuery(query);
        }
        catch (URIException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setCookies(List<HttpCookie> cookies) {
        if (cookies.isEmpty()) {
            this.setHeader("Cookie", null);
        }
        StringBuilder sbData = new StringBuilder();
        for (HttpCookie c : cookies) {
            sbData.append(c.getName());
            sbData.append('=');
            sbData.append(c.getValue());
            sbData.append("; ");
        }
        if (sbData.length() <= 3) {
            this.setHeader("Cookie", null);
            return;
        }
        String data = sbData.substring(0, sbData.length() - 2);
        this.setHeader("Cookie", data);
    }

    public void setCookieParams(TreeSet<HtmlParameter> cookieParams) {
        if (cookieParams.isEmpty()) {
            this.setHeader("Cookie", null);
        }
        StringBuilder sbData = new StringBuilder();
        for (HtmlParameter parameter : cookieParams) {
            if (parameter.getType() != HtmlParameter.Type.cookie) continue;
            sbData.append(parameter.getName());
            sbData.append('=');
            sbData.append(parameter.getValue());
            sbData.append("; ");
        }
        if (sbData.length() <= 3) {
            this.setHeader("Cookie", null);
            return;
        }
        String data = sbData.substring(0, sbData.length() - 2);
        this.setHeader("Cookie", data);
    }

    public TreeSet<HtmlParameter> getCookieParams() {
        TreeSet<HtmlParameter> set = new TreeSet<HtmlParameter>();
        Vector<String> cookieLines = this.getHeaders("Cookie");
        if (cookieLines != null) {
            for (String cookieLine : cookieLines) {
                String[] cookieArray;
                if (cookieLine.toUpperCase().startsWith("Cookie".toUpperCase() + ":")) {
                    cookieLine = cookieLine.substring("Cookie".length() + 1);
                }
                for (String cookie : cookieArray = cookieLine.split(";")) {
                    set.add(new HtmlParameter(cookie));
                }
            }
        }
        return set;
    }

    public List<HttpCookie> getHttpCookies() {
        LinkedList<HttpCookie> cookies = new LinkedList<HttpCookie>();
        TreeSet<HtmlParameter> ts = this.getCookieParams();
        for (HtmlParameter htmlParameter : ts) {
            if (htmlParameter.getName().isEmpty()) continue;
            try {
                cookies.add(new HttpCookie(htmlParameter.getName(), htmlParameter.getValue()));
            }
            catch (IllegalArgumentException e) {
                log.debug((Object)(e.getMessage() + " " + htmlParameter.getName()));
            }
        }
        return cookies;
    }

    public void setSenderAddress(InetAddress inetAddress) {
        this.senderAddress = inetAddress;
    }

    public InetAddress getSenderAddress() {
        return this.senderAddress;
    }
}

