/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.httpclient.HttpState;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.network.SSLConnector;
import org.zaproxy.zap.extension.api.ZapApiIgnore;
import org.zaproxy.zap.network.DomainMatcher;

public class ConnectionParam
extends AbstractParam {
    private static Logger log = Logger.getLogger(ConnectionParam.class);
    private static final String CONNECTION_BASE_KEY = "connection";
    private static final String USE_PROXY_CHAIN_KEY = "connection.proxyChain.enabled";
    private static final String PROXY_CHAIN_NAME = "connection.proxyChain.hostName";
    private static final String PROXY_CHAIN_PORT = "connection.proxyChain.port";
    private static final String USE_PROXY_CHAIN_AUTH_KEY = "connection.proxyChain.authEnabled";
    private static final String PROXY_CHAIN_REALM = "connection.proxyChain.realm";
    private static final String PROXY_CHAIN_USER_NAME = "connection.proxyChain.userName";
    private static final String PROXY_CHAIN_PASSWORD = "connection.proxyChain.password";
    private static final String PROXY_EXCLUDED_DOMAIN_KEY = "connection.proxyChain.exclusions";
    private static final String ALL_PROXY_EXCLUDED_DOMAINS_KEY = "connection.proxyChain.exclusions.exclusion";
    private static final String PROXY_EXCLUDED_DOMAIN_VALUE_KEY = "name";
    private static final String PROXY_EXCLUDED_DOMAIN_REGEX_KEY = "regex";
    private static final String PROXY_EXCLUDED_DOMAIN_ENABLED_KEY = "enabled";
    private static final String CONFIRM_REMOVE_EXCLUDED_DOMAIN = "connection.proxyChain.confirmRemoveExcludedDomain";
    private static final String SECURITY_PROTOCOLS_ENABLED = "connection.securityProtocolsEnabled";
    private static final String SECURITY_PROTOCOL_ELEMENT_KEY = "protocol";
    private static final String ALL_SECURITY_PROTOCOLS_ENABLED_KEY = "connection.securityProtocolsEnabled.protocol";
    private static final String PROXY_CHAIN_PROMPT = "connection.proxyChain.prompt";
    private static final String TIMEOUT_IN_SECS = "connection.timeoutInSecs";
    private static final String SINGLE_COOKIE_REQUEST_HEADER = "connection.singleCookieRequestHeader";
    private static final String DEFAULT_USER_AGENT = "connection.defaultUserAgent";
    private static final String DEFAULT_DEFAULT_USER_AGENT = "Mozilla/5.0 (Windows NT 6.3; WOW64; rv:39.0) Gecko/20100101 Firefox/39.0";
    private static final String DNS_TTL_SUCCESSFUL_QUERIES_SECURITY_PROPERTY = "networkaddress.cache.ttl";
    public static final int DNS_DEFAULT_TTL_SUCCESSFUL_QUERIES = 30;
    private static final String DNS_TTL_SUCCESSFUL_QUERIES_KEY = "connection.dnsTtlSuccessfulQueries";
    private boolean useProxyChain;
    private String proxyChainName = "";
    private int proxyChainPort = 8080;
    private boolean confirmRemoveProxyExcludeDomain = true;
    private boolean useProxyChainAuth;
    private String proxyChainRealm = "";
    private String proxyChainUserName = "";
    private String proxyChainPassword = "";
    private HttpState httpState = null;
    private boolean httpStateEnabled = false;
    private List<DomainMatcher> proxyExcludedDomains = new ArrayList<DomainMatcher>(0);
    private List<DomainMatcher> proxyExcludedDomainsEnabled = new ArrayList<DomainMatcher>(0);
    private String[] securityProtocolsEnabled;
    private boolean proxyChainPrompt = false;
    private int timeoutInSecs = 120;
    private boolean singleCookieRequestHeader = true;
    private String defaultUserAgent = "";
    private int dnsTtlSuccessfulQueries = 30;

    public boolean isHttpStateEnabled() {
        return this.httpStateEnabled;
    }

    public void setHttpStateEnabled(boolean httpStateEnabled) {
        this.httpStateEnabled = httpStateEnabled;
        this.httpState = this.httpStateEnabled ? new HttpState() : null;
    }

    @Override
    protected void parse() {
        this.updateOptions();
        try {
            this.dnsTtlSuccessfulQueries = this.getConfig().getInt(DNS_TTL_SUCCESSFUL_QUERIES_KEY, 30);
            Security.setProperty(DNS_TTL_SUCCESSFUL_QUERIES_SECURITY_PROPERTY, Integer.toString(this.dnsTtlSuccessfulQueries));
        }
        catch (ConversionException e) {
            log.error((Object)"Failed to read 'connection.dnsTtlSuccessfulQueries'", (Throwable)e);
            this.dnsTtlSuccessfulQueries = 30;
        }
        this.useProxyChain = this.getConfig().getBoolean(USE_PROXY_CHAIN_KEY, false);
        this.useProxyChainAuth = this.getConfig().getBoolean(USE_PROXY_CHAIN_AUTH_KEY, false);
        this.setProxyChainName(this.getConfig().getString(PROXY_CHAIN_NAME, ""));
        try {
            this.setProxyChainPort(this.getConfig().getInt(PROXY_CHAIN_PORT, 8080));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.loadProxyExcludedDomains();
        try {
            this.confirmRemoveProxyExcludeDomain = this.getConfig().getBoolean(CONFIRM_REMOVE_EXCLUDED_DOMAIN, true);
        }
        catch (ConversionException e) {
            log.error((Object)("Error while loading the confirm excluded domain remove option: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.setProxyChainRealm(this.getConfig().getString(PROXY_CHAIN_REALM, ""));
            this.setProxyChainUserName(this.getConfig().getString(PROXY_CHAIN_USER_NAME, ""));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            if (this.getConfig().getProperty(PROXY_CHAIN_PROMPT) instanceof String && ((String)this.getConfig().getProperty(PROXY_CHAIN_PROMPT)).isEmpty()) {
                this.setProxyChainPrompt(false);
            } else if (this.getConfig().getBoolean(PROXY_CHAIN_PROMPT, false)) {
                this.setProxyChainPrompt(true);
            } else {
                this.setProxyChainPrompt(false);
                this.setProxyChainPassword(this.getConfig().getString(PROXY_CHAIN_PASSWORD, ""));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            this.setTimeoutInSecs(this.getConfig().getInt(TIMEOUT_IN_SECS, 20));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            this.singleCookieRequestHeader = this.getConfig().getBoolean(SINGLE_COOKIE_REQUEST_HEADER, true);
        }
        catch (ConversionException e) {
            log.error((Object)("Error while loading the option singleCookieRequestHeader: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.defaultUserAgent = this.getConfig().getString(DEFAULT_USER_AGENT, DEFAULT_DEFAULT_USER_AGENT);
        }
        catch (Exception e) {
            log.error((Object)("Error while loading the option defaultUserAgent: " + e.getMessage()), (Throwable)e);
            this.defaultUserAgent = DEFAULT_DEFAULT_USER_AGENT;
        }
        this.loadSecurityProtocolsEnabled();
    }

    private void updateOptions() {
        String proxyUserName;
        String proxyName;
        String oldKey = "connectionsslConnectPorts";
        if (this.getConfig().containsKey("connectionsslConnectPorts")) {
            this.getConfig().clearProperty("connectionsslConnectPorts");
        }
        String oldSkipNameKey = "connection.proxyChain.skipName";
        if (this.getConfig().containsKey("connection.proxyChain.skipName")) {
            this.migrateOldSkipNameOption(this.getConfig().getString("connection.proxyChain.skipName", ""));
            this.getConfig().clearProperty("connection.proxyChain.skipName");
        }
        if (!this.getConfig().containsKey(USE_PROXY_CHAIN_KEY) && !(proxyName = this.getConfig().getString(PROXY_CHAIN_NAME, "")).isEmpty()) {
            this.getConfig().setProperty(USE_PROXY_CHAIN_KEY, (Object)Boolean.TRUE);
        }
        if (!this.getConfig().containsKey(USE_PROXY_CHAIN_AUTH_KEY) && !(proxyUserName = this.getConfig().getString(PROXY_CHAIN_USER_NAME, "")).isEmpty()) {
            this.getConfig().setProperty(USE_PROXY_CHAIN_AUTH_KEY, (Object)Boolean.TRUE);
        }
    }

    private void migrateOldSkipNameOption(String skipNames) {
        List<DomainMatcher> excludedDomains = ConnectionParam.convertOldSkipNameOption(skipNames);
        if (!excludedDomains.isEmpty()) {
            this.setProxyExcludedDomains(excludedDomains);
        }
    }

    private static List<DomainMatcher> convertOldSkipNameOption(String skipNames) {
        String[] names;
        if (skipNames == null || skipNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DomainMatcher> excludedDomains = new ArrayList<DomainMatcher>();
        for (String name : names = skipNames.split(";")) {
            String excludedDomain = name.trim();
            if (excludedDomain.isEmpty()) continue;
            if (excludedDomain.contains("*")) {
                excludedDomain = excludedDomain.replace(".", "\\.").replace("*", ".*?");
                try {
                    Pattern pattern = Pattern.compile(excludedDomain, 2);
                    excludedDomains.add(new DomainMatcher(pattern));
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)("Failed to migrate the excluded domain name: " + name), (Throwable)e);
                }
                continue;
            }
            excludedDomains.add(new DomainMatcher(excludedDomain));
        }
        excludedDomains.trimToSize();
        return excludedDomains;
    }

    public boolean isUseProxyChain() {
        return this.useProxyChain;
    }

    public void setUseProxyChain(boolean useProxyChain) {
        if (useProxyChain && (this.getProxyChainName() == null || this.getProxyChainName().isEmpty())) {
            return;
        }
        this.useProxyChain = useProxyChain;
        this.getConfig().setProperty(USE_PROXY_CHAIN_KEY, (Object)this.useProxyChain);
    }

    public String getProxyChainName() {
        return this.proxyChainName;
    }

    public void setProxyChainName(String proxyChainName) {
        if (proxyChainName == null) {
            return;
        }
        this.proxyChainName = proxyChainName.trim();
        if (proxyChainName.isEmpty()) {
            this.setUseProxyChain(false);
        }
        this.getConfig().setProperty(PROXY_CHAIN_NAME, (Object)this.proxyChainName);
    }

    public int getProxyChainPort() {
        return this.proxyChainPort;
    }

    public void setProxyChainPort(int proxyChainPort) {
        this.proxyChainPort = proxyChainPort;
        this.getConfig().setProperty(PROXY_CHAIN_PORT, (Object)Integer.toString(this.proxyChainPort));
    }

    @Deprecated
    @ZapApiIgnore
    public String getProxyChainSkipName() {
        StringBuilder skipNamesStringBuilder = new StringBuilder("");
        for (DomainMatcher excludedDomain : this.proxyExcludedDomains) {
            if (excludedDomain.isRegex()) continue;
            skipNamesStringBuilder.append(excludedDomain.getValue()).append(';');
        }
        return skipNamesStringBuilder.toString();
    }

    @Deprecated
    public void setProxyChainSkipName(String proxyChainSkipName) {
        this.setProxyExcludedDomains(ConnectionParam.convertOldSkipNameOption(proxyChainSkipName));
    }

    public boolean isUseProxyChainAuth() {
        return this.useProxyChainAuth;
    }

    public void setUseProxyChainAuth(boolean useProxyChainAuth) {
        if (useProxyChainAuth && (this.getProxyChainUserName() == null || this.getProxyChainUserName().isEmpty())) {
            return;
        }
        this.useProxyChainAuth = useProxyChainAuth;
        this.getConfig().setProperty(USE_PROXY_CHAIN_AUTH_KEY, (Object)this.useProxyChainAuth);
    }

    public String getProxyChainRealm() {
        return this.proxyChainRealm;
    }

    public void setProxyChainRealm(String proxyChainRealm) {
        this.proxyChainRealm = proxyChainRealm.trim();
        this.getConfig().setProperty(PROXY_CHAIN_REALM, (Object)this.proxyChainRealm);
    }

    public String getProxyChainUserName() {
        return this.proxyChainUserName;
    }

    public void setProxyChainUserName(String proxyChainUserName) {
        this.proxyChainUserName = proxyChainUserName.trim();
        this.getConfig().setProperty(PROXY_CHAIN_USER_NAME, (Object)this.proxyChainUserName);
    }

    public String getProxyChainPassword() {
        return this.proxyChainPassword.trim();
    }

    public void setProxyChainPassword(String proxyChainPassword) {
        this.proxyChainPassword = proxyChainPassword;
        this.getConfig().setProperty(PROXY_CHAIN_PASSWORD, (Object)this.proxyChainPassword);
    }

    public void setProxyChainPassword(String proxyChainPassword, boolean save) {
        if (save) {
            this.setProxyChainPassword(proxyChainPassword);
        } else {
            this.proxyChainPassword = proxyChainPassword;
        }
    }

    public void setProxyChainPrompt(boolean proxyPrompt) {
        this.proxyChainPrompt = proxyPrompt;
        this.getConfig().setProperty(PROXY_CHAIN_PROMPT, (Object)this.proxyChainPrompt);
    }

    public boolean isProxyChainPrompt() {
        return this.proxyChainPrompt;
    }

    private boolean isDomainExcludedFromProxy(String domainName) {
        if (domainName == null || domainName.isEmpty()) {
            return false;
        }
        for (DomainMatcher excludedDomain : this.proxyExcludedDomainsEnabled) {
            if (!excludedDomain.matches(domainName)) continue;
            return true;
        }
        return false;
    }

    public boolean isUseProxy(String hostName) {
        return this.isUseProxyChain() && !this.isDomainExcludedFromProxy(hostName);
    }

    public HttpState getHttpState() {
        return this.httpState;
    }

    public void setHttpState(HttpState httpState) {
        this.httpState = httpState;
    }

    public int getTimeoutInSecs() {
        return this.timeoutInSecs;
    }

    public void setTimeoutInSecs(int timeoutInSecs) {
        this.timeoutInSecs = timeoutInSecs;
        this.getConfig().setProperty(TIMEOUT_IN_SECS, (Object)this.timeoutInSecs);
    }

    public boolean isSingleCookieRequestHeader() {
        return this.singleCookieRequestHeader;
    }

    public void setSingleCookieRequestHeader(boolean singleCookieRequestHeader) {
        this.singleCookieRequestHeader = singleCookieRequestHeader;
        this.getConfig().setProperty(SINGLE_COOKIE_REQUEST_HEADER, (Object)singleCookieRequestHeader);
    }

    @ZapApiIgnore
    public List<DomainMatcher> getProxyExcludedDomains() {
        return this.proxyExcludedDomains;
    }

    @ZapApiIgnore
    public List<DomainMatcher> getProxyExcludedDomainsEnabled() {
        return this.proxyExcludedDomainsEnabled;
    }

    public void setProxyExcludedDomains(List<DomainMatcher> proxyExcludedDomains) {
        if (proxyExcludedDomains == null || proxyExcludedDomains.isEmpty()) {
            ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_PROXY_EXCLUDED_DOMAINS_KEY);
            this.proxyExcludedDomains = Collections.emptyList();
            this.proxyExcludedDomainsEnabled = Collections.emptyList();
            return;
        }
        this.proxyExcludedDomains = new ArrayList<DomainMatcher>(proxyExcludedDomains);
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_PROXY_EXCLUDED_DOMAINS_KEY);
        int size = proxyExcludedDomains.size();
        ArrayList<DomainMatcher> enabledExcludedDomains = new ArrayList<DomainMatcher>(size);
        for (int i = 0; i < size; ++i) {
            String elementBaseKey = "connection.proxyChain.exclusions.exclusion(" + i + ").";
            DomainMatcher excludedDomain = proxyExcludedDomains.get(i);
            this.getConfig().setProperty(elementBaseKey + PROXY_EXCLUDED_DOMAIN_VALUE_KEY, (Object)excludedDomain.getValue());
            this.getConfig().setProperty(elementBaseKey + PROXY_EXCLUDED_DOMAIN_REGEX_KEY, (Object)excludedDomain.isRegex());
            this.getConfig().setProperty(elementBaseKey + PROXY_EXCLUDED_DOMAIN_ENABLED_KEY, (Object)excludedDomain.isEnabled());
            if (!excludedDomain.isEnabled()) continue;
            enabledExcludedDomains.add(excludedDomain);
        }
        enabledExcludedDomains.trimToSize();
        this.proxyExcludedDomainsEnabled = enabledExcludedDomains;
    }

    private void loadProxyExcludedDomains() {
        List fields = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(ALL_PROXY_EXCLUDED_DOMAINS_KEY);
        this.proxyExcludedDomains = new ArrayList<DomainMatcher>(fields.size());
        ArrayList<DomainMatcher> excludedDomainsEnabled = new ArrayList<DomainMatcher>(fields.size());
        for (HierarchicalConfiguration sub : fields) {
            String value = sub.getString(PROXY_EXCLUDED_DOMAIN_VALUE_KEY, "");
            if (value.isEmpty()) {
                log.warn((Object)"Failed to read an outgoing proxy excluded domain entry, required value is empty.");
                continue;
            }
            DomainMatcher excludedDomain = null;
            boolean regex = sub.getBoolean(PROXY_EXCLUDED_DOMAIN_REGEX_KEY, false);
            if (regex) {
                try {
                    Pattern pattern = DomainMatcher.createPattern(value);
                    excludedDomain = new DomainMatcher(pattern);
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)("Failed to read an outgoing proxy excluded domain entry with regex: " + value), (Throwable)e);
                }
            } else {
                excludedDomain = new DomainMatcher(value);
            }
            if (excludedDomain == null) continue;
            excludedDomain.setEnabled(sub.getBoolean(PROXY_EXCLUDED_DOMAIN_ENABLED_KEY, true));
            this.proxyExcludedDomains.add(excludedDomain);
            if (!excludedDomain.isEnabled()) continue;
            excludedDomainsEnabled.add(excludedDomain);
        }
        excludedDomainsEnabled.trimToSize();
        this.proxyExcludedDomainsEnabled = excludedDomainsEnabled;
    }

    @ZapApiIgnore
    public boolean isConfirmRemoveProxyExcludedDomain() {
        return this.confirmRemoveProxyExcludeDomain;
    }

    @ZapApiIgnore
    public void setConfirmRemoveProxyExcludedDomain(boolean confirmRemove) {
        this.confirmRemoveProxyExcludeDomain = confirmRemove;
        this.getConfig().setProperty(CONFIRM_REMOVE_EXCLUDED_DOMAIN, (Object)this.confirmRemoveProxyExcludeDomain);
    }

    @ZapApiIgnore
    public String[] getSecurityProtocolsEnabled() {
        return Arrays.copyOf(this.securityProtocolsEnabled, this.securityProtocolsEnabled.length);
    }

    public void setSecurityProtocolsEnabled(String[] enabledProtocols) {
        int i;
        if (enabledProtocols == null || enabledProtocols.length == 0) {
            return;
        }
        for (i = 0; i < enabledProtocols.length; ++i) {
            if (enabledProtocols[i] != null && !enabledProtocols[i].isEmpty()) continue;
            throw new IllegalArgumentException("The parameter enabledProtocols must not contain null or empty elements.");
        }
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_SECURITY_PROTOCOLS_ENABLED_KEY);
        for (i = 0; i < enabledProtocols.length; ++i) {
            String elementBaseKey = "connection.securityProtocolsEnabled.protocol(" + i + ")";
            this.getConfig().setProperty(elementBaseKey, (Object)enabledProtocols[i]);
        }
        this.securityProtocolsEnabled = Arrays.copyOf(enabledProtocols, enabledProtocols.length);
        SSLConnector.setClientEnabledProtocols(enabledProtocols);
    }

    private void loadSecurityProtocolsEnabled() {
        List protocols = this.getConfig().getList(ALL_SECURITY_PROTOCOLS_ENABLED_KEY);
        if (protocols.size() != 0) {
            this.securityProtocolsEnabled = new String[protocols.size()];
            this.securityProtocolsEnabled = protocols.toArray(this.securityProtocolsEnabled);
            SSLConnector.setClientEnabledProtocols(this.securityProtocolsEnabled);
        } else {
            this.setSecurityProtocolsEnabled(SSLConnector.getClientEnabledProtocols());
        }
    }

    public String getDefaultUserAgent() {
        return this.defaultUserAgent;
    }

    public void setDefaultUserAgent(String defaultUserAgent) {
        this.defaultUserAgent = defaultUserAgent;
        this.getConfig().setProperty(DEFAULT_USER_AGENT, (Object)defaultUserAgent);
    }

    public int getDnsTtlSuccessfulQueries() {
        return this.dnsTtlSuccessfulQueries;
    }

    public void setDnsTtlSuccessfulQueries(int ttl) {
        if (this.dnsTtlSuccessfulQueries == ttl) {
            return;
        }
        this.dnsTtlSuccessfulQueries = ttl;
        this.getConfig().setProperty(DNS_TTL_SUCCESSFUL_QUERIES_KEY, (Object)ttl);
    }
}

