/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;

public class VariantUserDefined
implements Variant {
    private static Map<String, int[][]> injectionPointMap = new HashMap<String, int[][]>();
    private int headerLength;
    private int bodyLength;
    private int[][] injectionPoints = null;
    private static final Logger logger = Logger.getLogger(VariantUserDefined.class);

    public static void setInjectionPoints(String url, int[][] injectionPoints) {
        injectionPointMap.put(url, injectionPoints);
    }

    @Override
    public void setMessage(HttpMessage msg) {
        this.headerLength = msg.getRequestHeader().toString().length();
        this.bodyLength = msg.getRequestBody().toString().length();
        String url = msg.getRequestHeader().getURI().toString();
        this.injectionPoints = injectionPointMap.get(url);
    }

    @Override
    public List<NameValuePair> getParamList() {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        if (this.injectionPoints != null) {
            for (int i = 0; i < this.injectionPoints.length; ++i) {
                if (this.isInHeader(this.injectionPoints[i]) || this.isInBody(this.injectionPoints[i])) {
                    list.add(new NameValuePair(-1, "", "", i));
                    continue;
                }
                logger.warn((Object)("Invalid injection point: " + Arrays.toString(this.injectionPoints[i])));
            }
        }
        return list;
    }

    @Override
    public String setParameter(HttpMessage msg, NameValuePair originalPair, String param, String value) {
        int[] injPoint = this.injectionPoints[originalPair.getPosition()];
        if (this.isInHeader(injPoint)) {
            String header = msg.getRequestHeader().toString();
            StringBuilder sb = new StringBuilder(header.length());
            sb.append(header.substring(0, injPoint[0]));
            sb.append(value);
            sb.append(header.substring(injPoint[1]));
            try {
                msg.getRequestHeader().setMessage(sb.toString());
            }
            catch (HttpMalformedHeaderException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            String body = msg.getRequestBody().toString();
            StringBuilder sb = new StringBuilder(body.length());
            sb.append(body.substring(0, injPoint[0] - this.headerLength));
            sb.append(value);
            sb.append(body.substring(injPoint[1] - this.headerLength));
            msg.getRequestBody().setBody(sb.toString());
        }
        return "value";
    }

    @Override
    public String setEscapedParameter(HttpMessage msg, NameValuePair originalPair, String param, String value) {
        return this.setParameter(msg, originalPair, param, value);
    }

    private boolean isInHeader(int[] injPoint) {
        return injPoint[0] < this.headerLength && injPoint[1] < this.headerLength;
    }

    private boolean isInBody(int[] injPoint) {
        return injPoint[0] > this.headerLength && injPoint[1] > this.headerLength && injPoint[0] - this.headerLength < this.bodyLength && injPoint[1] - this.headerLength < this.bodyLength;
    }
}

