/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.common.ThreadPool;
import org.parosproxy.paros.core.scanner.AbstractAppPlugin;
import org.parosproxy.paros.core.scanner.AbstractHostPlugin;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.Analyser;
import org.parosproxy.paros.core.scanner.Kb;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.core.scanner.PluginFactory;
import org.parosproxy.paros.core.scanner.Scanner;
import org.parosproxy.paros.core.scanner.ScannerHook;
import org.parosproxy.paros.core.scanner.ScannerParam;
import org.parosproxy.paros.core.scanner.Util;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.zaproxy.zap.extension.ascan.ScanPolicy;
import org.zaproxy.zap.extension.ruleconfig.RuleConfig;
import org.zaproxy.zap.extension.ruleconfig.RuleConfigParam;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.model.TechSet;
import org.zaproxy.zap.users.User;

public class HostProcess
implements Runnable {
    private static final Logger log = Logger.getLogger(HostProcess.class);
    private static final DecimalFormat decimalFormat = new DecimalFormat("###0.###");
    private List<StructuralNode> startNodes = null;
    private boolean isStop = false;
    private PluginFactory pluginFactory;
    private ScannerParam scannerParam = null;
    private HttpSender httpSender = null;
    private ThreadPool threadPool = null;
    private Scanner parentScanner = null;
    private String hostAndPort = "";
    private Analyser analyser = null;
    private Kb kb = null;
    private User user = null;
    private TechSet techSet;
    private RuleConfigParam ruleConfigParam;
    private String stopReason = null;
    private final Map<Integer, PluginStats> mapPluginStats = new HashMap<Integer, PluginStats>();
    private long hostProcessStartTime = 0L;
    private int nodeInScopeCount = 0;
    private int percentage = 0;
    private int requestCount;

    @Deprecated
    public HostProcess(String hostAndPort, Scanner parentScanner, ScannerParam scannerParam, ConnectionParam connectionParam, ScanPolicy scanPolicy) {
        this(hostAndPort, parentScanner, scannerParam, connectionParam, scanPolicy, null);
    }

    public HostProcess(String hostAndPort, Scanner parentScanner, ScannerParam scannerParam, ConnectionParam connectionParam, ScanPolicy scanPolicy, RuleConfigParam ruleConfigParam) {
        this.hostAndPort = hostAndPort;
        this.parentScanner = parentScanner;
        this.scannerParam = scannerParam;
        this.pluginFactory = scanPolicy.getPluginFactory().clone();
        this.ruleConfigParam = ruleConfigParam;
        this.httpSender = new HttpSender(connectionParam, true, 2);
        this.httpSender.setUser(this.user);
        this.httpSender.setRemoveUserDefinedAuthHeaders(true);
        int maxNumberOfThreads = scannerParam.getHandleAntiCSRFTokens() ? 1 : scannerParam.getThreadPerHost();
        this.threadPool = new ThreadPool(maxNumberOfThreads, "ZAP-ActiveScanner-");
        this.techSet = TechSet.AllTech;
    }

    public void setStartNode(StructuralNode startNode) {
        this.startNodes = new ArrayList<StructuralNode>();
        this.startNodes.add(startNode);
    }

    public void addStartNode(StructuralNode startNode) {
        if (this.startNodes == null) {
            this.startNodes = new ArrayList<StructuralNode>();
        }
        this.startNodes.add(startNode);
    }

    public void stop() {
        this.isStop = true;
        this.getAnalyser().stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.debug((Object)"HostProcess.run");
        try {
            TraverseCounter counter = new TraverseCounter();
            this.hostProcessStartTime = System.currentTimeMillis();
            for (StructuralNode node : this.startNodes) {
                this.traverse(node, true, counter);
                this.getAnalyser().start(node);
            }
            this.nodeInScopeCount = counter.getCount();
            this.logScanInfo();
            while (!this.isStop() && this.pluginFactory.existPluginToRun()) {
                Plugin plugin = this.pluginFactory.nextPlugin();
                if (plugin != null) {
                    plugin.setDelayInMs(this.scannerParam.getDelayInMs());
                    plugin.setTechSet(this.techSet);
                    this.processPlugin(plugin);
                    continue;
                }
                Util.sleep(1000);
            }
            this.threadPool.waitAllThreadComplete(300000);
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while active scanning:", (Throwable)e);
            this.stop();
        }
        finally {
            this.notifyHostProgress(null);
            this.notifyHostComplete();
            this.getHttpSender().shutdown();
        }
    }

    private void logScanInfo() {
        StringBuilder strBuilder = new StringBuilder(150);
        strBuilder.append("Scanning ");
        strBuilder.append(this.nodeInScopeCount);
        strBuilder.append(" node(s) ");
        if (this.parentScanner.getJustScanInScope()) {
            strBuilder.append("[just in scope] ");
        }
        strBuilder.append("from ").append(this.hostAndPort);
        if (this.user != null) {
            strBuilder.append(" as ");
            strBuilder.append(this.user.getName());
        }
        log.info((Object)strBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPlugin(final Plugin plugin) {
        Map<Integer, PluginStats> map = this.mapPluginStats;
        synchronized (map) {
            this.mapPluginStats.put(plugin.getId(), new PluginStats());
        }
        if (!plugin.targets(this.techSet)) {
            this.pluginSkipped(plugin, Constant.messages.getString("ascan.progress.label.skipped.reason.techs"));
            this.pluginCompleted(plugin);
            return;
        }
        log.info((Object)("start host " + this.hostAndPort + " | " + plugin.getCodeName() + " strength " + (Object)((Object)plugin.getAttackStrength()) + " threshold " + (Object)((Object)plugin.getAlertThreshold())));
        for (StructuralNode startNode : this.startNodes) {
            if (plugin instanceof AbstractHostPlugin) {
                if (this.scanSingleNode(plugin, startNode)) continue;
                this.pluginCompleted(plugin);
                continue;
            }
            if (!(plugin instanceof AbstractAppPlugin)) continue;
            try {
                this.traverse(startNode, true, new TraverseAction(){

                    @Override
                    public void apply(StructuralNode node) {
                        log.debug((Object)("traverse: plugin=" + plugin.getName() + " url=" + node.getName()));
                        HostProcess.this.scanSingleNode(plugin, node);
                    }

                    @Override
                    public boolean isStopTraversing() {
                        return HostProcess.this.isSkipped(plugin);
                    }
                });
                this.threadPool.waitAllThreadComplete(600000);
            }
            finally {
                this.pluginCompleted(plugin);
            }
        }
    }

    private void traverse(StructuralNode node, TraverseAction action) {
        this.traverse(node, false, action);
    }

    private void traverse(StructuralNode node, boolean incRelatedSiblings, TraverseAction action) {
        if (node == null || this.isStop()) {
            return;
        }
        HashSet<StructuralNode> parentNodes = new HashSet<StructuralNode>();
        parentNodes.add(node);
        action.apply(node);
        if (!action.isStopTraversing() && this.parentScanner.scanChildren()) {
            if (incRelatedSiblings) {
                try {
                    Iterator<StructuralNode> iter = node.getParent().getChildIterator();
                    String nodeName = SessionStructure.getCleanRelativeName(node, false);
                    while (iter.hasNext()) {
                        StructuralNode sibling = iter.next();
                        if (node.isSameAs(sibling) || !nodeName.equals(SessionStructure.getCleanRelativeName(sibling, false))) continue;
                        log.debug((Object)("traverse: including related sibling " + sibling.getName()));
                        parentNodes.add(sibling);
                    }
                }
                catch (DatabaseException databaseException) {
                    // empty catch block
                }
            }
            for (StructuralNode pNode : parentNodes) {
                Iterator<StructuralNode> iter = pNode.getChildIterator();
                while (iter.hasNext() && !this.isStop() && !action.isStopTraversing()) {
                    StructuralNode child = iter.next();
                    while (this.parentScanner.isPaused() && !this.isStop()) {
                        Util.sleep(500);
                    }
                    try {
                        this.traverse(child, action);
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    protected boolean nodeInScope(String nodeName) {
        return this.parentScanner.isInScope(nodeName);
    }

    private boolean scanSingleNode(Plugin plugin, StructuralNode node) {
        Thread thread;
        Plugin test;
        if (!this.canScanNode(node)) {
            return false;
        }
        try {
            HistoryReference hRef = node.getHistoryReference();
            HttpMessage msg = hRef.getHttpMessage();
            if (msg == null) {
                log.debug((Object)"scanSingleNode msg null");
                return false;
            }
            if (msg.getResponseHeader().isEmpty() && !this.obtainResponse(hRef, msg = msg.cloneRequest())) {
                return false;
            }
            log.debug((Object)("scanSingleNode node plugin=" + plugin.getName() + " node=" + node.getName()));
            test = (Plugin)plugin.getClass().newInstance();
            test.setConfig(plugin.getConfig());
            if (this.ruleConfigParam != null) {
                for (RuleConfig rc : this.ruleConfigParam.getAllRuleConfigs()) {
                    test.getConfig().setProperty(rc.getKey(), (Object)rc.getValue());
                }
            }
            test.setDelayInMs(plugin.getDelayInMs());
            test.setDefaultAlertThreshold(plugin.getAlertThreshold());
            test.setDefaultAttackStrength(plugin.getAttackStrength());
            test.setTechSet(this.getTechSet());
            test.init(msg, this);
            this.notifyHostProgress(plugin.getName() + ": " + msg.getRequestHeader().getURI().toString());
        }
        catch (Exception e) {
            log.error((Object)(e.getMessage() + " " + node.getName()), (Throwable)e);
            return false;
        }
        do {
            if (this.isStop()) {
                return false;
            }
            thread = this.threadPool.getFreeThreadAndRun(test);
            if (thread != null) continue;
            Util.sleep(200);
        } while (thread == null);
        this.mapPluginStats.get(plugin.getId()).incProgress();
        return true;
    }

    private boolean obtainResponse(HistoryReference hRef, HttpMessage message) {
        try {
            this.getHttpSender().sendAndReceive(message);
            this.notifyNewMessage(message);
            ++this.requestCount;
            return true;
        }
        catch (IOException e) {
            log.warn((Object)("Failed to obtain the HTTP response for href [id=" + hRef.getHistoryId() + ", type=" + hRef.getHistoryType() + ", URL=" + hRef.getURI() + "]: " + e.getMessage()));
            return false;
        }
    }

    private boolean canScanNode(StructuralNode node) {
        if (node == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Ignoring null node");
            }
            return false;
        }
        HistoryReference hRef = node.getHistoryReference();
        if (hRef == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Ignoring null history reference for node: " + node.getName()));
            }
            return false;
        }
        if (3 == hRef.getHistoryType()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Ignoring \"scanner\" type href [id=" + hRef.getHistoryId() + ", URL=" + hRef.getURI() + "]"));
            }
            return false;
        }
        if (!this.nodeInScope(node.getName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Ignoring node not in scope: " + node.getName()));
            }
            return false;
        }
        return true;
    }

    public int getTestTotalCount() {
        return this.nodeInScopeCount;
    }

    public int getTestCurrentCount(Plugin plugin) {
        PluginStats pluginStats = this.mapPluginStats.get(plugin.getId());
        if (pluginStats == null) {
            return 0;
        }
        return pluginStats.getProgress();
    }

    @Deprecated
    public void setTestCurrentCount(Plugin plugin, int value) {
    }

    public HttpSender getHttpSender() {
        return this.httpSender;
    }

    public boolean isStop() {
        if (this.scannerParam.getMaxScanDurationInMins() > 0 && System.currentTimeMillis() - this.hostProcessStartTime > TimeUnit.MINUTES.toMillis(this.scannerParam.getMaxScanDurationInMins())) {
            this.stopReason = Constant.messages.getString("ascan.progress.label.skipped.reason.maxScan");
            this.stop();
        }
        return this.isStop || this.parentScanner.isStop();
    }

    public boolean isPaused() {
        return this.parentScanner.isPaused();
    }

    public int getPercentageComplete() {
        return this.percentage;
    }

    private void notifyHostProgress(String msg) {
        if (this.pluginFactory.totalPluginToRun() == 0) {
            this.percentage = 100;
        } else {
            int numberRunning = 0;
            double progressRunning = 0.0;
            for (Plugin plugin : this.pluginFactory.getRunning()) {
                int scannedNodes = this.getTestCurrentCount(plugin);
                double pluginPercentage = (double)scannedNodes * 100.0 / (double)this.getTestTotalCount();
                if (pluginPercentage >= 100.0) {
                    this.nodeInScopeCount = scannedNodes;
                    pluginPercentage = 99.0;
                }
                progressRunning += pluginPercentage;
                ++numberRunning;
            }
            int avgRunning = (int)(progressRunning / (double)numberRunning);
            this.percentage = (100 * this.pluginFactory.totalPluginCompleted() + avgRunning) / this.pluginFactory.totalPluginToRun();
        }
        this.parentScanner.notifyHostProgress(this.hostAndPort, msg, this.percentage);
    }

    private void notifyHostComplete() {
        long diffTimeMillis = System.currentTimeMillis() - this.hostProcessStartTime;
        String diffTimeString = decimalFormat.format((double)diffTimeMillis / 1000.0) + "s";
        log.info((Object)("completed host " + this.hostAndPort + " in " + diffTimeString));
        this.parentScanner.notifyHostComplete(this.hostAndPort);
    }

    public void notifyNewMessage(HttpMessage msg) {
        this.parentScanner.notifyNewMessage(msg);
    }

    public void notifyNewMessage(Plugin plugin, HttpMessage message) {
        this.parentScanner.notifyNewMessage(message);
        this.notifyNewMessage(plugin);
    }

    public void notifyNewMessage(Plugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Parameter plugin must not be null.");
        }
        PluginStats pluginStats = this.mapPluginStats.get(plugin.getId());
        if (pluginStats != null) {
            pluginStats.incMessageCount();
        }
    }

    public void alertFound(Alert alert) {
        this.parentScanner.notifyAlertFound(alert);
    }

    public Analyser getAnalyser() {
        if (this.analyser == null) {
            this.analyser = new Analyser(this.getHttpSender(), this);
        }
        return this.analyser;
    }

    public boolean handleAntiCsrfTokens() {
        return this.scannerParam.getHandleAntiCSRFTokens();
    }

    public void pluginSkipped(Plugin plugin) {
        this.pluginSkipped(plugin, null);
    }

    public void pluginSkipped(Plugin plugin, String reason) {
        PluginStats pluginStats = this.mapPluginStats.get(plugin.getId());
        if (pluginStats == null) {
            return;
        }
        pluginStats.skipped();
        pluginStats.setSkippedReason(reason);
    }

    public boolean isSkipped(Plugin plugin) {
        PluginStats pluginStats = this.mapPluginStats.get(plugin.getId());
        if (pluginStats != null && pluginStats.isSkipped()) {
            return true;
        }
        if (plugin.getTimeFinished() == null && this.stopReason != null) {
            this.pluginSkipped(plugin, this.stopReason);
            return true;
        }
        if (this.scannerParam.getMaxRuleDurationInMins() > 0 && plugin.getTimeStarted() != null) {
            long endtime = System.currentTimeMillis();
            if (plugin.getTimeFinished() != null) {
                endtime = plugin.getTimeFinished().getTime();
            }
            if (endtime - plugin.getTimeStarted().getTime() > TimeUnit.MINUTES.toMillis(this.scannerParam.getMaxRuleDurationInMins())) {
                this.pluginSkipped(plugin, Constant.messages.getString("ascan.progress.label.skipped.reason.maxRule"));
                return true;
            }
        }
        return false;
    }

    public String getSkippedReason(Plugin plugin) {
        PluginStats pluginStats = this.mapPluginStats.get(plugin.getId());
        if (pluginStats == null) {
            return this.stopReason;
        }
        return pluginStats.getSkippedReason();
    }

    void pluginCompleted(Plugin plugin) {
        PluginStats pluginStats = this.mapPluginStats.get(plugin.getId());
        if (pluginStats == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (this.isStop()) {
            sb.append("stopped host/plugin ");
        } else if (pluginStats.isSkipped()) {
            sb.append("skipped plugin ");
            String reason = pluginStats.getSkippedReason();
            if (reason != null) {
                sb.append('[').append(reason).append("] ");
            }
        } else {
            sb.append("completed host/plugin ");
        }
        sb.append(this.hostAndPort).append(" | ").append(plugin.getCodeName());
        long startTimeMillis = pluginStats.getStartTime();
        long diffTimeMillis = System.currentTimeMillis() - startTimeMillis;
        String diffTimeString = decimalFormat.format((double)diffTimeMillis / 1000.0);
        sb.append(" in ").append(diffTimeString).append('s');
        sb.append(" with ").append(pluginStats.getMessageCount()).append(" message(s) sent");
        log.info((Object)sb.toString());
        this.pluginFactory.setRunningPluginCompleted(plugin);
        this.notifyHostProgress(null);
        pluginStats.setProgress(this.nodeInScopeCount);
    }

    Kb getKb() {
        if (this.kb == null) {
            this.kb = new Kb();
        }
        return this.kb;
    }

    protected ScannerParam getScannerParam() {
        return this.scannerParam;
    }

    public List<Plugin> getPending() {
        return this.pluginFactory.getPending();
    }

    public List<Plugin> getRunning() {
        return this.pluginFactory.getRunning();
    }

    public List<Plugin> getCompleted() {
        return this.pluginFactory.getCompleted();
    }

    public void setUser(User user) {
        this.user = user;
        if (this.httpSender != null) {
            this.httpSender.setUser(user);
        }
    }

    public TechSet getTechSet() {
        return this.techSet;
    }

    public void setTechSet(TechSet techSet) {
        if (techSet == null) {
            throw new IllegalArgumentException("Parameter techSet must not be null.");
        }
        this.techSet = techSet;
    }

    protected synchronized void performScannerHookBeforeScan(HttpMessage msg, AbstractPlugin plugin) {
        for (ScannerHook hook : this.parentScanner.getScannerHooks()) {
            if (hook == null) continue;
            try {
                hook.beforeScan(msg, plugin, this.parentScanner);
            }
            catch (Exception e) {
                log.info((Object)("An exception occurred while trying to call beforeScan(msg, plugin) for one of the ScannerHooks: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected synchronized void performScannerHookAfterScan(HttpMessage msg, AbstractPlugin plugin) {
        for (ScannerHook hook : this.parentScanner.getScannerHooks()) {
            if (hook == null) continue;
            try {
                hook.afterScan(msg, plugin, this.parentScanner);
            }
            catch (Exception e) {
                log.info((Object)("An exception occurred while trying to call afterScan(msg, plugin) for one of the ScannerHooks: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public String getHostAndPort() {
        return this.hostAndPort;
    }

    @Deprecated
    public void setPluginRequestCount(int pluginId, int reqCount) {
    }

    public int getPluginRequestCount(int pluginId) {
        PluginStats pluginStats = this.mapPluginStats.get(pluginId);
        if (pluginStats != null) {
            return pluginStats.getMessageCount();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRequestCount() {
        Map<Integer, PluginStats> map = this.mapPluginStats;
        synchronized (map) {
            int count = this.requestCount + this.getAnalyser().getRequestCount();
            for (PluginStats stats : this.mapPluginStats.values()) {
                count += stats.getMessageCount();
            }
            return count;
        }
    }

    private static class PluginStats {
        private final long startTime = System.currentTimeMillis();
        private int messageCount;
        private int progress;
        private boolean skipped;
        private String skippedReason;

        public boolean isSkipped() {
            return this.skipped;
        }

        public void skipped() {
            this.skipped = true;
        }

        public void setSkippedReason(String reason) {
            this.skippedReason = reason;
        }

        public String getSkippedReason() {
            return this.skippedReason;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public int getMessageCount() {
            return this.messageCount;
        }

        public void incMessageCount() {
            ++this.messageCount;
        }

        public int getProgress() {
            return this.progress;
        }

        public void incProgress() {
            ++this.progress;
        }

        public void setProgress(int progress) {
            this.progress = progress;
        }
    }

    private class TraverseCounter
    implements TraverseAction {
        private int count;

        private TraverseCounter() {
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public void apply(StructuralNode node) {
            if (HostProcess.this.canScanNode(node)) {
                ++this.count;
            }
        }

        @Override
        public boolean isStopTraversing() {
            return false;
        }
    }

    private static interface TraverseAction {
        public void apply(StructuralNode var1);

        public boolean isStopTraversing();
    }
}

