/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.io.IOException;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.SampleResponse;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.network.HttpStatusCode;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.network.HttpRedirectionValidator;
import org.zaproxy.zap.network.HttpRequestConfig;

public class Analyser {
    private static final Logger logger = Logger.getLogger(Analyser.class);
    private static final String p_REMOVE_HEADER = "(?m)(?i)(?s)<HEAD>.*?</HEAD>";
    private static final Pattern patternNotFound = Pattern.compile("(\\bnot\\b(found|exist))|(\\b404\\berror\\b)|(\\berror\\b404\\b)", 10);
    private static Random staticRandomGenerator = new Random();
    private static final String[] staticSuffixList = new String[]{".cfm", ".jsp", ".php", ".asp", ".aspx", ".dll", ".exe", ".pl"};
    private HttpSender httpSender = null;
    private TreeMap<String, SampleResponse> mapVisited = new TreeMap();
    private boolean isStop = false;
    private int delayInMs;
    private int requestCount;
    private HttpRequestConfig httpRequestConfig;
    HostProcess parent = null;

    public Analyser() {
    }

    public Analyser(HttpSender httpSender, HostProcess parent) {
        this.httpSender = httpSender;
        this.parent = parent;
    }

    public boolean isStop() {
        return this.isStop;
    }

    public void stop() {
        this.isStop = true;
    }

    public void start(StructuralNode node) {
        this.inOrderAnalyse(node);
    }

    private void addAnalysedHost(URI uri, HttpMessage msg, int errorIndicator) {
        try {
            this.mapVisited.put(uri.toString(), new SampleResponse(msg, errorIndicator));
        }
        catch (DatabaseException | HttpMalformedHeaderException e) {
            logger.error((Object)("Failed to persist the message: " + e.getMessage()), (Throwable)e);
        }
    }

    private void analyse(StructuralNode node) throws Exception {
        if (node.getHistoryReference() == null) {
            return;
        }
        if (!this.parent.nodeInScope(node.getName())) {
            return;
        }
        HttpMessage baseMsg = node.getHistoryReference().getHttpMessage();
        URI baseUri = (URI)baseMsg.getRequestHeader().getURI().clone();
        baseUri.setQuery(null);
        if (this.mapVisited.get(baseUri.toString()) != null) {
            return;
        }
        String path = this.getRandomPathSuffix(node, baseUri);
        HttpMessage msg = baseMsg.cloneRequest();
        URI uri = (URI)baseUri.clone();
        uri.setPath(path);
        msg.getRequestHeader().setURI(uri);
        this.sendAndReceive(msg);
        if (msg.getResponseHeader().getStatusCode() == 404) {
            this.addAnalysedHost(baseUri, msg, 0);
            return;
        }
        if (HttpStatusCode.isRedirection(msg.getResponseHeader().getStatusCode())) {
            this.addAnalysedHost(baseUri, msg, 2);
            return;
        }
        if (msg.getResponseHeader().getStatusCode() != 200) {
            this.addAnalysedHost(baseUri, msg, 1);
            return;
        }
        HttpMessage msg2 = baseMsg.cloneRequest();
        URI uri2 = msg2.getRequestHeader().getURI();
        String path2 = this.getRandomPathSuffix(node, uri2);
        uri2 = (URI)baseUri.clone();
        uri2.setPath(path2);
        msg2.getRequestHeader().setURI(uri2);
        this.sendAndReceive(msg2);
        String resBody1 = msg.getResponseBody().toString().replaceAll(p_REMOVE_HEADER, "");
        String resBody2 = msg2.getResponseBody().toString().replaceAll(p_REMOVE_HEADER, "");
        if (resBody1.equals(resBody2)) {
            msg.getResponseBody().setBody(resBody1);
            this.addAnalysedHost(baseUri, msg, 3);
            return;
        }
        if ((resBody1 = resBody1.replaceAll(this.getPathRegex(uri), "").replaceAll("\\s[012]\\d:[0-5]\\d:[0-5]\\d\\s", "")).equals(resBody2 = resBody2.replaceAll(this.getPathRegex(uri2), "").replaceAll("\\s[012]\\d:[0-5]\\d:[0-5]\\d\\s", ""))) {
            msg.getResponseBody().setBody(resBody1);
            this.addAnalysedHost(baseUri, msg, 4);
            return;
        }
        this.addAnalysedHost(baseUri, msg, 5);
    }

    private String getChildSuffix(StructuralNode node, boolean performRecursiveCheck) {
        String resultSuffix = "";
        String suffix = null;
        StructuralNode child = null;
        try {
            for (int i = 0; i < staticSuffixList.length; ++i) {
                suffix = staticSuffixList[i];
                Iterator<StructuralNode> iter = node.getChildIterator();
                while (iter.hasNext()) {
                    child = iter.next();
                    try {
                        if (!child.getURI().getPath().endsWith(suffix)) continue;
                        return suffix;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            if (performRecursiveCheck) {
                Iterator<StructuralNode> iter = node.getChildIterator();
                while (iter.hasNext()) {
                    child = iter.next();
                    resultSuffix = this.getChildSuffix(child, performRecursiveCheck);
                    if (resultSuffix.equals("")) continue;
                    return resultSuffix;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resultSuffix;
    }

    private String getPathRegex(URI uri) throws URIException {
        URI newUri;
        try {
            newUri = (URI)uri.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new URIException(e.getMessage());
        }
        String query = newUri.getQuery();
        StringBuilder sb = new StringBuilder(100);
        newUri.setQuery(null);
        sb.append(newUri.toString().replaceAll("\\.", "\\."));
        if (query != null) {
            String queryPattern = "(\\?" + query + ")?";
            sb.append(queryPattern);
        }
        return sb.toString();
    }

    private String getRandomPathSuffix(StructuralNode node, URI uri) throws URIException {
        String resultSuffix = this.getChildSuffix(node, true);
        String path = "";
        path = uri.getPath() == null ? "" : uri.getPath();
        path = path + (path.endsWith("/") ? "" : "/") + Long.toString(this.getRndPositiveLong());
        path = path + resultSuffix;
        return path;
    }

    private long getRndPositiveLong() {
        long rnd = Long.MIN_VALUE;
        while (rnd == Long.MIN_VALUE) {
            rnd = staticRandomGenerator.nextLong();
        }
        return Math.abs(rnd);
    }

    private int inOrderAnalyse(StructuralNode node) {
        int subtreeNodes;
        block6: {
            subtreeNodes = 0;
            if (this.isStop) {
                return 0;
            }
            if (node == null) {
                return 0;
            }
            try {
                if (node.isRoot()) break block6;
                if (!node.isLeaf() || node.isLeaf() && node.getParent().isRoot()) {
                    this.analyse(node);
                    break block6;
                }
                return 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Iterator<StructuralNode> iter = node.getChildIterator();
        while (iter.hasNext()) {
            subtreeNodes += this.inOrderAnalyse(iter.next());
        }
        return subtreeNodes + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileExist(HttpMessage msg) {
        if (msg.getResponseHeader().isEmpty()) {
            return false;
        }
        if (msg.getResponseHeader().getStatusCode() == 404) {
            return false;
        }
        URI uri = null;
        String sUri = null;
        try {
            uri = (URI)msg.getRequestHeader().getURI().clone();
            uri.setQuery(null);
            String path = uri.getPath();
            path = path.replaceAll("/[^/]*$", "");
            uri.setPath(path);
        }
        catch (Exception path) {
        }
        finally {
            if (uri != null) {
                sUri = uri.toString();
            }
        }
        SampleResponse sample = this.mapVisited.get(sUri);
        if (sample == null) {
            try {
                uri.setPath(null);
            }
            catch (URIException uRIException) {
                // empty catch block
            }
            String sHostOnly = uri.toString();
            sample = this.mapVisited.get(sHostOnly);
        }
        if (sample == null) {
            return msg.getResponseHeader().getStatusCode() == 200;
        }
        if (HttpStatusCode.isRedirection(msg.getResponseHeader().getStatusCode())) {
            try {
                String location;
                if (sample.getMessage().getResponseHeader().getStatusCode() == msg.getResponseHeader().getStatusCode() && (location = msg.getResponseHeader().getHeader("Location")) != null && location.equals(sample.getMessage().getResponseHeader().getHeader("Location"))) {
                    return false;
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return true;
        }
        if (msg.getResponseHeader().getStatusCode() != 200) {
            return false;
        }
        Matcher matcher = patternNotFound.matcher(msg.getResponseBody().toString());
        if (matcher.find()) {
            return false;
        }
        String body = msg.getResponseBody().toString().replaceAll(p_REMOVE_HEADER, "");
        if (sample.getErrorPageType() == 3) {
            try {
                if (sample.getMessage().getResponseBody().toString().equals(body)) {
                    return false;
                }
            }
            catch (DatabaseException | HttpMalformedHeaderException e) {
                logger.error((Object)("Failed to read the message: " + e.getMessage()), (Throwable)e);
            }
            return true;
        }
        uri = msg.getRequestHeader().getURI();
        try {
            if (sample.getErrorPageType() == 4) {
                body = msg.getResponseBody().toString().replaceAll(this.getPathRegex(uri), "").replaceAll("\\s[012]\\d:[0-5]\\d:[0-5]\\d\\s", "");
                return !sample.getMessage().getResponseBody().toString().equals(body);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private void sendAndReceive(HttpMessage msg) throws HttpException, IOException {
        if (this.getDelayInMs() > 0) {
            try {
                Thread.sleep(this.getDelayInMs());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.httpSender.sendAndReceive(msg, this.getHttpRequestConfig());
        ++this.requestCount;
        if (this.parent != null) {
            this.parent.notifyNewMessage(msg);
        }
    }

    private HttpRequestConfig getHttpRequestConfig() {
        if (this.httpRequestConfig == null) {
            this.httpRequestConfig = HttpRequestConfig.builder().setRedirectionValidator(new HttpRedirectionValidator(){

                @Override
                public boolean isValid(URI redirection) {
                    if (!Analyser.this.parent.nodeInScope(redirection.getEscapedURI())) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Skipping redirection out of scan's scope: " + redirection));
                        }
                        return false;
                    }
                    return true;
                }

                @Override
                public void notifyMessageReceived(HttpMessage message) {
                }
            }).build();
        }
        return this.httpRequestConfig;
    }

    public int getDelayInMs() {
        return this.delayInMs;
    }

    public void setDelayInMs(int delayInMs) {
        this.delayInMs = delayInMs;
    }

    public int getRequestCount() {
        return this.requestCount;
    }
}

