/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidParameterException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.parosproxy.paros.model.FileCopier;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.utils.I18N;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

public final class Constant {
    public static final String PROGRAM_NAME = "OWASP ZAP";
    public static final String PROGRAM_NAME_SHORT = "ZAP";
    public static final String ZAP_HOMEPAGE = "http://www.owasp.org/index.php/ZAP";
    public static final String ZAP_EXTENSIONS_PAGE = "https://github.com/zaproxy/zap-extensions";
    public static final String ZAP_TEAM = "ZAP Dev Team";
    public static final String PAROS_TEAM = "Chinotec Technologies";
    private static final String DEV_VERSION = "Dev Build";
    public static final String ALPHA_VERSION = "alpha";
    public static final String BETA_VERSION = "beta";
    private static final long VERSION_TAG = 2005000L;
    private static final long V_2_5_0_TAG = 2005000L;
    private static final long V_2_4_3_TAG = 2004003L;
    private static final long V_2_3_1_TAG = 2003001L;
    private static final long V_2_2_0_TAG = 2002000L;
    private static final long V_2_1_0_TAG = 2001000L;
    private static final long V_2_0_0_TAG = 2000000L;
    private static final long V_1_4_1_TAG = 1004001L;
    private static final long V_1_3_1_TAG = 1003001L;
    private static final long V_1_3_0_TAG = 1003000L;
    private static final long V_1_2_1_TAG = 1002001L;
    private static final long V_1_2_0_TAG = 1002000L;
    private static final long V_1_1_0_TAG = 1001000L;
    private static final long V_1_0_0_TAG = 1000000L;
    private static final long V_PAROS_TAG = 30020013L;
    public static String PROGRAM_VERSION = "Dev Build";
    public static String PROGRAM_TITLE = "OWASP ZAP " + PROGRAM_VERSION;
    public static final String SYSTEM_PAROS_USER_LOG = "zap.user.log";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    @Deprecated
    public static final String FILE_CONFIG_DEFAULT = "xml/config.xml";
    public static final String FILE_CONFIG_NAME = "config.xml";
    public static final String FOLDER_PLUGIN = "plugin";
    public static final String FOLDER_FILTER = "filter";
    public static final String FOLDER_SESSION_DEFAULT = "session";
    public static final String DBNAME_TEMPLATE = "db" + System.getProperty("file.separator") + "zapdb";
    public static final String MESSAGES_PREFIX = "Messages";
    public static final String MESSAGES_EXTENSION = ".properties";
    public static final String DBNAME_UNTITLED_DEFAULT = "session" + System.getProperty("file.separator") + "untitled";
    public String FILE_CONFIG = "config.xml";
    public String FOLDER_SESSION = "session";
    public String DBNAME_UNTITLED = this.FOLDER_SESSION + System.getProperty("file.separator") + "untitled";
    public String ACCEPTED_LICENSE_DEFAULT;
    public String ACCEPTED_LICENSE = this.ACCEPTED_LICENSE_DEFAULT = "AcceptedLicense";
    public static final String FILE_PROGRAM_SPLASH = "resource/zap128x128.png";
    public static String ACCELERATOR_UNDO = "control Z";
    public static String ACCELERATOR_REDO = "control Y";
    public static String ACCELERATOR_TRIGGER_KEY = "Control";
    private static Constant instance = null;
    public static final int MAX_HOST_CONNECTION = 15;
    public static final int MAX_THREADS_PER_SCAN = 50;
    public static final String USER_AGENT = "";
    private static String staticEyeCatcher = "0W45pz4p";
    private static boolean staticSP = false;
    private static final String USER_CONTEXTS_DIR = "contexts";
    private static final String USER_POLICIES_DIR = "policies";
    private static String zapHome = null;
    private static String zapStd = null;
    private static String zapInstall = null;
    private static Boolean onKali = null;
    private static Boolean lowMemoryOption = null;
    public static I18N messages = null;
    private static final Locale SYSTEMS_LOCALE = Locale.getDefault();
    public static final String LANG_DIR = "lang";
    public static final String VULNERABILITIES_PREFIX = "vulnerabilities";
    @Deprecated
    public static String VULNS_BASE = "vulnerabilities";
    public static final String VULNERABILITIES_EXTENSION = ".xml";
    public String DIRBUSTER_DIR;
    public String DIRBUSTER_CUSTOM_DIR = this.DIRBUSTER_DIR = "dirbuster";
    public String FUZZER_DIR = "fuzzers";
    public static String FOLDER_LOCAL_PLUGIN = "plugin";
    public static final URL OK_FLAG_IMAGE_URL = Constant.class.getResource("/resource/icon/10/072.png");
    public static final URL INFO_FLAG_IMAGE_URL = Constant.class.getResource("/resource/icon/10/073.png");
    public static final URL LOW_FLAG_IMAGE_URL = Constant.class.getResource("/resource/icon/10/074.png");
    public static final URL MED_FLAG_IMAGE_URL = Constant.class.getResource("/resource/icon/10/076.png");
    public static final URL HIGH_FLAG_IMAGE_URL = Constant.class.getResource("/resource/icon/10/071.png");
    public static final URL BLANK_IMAGE_URL = Constant.class.getResource("/resource/icon/10/blank.png");
    public static final URL SPIDER_IMAGE_URL = Constant.class.getResource("/resource/icon/10/spider.png");
    private static Logger LOG = Logger.getLogger(Constant.class);
    private static final Pattern patternWindows = Pattern.compile("window", 2);
    private static final Pattern patternLinux = Pattern.compile("linux", 2);
    private static final Pattern patternMacOsX = Pattern.compile("mac", 2);

    public static String getEyeCatcher() {
        return staticEyeCatcher;
    }

    public static void setEyeCatcher(String eyeCatcher) {
        staticEyeCatcher = eyeCatcher;
    }

    public static void setSP(boolean isSP) {
        staticSP = isSP;
    }

    public static boolean isSP() {
        return staticSP;
    }

    public Constant() {
        this.initializeFilesAndDirectories();
        this.setAcceleratorKeys();
    }

    public static String getDefaultHomeDirectory(boolean incDevOption) {
        if (zapStd == null) {
            zapStd = System.getProperty("user.home");
            if (zapStd == null) {
                zapStd = ".";
            }
            zapStd = Constant.isLinux() ? zapStd + FILE_SEPARATOR + "." + PROGRAM_NAME_SHORT : (Constant.isMacOsX() ? zapStd + FILE_SEPARATOR + "Library" + FILE_SEPARATOR + "Application Support" + FILE_SEPARATOR + PROGRAM_NAME_SHORT : zapStd + FILE_SEPARATOR + PROGRAM_NAME);
        }
        if (incDevOption && (Constant.isDevBuild() || Constant.isDailyBuild())) {
            return zapStd + "_D";
        }
        return zapStd;
    }

    public void copyDefaultConfigs(File f, boolean forceReset) throws IOException, ConfigurationException {
        FileCopier copier = new FileCopier();
        File oldf = Constant.isDevBuild() || Constant.isDailyBuild() ? new File(Constant.getDefaultHomeDirectory(false) + FILE_SEPARATOR + FILE_CONFIG_NAME) : new File(zapHome + FILE_SEPARATOR + "zap" + FILE_SEPARATOR + FILE_CONFIG_NAME);
        if (!forceReset && oldf.exists() && Paths.get(zapHome, new String[0]).equals(Paths.get(Constant.getDefaultHomeDirectory(true), new String[0]))) {
            LOG.info((Object)("Copying defaults from " + oldf.getAbsolutePath() + " to " + this.FILE_CONFIG));
            copier.copy(oldf, f);
            if (Constant.isDevBuild() || Constant.isDailyBuild()) {
                ZapXmlConfiguration newConfig = new ZapXmlConfiguration(f);
                newConfig.setProperty("start.downloadDir", FOLDER_LOCAL_PLUGIN);
                newConfig.save();
            }
        } else {
            LOG.info((Object)("Copying defaults from " + Constant.getPathDefaultConfigFile() + " to " + this.FILE_CONFIG));
            copier.copy(Constant.getPathDefaultConfigFile().toFile(), f);
        }
    }

    public void initializeFilesAndDirectories() {
        block39: {
            FileCopier copier = new FileCopier();
            File f = null;
            PROGRAM_VERSION = Constant.getVersionFromManifest();
            PROGRAM_TITLE = "OWASP ZAP " + PROGRAM_VERSION;
            if (zapHome == null) {
                zapHome = Constant.getDefaultHomeDirectory(true);
            }
            zapHome = Constant.getAbsolutePath(zapHome);
            f = new File(zapHome);
            this.FILE_CONFIG = zapHome + this.FILE_CONFIG;
            this.FOLDER_SESSION = zapHome + this.FOLDER_SESSION;
            this.DBNAME_UNTITLED = zapHome + this.DBNAME_UNTITLED;
            this.ACCEPTED_LICENSE = zapHome + this.ACCEPTED_LICENSE;
            this.DIRBUSTER_CUSTOM_DIR = zapHome + this.DIRBUSTER_DIR;
            this.FUZZER_DIR = zapHome + this.FUZZER_DIR;
            FOLDER_LOCAL_PLUGIN = zapHome + FOLDER_LOCAL_PLUGIN;
            try {
                File logFile;
                System.setProperty(SYSTEM_PAROS_USER_LOG, zapHome);
                if (!f.isDirectory() && !f.mkdir()) {
                    System.out.println("Failed to create directory " + f.getAbsolutePath());
                }
                if (!(logFile = new File(zapHome + "/log4j.properties")).exists()) {
                    copier.copy(new File(zapInstall, "xml/log4j.properties"), logFile);
                }
                System.setProperty("log4j.configuration", logFile.getAbsolutePath());
                PropertyConfigurator.configure((String)logFile.getAbsolutePath());
                f = new File(this.FILE_CONFIG);
                if (!f.isFile()) {
                    this.copyDefaultConfigs(f, false);
                }
                if (!(f = new File(this.FOLDER_SESSION)).isDirectory()) {
                    LOG.info((Object)("Creating directory " + this.FOLDER_SESSION));
                    if (!f.mkdir()) {
                        System.out.println("Failed to create directory " + f.getAbsolutePath());
                    }
                }
                if (!(f = new File(this.DIRBUSTER_CUSTOM_DIR)).isDirectory()) {
                    LOG.info((Object)("Creating directory " + this.DIRBUSTER_CUSTOM_DIR));
                    if (!f.mkdir()) {
                        System.out.println("Failed to create directory " + f.getAbsolutePath());
                    }
                }
                if (!(f = new File(this.FUZZER_DIR)).isDirectory()) {
                    LOG.info((Object)("Creating directory " + this.FUZZER_DIR));
                    if (!f.mkdir()) {
                        System.out.println("Failed to create directory " + f.getAbsolutePath());
                    }
                }
                if (!(f = new File(FOLDER_LOCAL_PLUGIN)).isDirectory()) {
                    LOG.info((Object)("Creating directory " + FOLDER_LOCAL_PLUGIN));
                    if (!f.mkdir()) {
                        System.out.println("Failed to create directory " + f.getAbsolutePath());
                    }
                }
                if (!(f = new File(zapHome, FOLDER_FILTER)).isDirectory()) {
                    LOG.info((Object)("Creating directory: " + f.getAbsolutePath()));
                    if (!f.mkdir()) {
                        System.out.println("Failed to create directory " + f.getAbsolutePath());
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Unable to initialize home directory! " + e.getMessage());
                e.printStackTrace(System.err);
                System.exit(1);
            }
            try {
                try {
                    ZapXmlConfiguration config = new ZapXmlConfiguration(this.FILE_CONFIG);
                    config.setAutoSave(false);
                    long ver = config.getLong("version");
                    if (ver == 2005000L || Constant.isDevBuild() || Constant.isDailyBuild()) break block39;
                    LOG.info((Object)("Backing up config file to " + this.FILE_CONFIG + ".bak"));
                    f = new File(this.FILE_CONFIG);
                    try {
                        copier.copy(f, new File(this.FILE_CONFIG + ".bak"));
                    }
                    catch (IOException e) {
                        String msg = "Failed to backup config file " + this.FILE_CONFIG + " to " + this.FILE_CONFIG + ".bak " + e.getMessage();
                        System.err.println(msg);
                        LOG.error((Object)msg, (Throwable)e);
                    }
                    if (ver == 30020013L) {
                        this.upgradeFrom1_1_0(config);
                        this.upgradeFrom1_2_0(config);
                    }
                    if (ver <= 1000000L) {
                        // empty if block
                    }
                    if (ver <= 1001000L) {
                        this.upgradeFrom1_1_0(config);
                    }
                    if (ver <= 1002000L) {
                        this.upgradeFrom1_2_0(config);
                    }
                    if (ver <= 1002001L) {
                        // empty if block
                    }
                    if (ver <= 1003000L) {
                        // empty if block
                    }
                    if (ver <= 1003001L) {
                        // empty if block
                    }
                    if (ver <= 1004001L) {
                        this.upgradeFrom1_4_1(config);
                    }
                    if (ver <= 2000000L) {
                        this.upgradeFrom2_0_0(config);
                    }
                    if (ver <= 2001000L) {
                        // empty if block
                    }
                    if (ver <= 2002000L) {
                        this.upgradeFrom2_2_0(config);
                    }
                    if (ver <= 2003001L) {
                        this.upgradeFrom2_3_1(config);
                    }
                    if (ver <= 2004003L) {
                        this.upgradeFrom2_4_3(config);
                    }
                    if (ver <= 2005000L) {
                        Constant.upgradeFrom2_5_0(config);
                    }
                    LOG.info((Object)("Upgraded from " + ver));
                    config.setProperty("version", 2005000L);
                    config.save();
                }
                catch (NoSuchElementException | ConfigurationException | ConversionException e) {
                    copier.copy(Constant.getPathDefaultConfigFile().toFile(), new File(this.FILE_CONFIG));
                }
            }
            catch (Exception e) {
                System.err.println("Unable to upgrade config file " + this.FILE_CONFIG + " " + e.getMessage());
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }
        Locale locale = Locale.ENGLISH;
        try {
            ZapXmlConfiguration config = new ZapXmlConfiguration(this.FILE_CONFIG);
            config.setAutoSave(false);
            String lang = config.getString("view.locale", "en_GB");
            if (lang.length() == 0) {
                lang = "en_GB";
            }
            String[] langArray = lang.split("_");
            locale = new Locale(langArray[0], langArray[1]);
        }
        catch (Exception e) {
            System.out.println("Failed to initialise locale " + e);
        }
        Locale.setDefault(locale);
        messages = new I18N(locale);
    }

    private void copyProperty(XMLConfiguration fromConfig, XMLConfiguration toConfig, String key) {
        toConfig.setProperty(key, fromConfig.getProperty(key));
    }

    private void copyAllProperties(XMLConfiguration fromConfig, XMLConfiguration toConfig, String prefix) {
        Iterator iter = fromConfig.getKeys(prefix);
        while (iter.hasNext()) {
            String key = (String)iter.next();
            this.copyProperty(fromConfig, toConfig, key);
        }
    }

    private void upgradeFrom1_1_0(XMLConfiguration config) throws ConfigurationException {
        ZapXmlConfiguration newConfig = new ZapXmlConfiguration(Constant.getPathDefaultConfigFile().toFile());
        newConfig.setAutoSave(false);
        this.copyAllProperties(newConfig, config, "pscans");
    }

    private void upgradeFrom1_2_0(XMLConfiguration config) throws ConfigurationException {
        ZapXmlConfiguration newConfig = new ZapXmlConfiguration(Constant.getPathDefaultConfigFile().toFile());
        newConfig.setAutoSave(false);
        this.copyProperty(newConfig, config, "view.editorView");
        this.copyProperty(newConfig, config, "view.brkPanelView");
        this.copyProperty(newConfig, config, "view.showMainToolbar");
    }

    private void upgradeFrom1_4_1(XMLConfiguration config) {
        String elementBaseKey;
        Object[] data;
        String baseKey;
        String host;
        String elementBaseKey2;
        int i;
        if (!config.getProperty("spider.postform").toString().equals("0")) {
            config.setProperty("spider.postform", (Object)"true");
            config.setProperty("spider.processform", (Object)"true");
        } else {
            config.setProperty("spider.postform", (Object)"false");
            config.setProperty("spider.processform", (Object)"false");
        }
        String[] tokens = config.getStringArray("session.tokens");
        for (i = 0; i < tokens.length; ++i) {
            elementBaseKey2 = "httpsessions.tokens.token(" + i + ").";
            config.setProperty(elementBaseKey2 + "name", (Object)tokens[i]);
            config.setProperty(elementBaseKey2 + "enabled", (Object)Boolean.TRUE);
        }
        config.clearTree(FOLDER_SESSION_DEFAULT);
        tokens = config.getStringArray("anticsrf.tokens");
        config.clearTree("anticsrf.tokens");
        for (i = 0; i < tokens.length; ++i) {
            elementBaseKey2 = "anticsrf.tokens.token(" + i + ").";
            config.setProperty(elementBaseKey2 + "name", (Object)tokens[i]);
            config.setProperty(elementBaseKey2 + "enabled", (Object)Boolean.TRUE);
        }
        ArrayList<Object[]> oldData = new ArrayList<Object[]>();
        int i2 = 0;
        while ((host = config.getString((baseKey = "invoke.A" + i2 + ".") + "name")) != null && !USER_AGENT.equals(host)) {
            data = new Object[]{host, config.getString(baseKey + "directory", USER_AGENT), config.getString(baseKey + "command"), config.getString(baseKey + "parameters"), config.getBoolean(baseKey + "output", true), config.getBoolean(baseKey + "note", false)};
            oldData.add(data);
            ++i2;
        }
        config.clearTree("invoke.A");
        int size = oldData.size();
        for (i2 = 0; i2 < size; ++i2) {
            elementBaseKey = "invoke.apps.app(" + i2 + ").";
            data = (Object[])oldData.get(i2);
            config.setProperty(elementBaseKey + "name", data[0]);
            config.setProperty(elementBaseKey + "directory", data[1]);
            config.setProperty(elementBaseKey + "command", data[2]);
            config.setProperty(elementBaseKey + "parameters", data[3]);
            config.setProperty(elementBaseKey + "output", data[4]);
            config.setProperty(elementBaseKey + "note", data[5]);
            config.setProperty(elementBaseKey + "enabled", (Object)Boolean.TRUE);
        }
        oldData = new ArrayList();
        i2 = 0;
        while ((host = config.getString((baseKey = "connection.auth.A" + i2 + ".") + "hostName")) != null && !USER_AGENT.equals(host)) {
            data = new Object[]{host, Integer.valueOf(config.getString(baseKey + "port", "80")), config.getString(baseKey + "userName"), config.getString(baseKey + "password"), config.getString(baseKey + "realm")};
            oldData.add(data);
            ++i2;
        }
        config.clearTree("connection.auth.A");
        size = oldData.size();
        for (i2 = 0; i2 < size; ++i2) {
            elementBaseKey = "connection.auths.auth(" + i2 + ").";
            data = (Object[])oldData.get(i2);
            config.setProperty(elementBaseKey + "name", (Object)("Auth " + i2));
            config.setProperty(elementBaseKey + "hostName", data[0]);
            config.setProperty(elementBaseKey + "port", data[1]);
            config.setProperty(elementBaseKey + "userName", data[2]);
            config.setProperty(elementBaseKey + "password", data[3]);
            config.setProperty(elementBaseKey + "realm", data[4]);
            config.setProperty(elementBaseKey + "enabled", (Object)Boolean.TRUE);
        }
        String[] names = config.getStringArray("pscans.names");
        oldData = new ArrayList();
        for (String pscanName : names) {
            String baseKey2 = "pscans." + pscanName + ".";
            Object[] data2 = new Object[]{pscanName, config.getString(baseKey2 + "type"), config.getString(baseKey2 + "config"), config.getString(baseKey2 + "reqUrlRegex"), config.getString(baseKey2 + "reqHeadRegex"), config.getString(baseKey2 + "resHeadRegex"), config.getString(baseKey2 + "resBodyRegex"), config.getBoolean(baseKey2 + "enabled")};
            oldData.add(data2);
        }
        config.clearTree("pscans.names");
        for (String pscanName : names) {
            config.clearTree("pscans." + pscanName);
        }
        int size2 = oldData.size();
        for (int i3 = 0; i3 < size2; ++i3) {
            String elementBaseKey3 = "pscans.autoTagScanners.scanner(" + i3 + ").";
            Object[] data3 = (Object[])oldData.get(i3);
            config.setProperty(elementBaseKey3 + "name", data3[0]);
            config.setProperty(elementBaseKey3 + "type", data3[1]);
            config.setProperty(elementBaseKey3 + "config", data3[2]);
            config.setProperty(elementBaseKey3 + "reqUrlRegex", data3[3]);
            config.setProperty(elementBaseKey3 + "reqHeadRegex", data3[4]);
            config.setProperty(elementBaseKey3 + "resHeadRegex", data3[5]);
            config.setProperty(elementBaseKey3 + "resBodyRegex", data3[6]);
            config.setProperty(elementBaseKey3 + "enabled", data3[7]);
        }
    }

    private void upgradeFrom2_0_0(XMLConfiguration config) {
        String forcedBrowseFile = config.getString("bruteforce.defaultFile", USER_AGENT);
        if (!USER_AGENT.equals(forcedBrowseFile)) {
            String absolutePath = USER_AGENT;
            File f = new File(this.DIRBUSTER_CUSTOM_DIR + File.separator + forcedBrowseFile);
            if (!f.exists()) {
                f = new File(this.DIRBUSTER_DIR + File.separator + forcedBrowseFile);
            }
            if (f.exists()) {
                absolutePath = f.getAbsolutePath();
            }
            config.setProperty("bruteforce.defaultFile", (Object)absolutePath);
        }
        config.clearTree("nullrequest");
        config.clearTree("nullresponse");
    }

    private void upgradeFrom2_2_0(XMLConfiguration config) {
        try {
            if (!config.getBoolean("start.checkForUpdates", false)) {
                config.setProperty("start.dayLastChecked", (Object)USER_AGENT);
            }
        }
        catch (Exception e) {
            config.setProperty("start.dayLastChecked", (Object)USER_AGENT);
        }
        config.setProperty("addons.block", (Object)USER_AGENT);
    }

    private void upgradeFrom2_3_1(XMLConfiguration config) {
        config.clearProperty("connection.confirmRemoveAuth");
        config.clearTree("options.auth");
    }

    private void upgradeFrom2_4_3(XMLConfiguration config) {
        ArrayList<Object[]> oldData = new ArrayList<Object[]>();
        Iterator it = config.getKeys("ext");
        while (it.hasNext()) {
            String key = (String)it.next();
            Object[] data = new Object[]{key.substring(4), config.getBoolean(key)};
            oldData.add(data);
        }
        config.clearTree("ext");
        int size = oldData.size();
        for (int i = 0; i < size; ++i) {
            String elementBaseKey = "extensions.extension(" + i + ").";
            Object[] data = (Object[])oldData.get(i);
            config.setProperty(elementBaseKey + "name", data[0]);
            config.setProperty(elementBaseKey + "enabled", data[1]);
        }
    }

    private static void upgradeFrom2_5_0(XMLConfiguration config) {
        String oldConfigKey = "proxy.modifyAcceptEncoding";
        config.setProperty("proxy.removeUnsupportedEncodings", (Object)config.getBoolean(oldConfigKey, true));
        config.clearProperty(oldConfigKey);
        HashSet<String> classnames = new HashSet<String>();
        Iterator it = config.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith("pscans.org")) continue;
            classnames.add(key.substring(7, key.lastIndexOf(46)));
        }
        ArrayList<Object[]> oldData = new ArrayList<Object[]>();
        for (String classname : classnames) {
            Object[] data = new Object[]{classname, config.getBoolean("pscans." + classname + ".enabled", true), config.getString("pscans." + classname + ".level", USER_AGENT)};
            oldData.add(data);
        }
        config.clearTree("pscans.org");
        int size = oldData.size();
        for (int i = 0; i < size; ++i) {
            String elementBaseKey = "pscans.pscanner(" + i + ").";
            Object[] data = (Object[])oldData.get(i);
            config.setProperty(elementBaseKey + "classname", data[0]);
            config.setProperty(elementBaseKey + "enabled", data[1]);
            config.setProperty(elementBaseKey + "level", data[2]);
        }
    }

    public static void setLocale(String loc) {
        String[] langArray = loc.split("_");
        Locale locale = new Locale(langArray[0], langArray[1]);
        Locale.setDefault(locale);
        if (messages == null) {
            messages = new I18N(locale);
        } else {
            messages.setLocale(locale);
        }
    }

    public static Locale getLocale() {
        return messages.getLocal();
    }

    public static Locale getSystemsLocale() {
        return SYSTEMS_LOCALE;
    }

    public static Constant getInstance() {
        if (instance == null) {
            Constant.createInstance();
        }
        return instance;
    }

    private static synchronized void createInstance() {
        if (instance == null) {
            instance = new Constant();
        }
    }

    private void setAcceleratorKeys() {
        if (Constant.isMacOsX()) {
            ACCELERATOR_UNDO = "meta Z";
            ACCELERATOR_REDO = "meta shift Z";
            ACCELERATOR_TRIGGER_KEY = "Meta";
        } else {
            ACCELERATOR_UNDO = "control Z";
            ACCELERATOR_REDO = "control Y";
            ACCELERATOR_TRIGGER_KEY = "Control";
        }
    }

    public static boolean isWindows() {
        String os_name = System.getProperty("os.name");
        Matcher matcher = patternWindows.matcher(os_name);
        return matcher.find();
    }

    public static boolean isLinux() {
        String os_name = System.getProperty("os.name");
        Matcher matcher = patternLinux.matcher(os_name);
        return matcher.find();
    }

    public static boolean isMacOsX() {
        String os_name = System.getProperty("os.name");
        Matcher matcher = patternMacOsX.matcher(os_name);
        return matcher.find();
    }

    public static void setZapHome(String dir) {
        zapHome = Constant.getAbsolutePath(dir);
    }

    private static String getAbsolutePath(String directory) {
        String separator;
        String realPath = Paths.get(directory, new String[0]).toAbsolutePath().toString();
        if (!realPath.endsWith(separator = FileSystems.getDefault().getSeparator())) {
            realPath = realPath + separator;
        }
        return realPath;
    }

    public static String getZapHome() {
        return zapHome;
    }

    public static Path getPathDefaultConfigFile() {
        return Paths.get(Constant.getZapInstall(), "xml", FILE_CONFIG_NAME);
    }

    public static File getContextsDir() {
        File f = new File(Constant.getZapHome(), USER_CONTEXTS_DIR);
        if (!f.exists()) {
            f.mkdirs();
        }
        if (f.isDirectory() && f.canWrite()) {
            return f;
        }
        return Model.getSingleton().getOptionsParam().getUserDirectory();
    }

    public static File getPoliciesDir() {
        File f = new File(Constant.getZapHome(), USER_POLICIES_DIR);
        if (!f.exists()) {
            f.mkdirs();
        }
        if (f.isDirectory() && f.canWrite()) {
            return f;
        }
        return Model.getSingleton().getOptionsParam().getUserDirectory();
    }

    public static void setZapInstall(String dir) {
        zapInstall = Constant.getAbsolutePath(dir);
    }

    public static String getZapInstall() {
        if (zapInstall == null) {
            String path = ".";
            Path localDir = Paths.get(path, new String[0]);
            if (!Files.isDirectory(localDir.resolve("db"), new LinkOption[0]) || !Files.isDirectory(localDir.resolve(LANG_DIR), new LinkOption[0])) {
                path = ZAP.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                System.out.println("Defaulting ZAP install dir to " + path);
            }
            if (path.startsWith("/") && path.indexOf(":") > 0) {
                path = path.substring(1);
            }
            zapInstall = Constant.getAbsolutePath(path);
        }
        return zapInstall;
    }

    private static Manifest getManifest() {
        String className = Constant.class.getSimpleName() + ".class";
        String classPath = Constant.class.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return null;
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        try {
            return new Manifest(new URL(manifestPath).openStream());
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getVersionFromManifest() {
        Manifest manifest = Constant.getManifest();
        if (manifest != null) {
            Attributes attr = manifest.getMainAttributes();
            return attr.getValue("Implementation-Version");
        }
        return DEV_VERSION;
    }

    public static Date getReleaseCreateDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Manifest manifest = Constant.getManifest();
        if (manifest != null) {
            Attributes attr = manifest.getMainAttributes();
            try {
                return sdf.parse(attr.getValue("Create-Date"));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Date getInstallDate() {
        File f;
        String className = Constant.class.getSimpleName() + ".class";
        String classPath = Constant.class.getResource(className).toString();
        if (!classPath.startsWith("jar:file:")) {
            return null;
        }
        int ind = (classPath = classPath.substring(9)).indexOf("!");
        if (ind > 0) {
            classPath = classPath.substring(0, ind);
        }
        if ((f = new File(classPath)).exists()) {
            return new Date(f.getParentFile().lastModified());
        }
        return null;
    }

    public static boolean isDevBuild() {
        return Constant.isDevBuild(PROGRAM_VERSION);
    }

    public static boolean isDevBuild(String version) {
        return DEV_VERSION.equals(version);
    }

    public static boolean isDailyBuild(String version) {
        return version.startsWith("D-");
    }

    public static boolean isDailyBuild() {
        return Constant.isDailyBuild(PROGRAM_VERSION);
    }

    public static void setLowMemoryOption(boolean lowMem) {
        if (lowMemoryOption != null) {
            throw new InvalidParameterException("Low memory option already set to " + lowMemoryOption);
        }
        lowMemoryOption = lowMem;
    }

    public static boolean isLowMemoryOptionSet() {
        return lowMemoryOption != null && lowMemoryOption != false;
    }

    public static boolean isKali() {
        block17: {
            if (onKali == null) {
                onKali = Boolean.FALSE;
                File osReleaseFile = new File("/etc/os-release");
                if (Constant.isLinux() && !Constant.isDailyBuild() && osReleaseFile.exists()) {
                    try (InputStream in = Files.newInputStream(osReleaseFile.toPath(), new OpenOption[0]);){
                        String[] oSLikes;
                        Properties osProps = new Properties();
                        osProps.load(in);
                        String osLikeValue = osProps.getProperty("ID");
                        if (osLikeValue == null) break block17;
                        for (String osLike : oSLikes = osLikeValue.split(" ")) {
                            if (!osLike.toLowerCase().equals("kali")) continue;
                            onKali = Boolean.TRUE;
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return onKali;
    }
}

