/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.FileConfiguration;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.extension.httppanel.HttpPanel;
import org.zaproxy.zap.extension.httppanel.component.HttpPanelComponentInterface;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelDefaultViewSelector;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelView;

public class HttpPanelManager {
    private static HttpPanelManager instance = null;
    private HttpPanelManagement requestPanels = new HttpPanelManagement();
    private HttpPanelManagement responsePanels = new HttpPanelManagement();

    private HttpPanelManager() {
    }

    public static HttpPanelManager getInstance() {
        if (instance == null) {
            HttpPanelManager.createInstance();
        }
        return instance;
    }

    private static synchronized void createInstance() {
        if (instance == null) {
            instance = new HttpPanelManager();
        }
    }

    public void addRequestPanel(HttpPanel panel) {
        this.requestPanels.addPanel(panel);
    }

    public void addRequestComponentFactory(HttpPanelComponentFactory componentFactory) {
        this.requestPanels.addComponentFactory(componentFactory);
    }

    public void addRequestViewFactory(String componentName, HttpPanelViewFactory viewFactory) {
        this.requestPanels.addViewFactory(componentName, viewFactory);
    }

    public void addRequestDefaultViewSelectorFactory(String componentName, HttpPanelDefaultViewSelectorFactory defaultViewSelectorFactory) {
        this.requestPanels.addDefaultViewSelectorFactory(componentName, defaultViewSelectorFactory);
    }

    public void addResponsePanel(HttpPanel panel) {
        this.responsePanels.addPanel(panel);
    }

    public void addResponseComponentFactory(HttpPanelComponentFactory componentFactory) {
        this.responsePanels.addComponentFactory(componentFactory);
    }

    public void addResponseViewFactory(String componentName, HttpPanelViewFactory viewFactory) {
        this.responsePanels.addViewFactory(componentName, viewFactory);
    }

    public void addResponseDefaultViewSelectorFactory(String componentName, HttpPanelDefaultViewSelectorFactory defaultViewSelectorFactory) {
        this.responsePanels.addDefaultViewSelectorFactory(componentName, defaultViewSelectorFactory);
    }

    public void removeRequestPanel(HttpPanel panel) {
        this.requestPanels.removePanel(panel);
    }

    public void removeRequestComponentFactory(String componentFactoryName) {
        this.requestPanels.removeComponentFactory(componentFactoryName);
    }

    public void removeRequestComponents(String componentName) {
        this.requestPanels.removeComponents(componentName);
    }

    public void removeRequestViewFactory(String componentName, String viewFactoryName) {
        this.requestPanels.removeViewFactory(componentName, viewFactoryName);
    }

    public void removeRequestViews(String componentName, String viewName, Object options) {
        this.requestPanels.removeViews(componentName, viewName, options);
    }

    public void removeRequestDefaultViewSelectorFactory(String componentName, String defaultViewSelectorFactoryName) {
        this.requestPanels.removeDefaultViewSelectorFactory(componentName, defaultViewSelectorFactoryName);
    }

    public void removeRequestDefaultViewSelectorFactoryAndDefaultViewSelectorsAdded(String componentName, String defaultViewSelectorName, Object options) {
        this.requestPanels.removeDefaultViewSelectors(componentName, defaultViewSelectorName, options);
    }

    public void removeResponsePanel(HttpPanel panel) {
        this.responsePanels.removePanel(panel);
    }

    public void removeResponseComponentFactory(String componentFactoryName) {
        this.responsePanels.removeComponentFactory(componentFactoryName);
    }

    public void removeResponseComponents(String componentName) {
        this.responsePanels.removeComponents(componentName);
    }

    public void removeResponseViewFactory(String componentName, String viewFactoryName) {
        this.responsePanels.removeViewFactory(componentName, viewFactoryName);
    }

    public void removeResponseViews(String componentName, String viewName, Object options) {
        this.responsePanels.removeViews(componentName, viewName, options);
    }

    public void removeResponseDefaultViewSelectorFactory(String componentName, String defaultViewSelectorFactoryName) {
        this.responsePanels.removeDefaultViewSelectorFactory(componentName, defaultViewSelectorFactoryName);
    }

    public void removeResponseDefaultViewSelectors(String componentName, String defaultViewSelectorName, Object options) {
        this.responsePanels.removeDefaultViewSelectors(componentName, defaultViewSelectorName, options);
    }

    public static interface HttpPanelDefaultViewSelectorFactory {
        public String getName();

        public HttpPanelDefaultViewSelector getNewDefaultViewSelector();

        public Object getOptions();
    }

    public static interface HttpPanelViewFactory {
        public String getName();

        public HttpPanelView getNewView();

        public Object getOptions();
    }

    public static interface HttpPanelComponentFactory {
        public String getName();

        public String getComponentName();

        public HttpPanelComponentInterface getNewComponent();
    }

    private static final class HttpPanelManagement {
        private List<HttpPanel> panels = new ArrayList<HttpPanel>();
        private Map<String, HttpPanelComponentFactory> components = new HashMap<String, HttpPanelComponentFactory>();
        private Map<String, Map<String, HttpPanelViewFactory>> views = new HashMap<String, Map<String, HttpPanelViewFactory>>();
        private Map<String, Map<String, HttpPanelDefaultViewSelectorFactory>> defaultViews = new HashMap<String, Map<String, HttpPanelDefaultViewSelectorFactory>>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPanel(HttpPanel panel) {
            HttpPanelManagement httpPanelManagement = this;
            synchronized (httpPanelManagement) {
                this.panels.add(panel);
                FileConfiguration fileConfiguration = Model.getSingleton().getOptionsParam().getConfig();
                for (HttpPanelComponentFactory httpPanelComponentFactory : this.components.values()) {
                    panel.addComponent(httpPanelComponentFactory.getNewComponent(), fileConfiguration);
                }
                for (Map.Entry entry : this.views.entrySet()) {
                    for (Object viewFactory : ((Map)entry.getValue()).values()) {
                        panel.addView((String)entry.getKey(), viewFactory.getNewView(), viewFactory.getOptions(), fileConfiguration);
                    }
                }
                for (Map.Entry entry : this.defaultViews.entrySet()) {
                    for (Object viewFactory : ((Map)entry.getValue()).values()) {
                        panel.addDefaultViewSelector((String)entry.getKey(), viewFactory.getNewDefaultViewSelector(), viewFactory.getOptions());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removePanel(HttpPanel panel) {
            HttpPanelManagement httpPanelManagement = this;
            synchronized (httpPanelManagement) {
                this.panels.remove(panel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addComponentFactory(HttpPanelComponentFactory componentFactory) {
            HttpPanelManagement httpPanelManagement = this;
            synchronized (httpPanelManagement) {
                if (this.components.containsKey(componentFactory.getName())) {
                    return;
                }
                this.components.put(componentFactory.getName(), componentFactory);
                FileConfiguration fileConfiguration = Model.getSingleton().getOptionsParam().getConfig();
                for (HttpPanel panel : this.panels) {
                    Map<String, HttpPanelDefaultViewSelectorFactory> defaultViewsComp;
                    panel.addComponent(componentFactory.getNewComponent(), fileConfiguration);
                    String componentName = componentFactory.getComponentName();
                    Map<String, HttpPanelViewFactory> componentViews = this.views.get(componentName);
                    if (componentViews != null) {
                        for (HttpPanelViewFactory viewFactory : componentViews.values()) {
                            panel.addView(componentName, viewFactory.getNewView(), viewFactory.getOptions(), fileConfiguration);
                        }
                    }
                    if ((defaultViewsComp = this.defaultViews.get(componentName)) == null) continue;
                    for (HttpPanelDefaultViewSelectorFactory defaultViewSelector : defaultViewsComp.values()) {
                        panel.addDefaultViewSelector(componentName, defaultViewSelector.getNewDefaultViewSelector(), defaultViewSelector.getOptions());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeComponentFactory(String componentFactoryName) {
            HttpPanelManagement httpPanelManagement = this;
            synchronized (httpPanelManagement) {
                this.components.remove(componentFactoryName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeComponents(String componentName) {
            HttpPanelManagement httpPanelManagement = this;
            synchronized (httpPanelManagement) {
                for (HttpPanel panel : this.panels) {
                    panel.removeComponent(componentName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addViewFactory(String componentName, HttpPanelViewFactory viewFactory) {
            HttpPanelManagement httpPanelManagement = this;
            synchronized (httpPanelManagement) {
                Map<String, HttpPanelViewFactory> componentViews = this.views.get(componentName);
                if (componentViews == null) {
                    componentViews = new HashMap<String, HttpPanelViewFactory>();
                    this.views.put(componentName, componentViews);
                } else if (this.views.containsKey(viewFactory.getName())) {
                    return;
                }
                componentViews.put(viewFactory.getName(), viewFactory);
                FileConfiguration fileConfiguration = Model.getSingleton().getOptionsParam().getConfig();
                for (HttpPanel panel : this.panels) {
                    panel.addView(componentName, viewFactory.getNewView(), viewFactory.getOptions(), fileConfiguration);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeViewFactory(String componentName, String viewFactoryName) {
            HttpPanelManagement httpPanelManagement = this;
            synchronized (httpPanelManagement) {
                Map<String, HttpPanelViewFactory> componentViews = this.views.get(componentName);
                if (componentViews == null) {
                    return;
                }
                HttpPanelViewFactory viewFactory = componentViews.get(viewFactoryName);
                if (viewFactory == null) {
                    return;
                }
                componentViews.remove(viewFactoryName);
                if (componentViews.isEmpty()) {
                    this.views.put(componentName, null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeViews(String componentName, String viewName, Object options) {
            HttpPanelManagement httpPanelManagement = this;
            synchronized (httpPanelManagement) {
                for (HttpPanel panel : this.panels) {
                    panel.removeView(componentName, viewName, options);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDefaultViewSelectorFactory(String componentName, HttpPanelDefaultViewSelectorFactory defaultViewSelectorFactory) {
            HttpPanelManagement httpPanelManagement = this;
            synchronized (httpPanelManagement) {
                Map<String, HttpPanelDefaultViewSelectorFactory> componentDefaultViews = this.defaultViews.get(componentName);
                if (componentDefaultViews == null) {
                    componentDefaultViews = new HashMap<String, HttpPanelDefaultViewSelectorFactory>();
                    this.defaultViews.put(componentName, componentDefaultViews);
                } else if (this.views.containsKey(defaultViewSelectorFactory.getName())) {
                    return;
                }
                componentDefaultViews.put(defaultViewSelectorFactory.getName(), defaultViewSelectorFactory);
                for (HttpPanel panel : this.panels) {
                    panel.addDefaultViewSelector(componentName, defaultViewSelectorFactory.getNewDefaultViewSelector(), defaultViewSelectorFactory.getOptions());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeDefaultViewSelectorFactory(String componentName, String viewFactoryName) {
            HttpPanelManagement httpPanelManagement = this;
            synchronized (httpPanelManagement) {
                Map<String, HttpPanelDefaultViewSelectorFactory> componentDefaultViews = this.defaultViews.get(componentName);
                if (componentDefaultViews == null) {
                    return;
                }
                HttpPanelDefaultViewSelectorFactory viewFactory = componentDefaultViews.get(viewFactoryName);
                if (viewFactory == null) {
                    return;
                }
                componentDefaultViews.remove(viewFactoryName);
                if (componentDefaultViews.isEmpty()) {
                    this.defaultViews.put(componentName, null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeDefaultViewSelectors(String componentName, String defaultViewSelectorName, Object options) {
            HttpPanelManagement httpPanelManagement = this;
            synchronized (httpPanelManagement) {
                for (HttpPanel panel : this.panels) {
                    panel.removeDefaultViewSelector(componentName, defaultViewSelectorName, options);
                }
            }
        }
    }
}

