/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.LayoutHelper;

public class DynamicFieldsPanel
extends JPanel {
    private static final long serialVersionUID = -1129326656062554952L;
    private String[] requiredFields;
    private String[] optionalFields;
    private Map<String, ZapTextField> textFields;

    public DynamicFieldsPanel(String[] requiredFields) {
        this(requiredFields, new String[0]);
    }

    public DynamicFieldsPanel(String[] requiredFields, String[] optionalFields) {
        this.requiredFields = requiredFields;
        this.optionalFields = optionalFields;
        this.textFields = new HashMap<String, ZapTextField>(requiredFields.length + optionalFields.length);
        this.initialize();
    }

    private void initialize() {
        ZapTextField tf;
        this.setLayout(new GridBagLayout());
        int fieldIndex = 0;
        for (String fieldName : this.requiredFields) {
            this.add((Component)new JLabel("* " + fieldName + ": "), LayoutHelper.getGBC(0, fieldIndex, 1, 0.0, 0.0));
            tf = new ZapTextField();
            this.add((Component)tf, LayoutHelper.getGBC(1, fieldIndex, 1, 1.0, 0.0));
            this.textFields.put(fieldName, tf);
            ++fieldIndex;
        }
        for (String fieldName : this.optionalFields) {
            this.add((Component)new JLabel(fieldName + ": "), LayoutHelper.getGBC(0, fieldIndex, 1, 0.0, 0.0));
            tf = new ZapTextField();
            this.add((Component)tf, LayoutHelper.getGBC(1, fieldIndex, 1, 1.0, 0.0));
            this.textFields.put(fieldName, tf);
            ++fieldIndex;
        }
    }

    public Map<String, String> getFieldValues() {
        HashMap<String, String> values = new HashMap<String, String>(this.requiredFields.length + this.optionalFields.length);
        for (Map.Entry<String, ZapTextField> f : this.textFields.entrySet()) {
            values.put(f.getKey(), f.getValue().getText());
        }
        return values;
    }

    public void bindFieldValues(Map<String, String> fieldValues) {
        for (Map.Entry<String, ZapTextField> f : this.textFields.entrySet()) {
            if (fieldValues.containsKey(f.getKey())) {
                f.getValue().setText(fieldValues.get(f.getKey()));
                continue;
            }
            f.getValue().setText("");
        }
    }

    public void validateFields() throws IllegalStateException {
        for (String rf : this.requiredFields) {
            if (!this.textFields.get(rf).getText().trim().isEmpty()) continue;
            this.textFields.get(rf).requestFocusInWindow();
            throw new IllegalStateException(Constant.messages.getString("authentication.method.script.dialog.error.text.required", rf));
        }
    }
}

