/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SortOrder;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.ParameterParser;
import org.zaproxy.zap.model.StandardParameterParser;
import org.zaproxy.zap.model.StructuralNodeModifier;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.AbstractMultipleOptionsBaseTablePanel;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.StandardFieldsDialog;
import org.zaproxy.zap.view.StructuralNodeModifiersTableModel;

public class ContextStructurePanel
extends AbstractContextPropertiesPanel {
    private static final String PANEL_NAME = Constant.messages.getString("context.struct.title");
    private static final long serialVersionUID = -1L;
    private StructuralNodeModifiersTableModel ddnTableModel;
    private JPanel panelSession = null;
    private ZapTextField urlKvPairSeparators = null;
    private ZapTextField urlKeyValueSeparators = null;
    private ZapTextField postKeyValueSeparators = null;
    private ZapTextField postKvPairSeparators = null;

    public static String getPanelName(int contextId) {
        return contextId + ": " + PANEL_NAME;
    }

    public ContextStructurePanel(Context context) {
        super(context.getIndex());
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(ContextStructurePanel.getPanelName(this.getContextIndex()));
        this.add((Component)this.getPanel(), this.getPanel().getName());
    }

    private JPanel getPanel() {
        if (this.panelSession == null) {
            this.panelSession = new JPanel();
            this.panelSession.setLayout(new GridBagLayout());
            this.panelSession.setName("SessionStructure");
            this.panelSession.setLayout(new GridBagLayout());
            this.panelSession.add((Component)new JLabel(Constant.messages.getString("context.struct.label.url.kvpsep")), LayoutHelper.getGBC(0, 0, 1, 1.0));
            this.panelSession.add((Component)this.getUrlKvPairSeparators(), LayoutHelper.getGBC(1, 0, 1, 1.0, new Insets(2, 0, 2, 0)));
            this.panelSession.add((Component)new JLabel(Constant.messages.getString("context.struct.label.url.kvsep")), LayoutHelper.getGBC(0, 1, 1, 1.0));
            this.panelSession.add((Component)this.getUrlKeyValueSeparators(), LayoutHelper.getGBC(1, 1, 1, 1.0, new Insets(2, 0, 2, 0)));
            this.panelSession.add((Component)new JLabel(Constant.messages.getString("context.struct.label.post.kvpsep")), LayoutHelper.getGBC(0, 2, 1, 1.0));
            this.panelSession.add((Component)this.getPostKvPairSeparators(), LayoutHelper.getGBC(1, 2, 1, 1.0, new Insets(2, 0, 2, 0)));
            this.panelSession.add((Component)new JLabel(Constant.messages.getString("context.struct.label.post.kvsep")), LayoutHelper.getGBC(0, 3, 1, 1.0));
            this.panelSession.add((Component)this.getPostKeyValueSeparators(), LayoutHelper.getGBC(1, 3, 1, 1.0, new Insets(2, 0, 2, 0)));
            this.panelSession.add((Component)new JLabel(Constant.messages.getString("context.struct.label.struct")), LayoutHelper.getGBC(0, 4, 1, 1.0));
            this.ddnTableModel = new StructuralNodeModifiersTableModel();
            DataDrivenNodesMultipleOptionsPanel ddnOptionsPanel = new DataDrivenNodesMultipleOptionsPanel(this.ddnTableModel);
            this.panelSession.add((Component)ddnOptionsPanel, LayoutHelper.getGBC(0, 5, 2, 1.0, 1.0));
        }
        return this.panelSession;
    }

    private ZapTextField getUrlKvPairSeparators() {
        if (this.urlKvPairSeparators == null) {
            this.urlKvPairSeparators = new ZapTextField();
        }
        return this.urlKvPairSeparators;
    }

    private ZapTextField getUrlKeyValueSeparators() {
        if (this.urlKeyValueSeparators == null) {
            this.urlKeyValueSeparators = new ZapTextField();
        }
        return this.urlKeyValueSeparators;
    }

    private ZapTextField getPostKeyValueSeparators() {
        if (this.postKeyValueSeparators == null) {
            this.postKeyValueSeparators = new ZapTextField();
        }
        return this.postKeyValueSeparators;
    }

    private ZapTextField getPostKvPairSeparators() {
        if (this.postKvPairSeparators == null) {
            this.postKvPairSeparators = new ZapTextField();
        }
        return this.postKvPairSeparators;
    }

    @Override
    public void initContextData(Session session, Context context) {
        ParameterParser urlParamParser = context.getUrlParamParser();
        ParameterParser formParamParser = context.getPostParamParser();
        this.ddnTableModel.setStructuralNodeModifiers(context.getDataDrivenNodes());
        if (urlParamParser instanceof StandardParameterParser) {
            StandardParameterParser urlStdParamParser = (StandardParameterParser)urlParamParser;
            this.getUrlKvPairSeparators().setText(urlStdParamParser.getKeyValuePairSeparators());
            this.getUrlKeyValueSeparators().setText(urlStdParamParser.getKeyValueSeparators());
            for (String structParam : urlStdParamParser.getStructuralParameters()) {
                this.ddnTableModel.addStructuralNodeModifier(new StructuralNodeModifier(StructuralNodeModifier.Type.StructuralParameter, null, structParam));
            }
        }
        if (formParamParser instanceof StandardParameterParser) {
            StandardParameterParser formStdParamParser = (StandardParameterParser)formParamParser;
            this.getPostKvPairSeparators().setText(formStdParamParser.getKeyValuePairSeparators());
            this.getPostKeyValueSeparators().setText(formStdParamParser.getKeyValueSeparators());
        }
    }

    @Override
    public void validateContextData(Session session) throws Exception {
        if (this.urlKvPairSeparators.getText().length() == 0) {
            throw new IllegalArgumentException(Constant.messages.getString("context.struct.warning.stdparser.nokvpsep"));
        }
        if (this.urlKeyValueSeparators.getText().length() == 0) {
            throw new IllegalArgumentException(Constant.messages.getString("context.struct.warning.stdparser.nokvsep"));
        }
        for (char ch : this.urlKvPairSeparators.getText().toCharArray()) {
            if (!this.urlKeyValueSeparators.getText().contains("" + ch)) continue;
            throw new IllegalArgumentException(Constant.messages.getString("context.struct.warning.stdparser.dup"));
        }
        if (this.postKvPairSeparators.getText().length() == 0) {
            throw new IllegalArgumentException(Constant.messages.getString("context.struct.warning.stdparser.nokvpsep"));
        }
        if (this.postKeyValueSeparators.getText().length() == 0) {
            throw new IllegalArgumentException(Constant.messages.getString("context.struct.warning.stdparser.nokvsep"));
        }
        for (char ch : this.postKvPairSeparators.getText().toCharArray()) {
            if (!this.postKeyValueSeparators.getText().contains("" + ch)) continue;
            throw new IllegalArgumentException(Constant.messages.getString("context.struct.warning.stdparser.dup"));
        }
    }

    private void saveToContext(Context context, boolean updateSiteStructure) {
        ParameterParser urlParamParser = context.getUrlParamParser();
        ParameterParser formParamParser = context.getPostParamParser();
        ArrayList<String> structParams = new ArrayList<String>();
        ArrayList<StructuralNodeModifier> ddns = new ArrayList<StructuralNodeModifier>();
        for (StructuralNodeModifier snm : this.ddnTableModel.getElements()) {
            if (snm.getType().equals((Object)StructuralNodeModifier.Type.StructuralParameter)) {
                structParams.add(snm.getName());
                continue;
            }
            ddns.add(snm);
        }
        if (urlParamParser instanceof StandardParameterParser) {
            StandardParameterParser urlStdParamParser = (StandardParameterParser)urlParamParser;
            urlStdParamParser.setKeyValuePairSeparators(this.getUrlKvPairSeparators().getText());
            urlStdParamParser.setKeyValueSeparators(this.getUrlKeyValueSeparators().getText());
            urlStdParamParser.setStructuralParameters(structParams);
            context.setUrlParamParser(urlStdParamParser);
            urlStdParamParser.setContext(context);
        }
        if (formParamParser instanceof StandardParameterParser) {
            StandardParameterParser formStdParamParser = (StandardParameterParser)formParamParser;
            formStdParamParser.setKeyValuePairSeparators(this.getPostKvPairSeparators().getText());
            formStdParamParser.setKeyValueSeparators(this.getPostKeyValueSeparators().getText());
            context.setPostParamParser(formStdParamParser);
            formStdParamParser.setContext(context);
        }
        context.setDataDrivenNodes(ddns);
        if (updateSiteStructure) {
            context.restructureSiteTree();
        }
    }

    @Override
    public void saveContextData(Session session) throws Exception {
        Context context = session.getContext(this.getContextIndex());
        this.saveToContext(context, true);
    }

    @Override
    public void saveTemporaryContextData(Context uiSharedContext) {
        this.saveToContext(uiSharedContext, false);
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.context-struct";
    }

    public static class StructuralModifierDialog
    extends StandardFieldsDialog {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_TYPE = "context.ddn.dialog.type";
        private static final String FIELD_NAME = "context.ddn.dialog.name";
        private static final String FIELD_REGEX = "context.ddn.dialog.regex";
        private static final String VALUE_TYPE_DATA = "context.ddn.dialog.type.data";
        private static final String VALUE_TYPE_STRUCT = "context.ddn.dialog.type.struct";
        private StructuralNodeModifier.Type type = StructuralNodeModifier.Type.StructuralParameter;
        private StructuralNodeModifier ddn = null;
        private boolean ro = false;

        public StructuralModifierDialog(JDialog owner, String titleLabel, Dimension dim) {
            super((Window)owner, titleLabel, dim, true);
        }

        public StructuralNodeModifier showDialog(StructuralNodeModifier ddn) {
            String regex = "";
            String name = "";
            this.ddn = ddn;
            if (ddn != null) {
                this.type = ddn.getType();
                if (ddn.getPattern() != null) {
                    regex = ddn.getPattern().pattern();
                }
                name = ddn.getName();
                this.ro = true;
                this.addReadOnlyField(FIELD_NAME, this.getModVal(this.type), false);
            } else {
                this.addComboField(FIELD_TYPE, new String[]{Constant.messages.getString(VALUE_TYPE_STRUCT), Constant.messages.getString(VALUE_TYPE_DATA)}, this.getModVal(this.type));
                this.addFieldListener(FIELD_TYPE, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        StructuralModifierDialog.this.setFieldStates();
                    }
                });
            }
            this.addTextField(FIELD_NAME, name);
            this.addTextField(FIELD_REGEX, regex);
            this.setFieldStates();
            this.setVisible(true);
            return this.ddn;
        }

        private void setFieldStates() {
            if (!this.ro) {
                this.type = Constant.messages.getString(VALUE_TYPE_STRUCT).equals(this.getStringValue(FIELD_TYPE)) ? StructuralNodeModifier.Type.StructuralParameter : StructuralNodeModifier.Type.DataDrivenNode;
            }
            this.getField(FIELD_REGEX).setEnabled(StructuralNodeModifier.Type.DataDrivenNode.equals((Object)this.type));
        }

        private String getModVal(StructuralNodeModifier.Type type) {
            switch (type) {
                case StructuralParameter: {
                    return Constant.messages.getString(VALUE_TYPE_STRUCT);
                }
                case DataDrivenNode: {
                    return Constant.messages.getString(VALUE_TYPE_DATA);
                }
            }
            return "";
        }

        @Override
        public void save() {
            this.ddn = new StructuralNodeModifier(this.type, Pattern.compile(this.getStringValue(FIELD_REGEX)), this.getStringValue(FIELD_NAME));
        }

        @Override
        public String validateFields() {
            if (!this.getStringValue(FIELD_NAME).matches("[A-Za-z0-9]+")) {
                return Constant.messages.getString("context.ddn.dialog.error.name");
            }
            if (StructuralNodeModifier.Type.DataDrivenNode.equals((Object)this.type)) {
                if (this.isEmptyField(FIELD_REGEX)) {
                    return Constant.messages.getString("context.ddn.dialog.error.regex");
                }
                if (!this.getStringValue(FIELD_REGEX).matches(".*\\(.*\\).*\\(.*\\).*")) {
                    return Constant.messages.getString("context.ddn.dialog.error.regex");
                }
                try {
                    Pattern.compile(this.getStringValue(FIELD_REGEX));
                }
                catch (Exception e) {
                    return Constant.messages.getString("context.ddn.dialog.error.regex");
                }
            }
            return null;
        }
    }

    public static class DataDrivenNodesMultipleOptionsPanel
    extends AbstractMultipleOptionsBaseTablePanel<StructuralNodeModifier> {
        private static final long serialVersionUID = -7216673905642941770L;
        private static final String REMOVE_DIALOG_TITLE = Constant.messages.getString("context.ddn.dialog.remove.title");
        private static final String REMOVE_DIALOG_TEXT = Constant.messages.getString("context.ddn.dialog.remove.text");
        private static final String REMOVE_DIALOG_CONFIRM_BUTTON_LABEL = Constant.messages.getString("all.button.remove");
        private static final String REMOVE_DIALOG_CANCEL_BUTTON_LABEL = Constant.messages.getString("all.button.cancel");
        private static final String REMOVE_DIALOG_CHECKBOX_LABEL = Constant.messages.getString("all.prompt.dontshow");

        public DataDrivenNodesMultipleOptionsPanel(StructuralNodeModifiersTableModel model) {
            super(model);
            this.getTable().getColumnExt(0).setPreferredWidth(50);
            this.getTable().getColumnExt(1).setPreferredWidth(50);
            this.getTable().getColumnExt(2).setPreferredWidth(200);
            this.getTable().setSortOrder(1, SortOrder.ASCENDING);
        }

        @Override
        public StructuralNodeModifier showAddDialogue() {
            StructuralModifierDialog ddnDialog = new StructuralModifierDialog(View.getSingleton().getSessionDialog(), "context.ddn.dialog.add.title", new Dimension(500, 200));
            return ddnDialog.showDialog(null);
        }

        @Override
        public StructuralNodeModifier showModifyDialogue(StructuralNodeModifier ddn) {
            StructuralModifierDialog ddnDialog = new StructuralModifierDialog(View.getSingleton().getSessionDialog(), "context.ddn.dialog.modify.title", new Dimension(500, 200));
            return ddnDialog.showDialog(ddn);
        }

        @Override
        public boolean showRemoveDialogue(StructuralNodeModifier e) {
            JCheckBox removeWithoutConfirmationCheckBox = new JCheckBox(REMOVE_DIALOG_CHECKBOX_LABEL);
            Object[] messages = new Object[]{REMOVE_DIALOG_TEXT, " ", removeWithoutConfirmationCheckBox};
            int option = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), messages, REMOVE_DIALOG_TITLE, 2, 3, null, new String[]{REMOVE_DIALOG_CONFIRM_BUTTON_LABEL, REMOVE_DIALOG_CANCEL_BUTTON_LABEL}, null);
            if (option == 0) {
                this.setRemoveWithoutConfirmation(removeWithoutConfirmationCheckBox.isSelected());
                return true;
            }
            return false;
        }
    }
}

