/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.SingleColumnTableModel;

public class ContextExcludePanel
extends AbstractContextPropertiesPanel {
    private static final String PANEL_NAME = Constant.messages.getString("context.scope.exclude.title");
    private static final long serialVersionUID = -8337361808959321380L;
    private JPanel panelSession = null;
    private JTable tableIgnore = null;
    private JScrollPane jScrollPane = null;
    private SingleColumnTableModel model = null;

    public static String getPanelName(int contextIndex) {
        return contextIndex + ": " + PANEL_NAME;
    }

    @Deprecated
    public static String getPanelName(Context context) {
        return ContextExcludePanel.getPanelName(context.getIndex());
    }

    public ContextExcludePanel(Context context) {
        super(context.getIndex());
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(ContextExcludePanel.getPanelName(this.getContextIndex()));
        this.add((Component)this.getPanelSession(), this.getPanelSession().getName());
    }

    private JPanel getPanelSession() {
        if (this.panelSession == null) {
            this.panelSession = new JPanel();
            this.panelSession.setLayout(new GridBagLayout());
            this.panelSession.setName("ExcludeFromScope");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            JLabel jLabel = new JLabel();
            jLabel.setText(Constant.messages.getString("context.label.exclude"));
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.gridheight = 1;
            gridBagConstraints1.insets = new Insets(10, 0, 5, 0);
            gridBagConstraints1.anchor = 18;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.weightx = 0.0;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.ipadx = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.anchor = 18;
            this.panelSession.add((Component)jLabel, gridBagConstraints1);
            this.panelSession.add((Component)this.getJScrollPane(), gridBagConstraints2);
        }
        return this.panelSession;
    }

    private JTable getTableIgnore() {
        if (this.tableIgnore == null) {
            this.tableIgnore = new JTable();
            this.tableIgnore.setModel(this.getModel());
            this.tableIgnore.setRowHeight(DisplayUtils.getScaledSize(18));
            this.tableIgnore.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        }
        return this.tableIgnore;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getTableIgnore());
            this.jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        }
        return this.jScrollPane;
    }

    private SingleColumnTableModel getModel() {
        if (this.model == null) {
            this.model = new SingleColumnTableModel(Constant.messages.getString("context.table.header.exclude"));
        }
        return this.model;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.contexts";
    }

    @Override
    public void initContextData(Session session, Context uiContext) {
        this.getModel().setLines(uiContext.getExcludeFromContextRegexs());
    }

    @Override
    public void validateContextData(Session session) throws Exception {
        for (String regex : this.getModel().getLines()) {
            if (regex.trim().length() <= 0) continue;
            Pattern.compile(regex.trim(), 2);
        }
    }

    @Override
    public void saveContextData(Session session) throws Exception {
        Context context = session.getContext(this.getContextIndex());
        context.setExcludeFromContextRegexs(this.getModel().getLines());
    }

    @Override
    public void saveTemporaryContextData(Context uiSharedContext) {
        try {
            uiSharedContext.setExcludeFromContextRegexs(this.getModel().getLines());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

