/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import org.zaproxy.zap.utils.DisplayUtils;

public class BackgroundImagePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private BufferedImage img;

    public BackgroundImagePanel() {
        this.img = null;
    }

    public BackgroundImagePanel(URL imageUrl) {
        this.setBackgroundImage(imageUrl);
    }

    public final void setBackgroundImage(URL imageUrl) {
        if (imageUrl != null) {
            try {
                this.img = ImageIO.read(imageUrl);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.img != null) {
            this.setOpaque(false);
            g.drawImage(this.img, 0, 0, DisplayUtils.getScaledSize(this.img.getWidth()), DisplayUtils.getScaledSize(this.img.getHeight()), null);
        }
        super.paintComponent(g);
    }
}

