/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.apache.log4j.Logger;

public final class HttpUserAgent {
    private static Logger logger = Logger.getLogger(HttpUserAgent.class);
    public static final String FireFox = "firefox";
    public static final String InternetExplorer = "internet explorer";
    private static final String MSIE = "msie";
    public static final String Chrome = "chrome";
    public static final String Safari = "safari";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String searchForInternetExplorerVersion(String userAgent) {
        String line = null;
        String UserAgentListFile = "xml/internet-explorer-user-agents.txt";
        String browserVersion = "";
        BufferedReader reader = null;
        userAgent = userAgent.toLowerCase();
        try {
            reader = new BufferedReader(new FileReader(UserAgentListFile));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) {
                    browserVersion = line.substring(2, line.length() - 1);
                    continue;
                }
                if (!line.toLowerCase().equals(userAgent)) continue;
                String string = browserVersion;
                return string;
            }
        }
        catch (IOException e) {
            logger.debug((Object)("Error on opening/reading IE user agent file. Error:" + e.getMessage()));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.debug((Object)("Error on closing reader file. Error:" + e.getMessage()));
                }
            }
        }
        return "-1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String searchForFirefoxVersion(String userAgent) {
        String line = null;
        String UserAgentListFile = "xml/firefox-user-agents.txt";
        String browserVersion = "";
        BufferedReader reader = null;
        userAgent = userAgent.toLowerCase();
        try {
            reader = new BufferedReader(new FileReader(UserAgentListFile));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) {
                    browserVersion = line.substring(2, line.length() - 1);
                    continue;
                }
                if (!line.toLowerCase().equals(userAgent)) continue;
                String string = browserVersion;
                return string;
            }
        }
        catch (IOException e) {
            logger.debug((Object)("Error on opening/reading Firefox user agent file. Error:" + e.getMessage()));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.debug((Object)("Error on closing reader file. Error:" + e.getMessage()));
                }
            }
        }
        return "-1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String searchForChromeVersion(String userAgent) {
        String line = null;
        String UserAgentListFile = "xml/chrome-user-agents.txt";
        String browserVersion = "";
        BufferedReader reader = null;
        userAgent = userAgent.toLowerCase();
        try {
            reader = new BufferedReader(new FileReader(UserAgentListFile));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) {
                    browserVersion = line.substring(2, line.length() - 1);
                    continue;
                }
                if (!line.toLowerCase().equals(userAgent)) continue;
                String string = browserVersion;
                return string;
            }
        }
        catch (IOException e) {
            logger.debug((Object)("Error on opening/reading Chrome user agent file. Error:" + e.getMessage()));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.debug((Object)("Error on closing reader file. Error:" + e.getMessage()));
                }
            }
        }
        return "-1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String searchForSafariVersion(String userAgent) {
        String line = null;
        String UserAgentListFile = "xml/safari-user-agents.txt";
        String browserVersion = "";
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(UserAgentListFile));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) {
                    browserVersion = line.substring(2, line.length() - 1);
                    continue;
                }
                if (!line.toLowerCase().equals(userAgent)) continue;
                String string = browserVersion;
                return string;
            }
        }
        catch (IOException e) {
            logger.debug((Object)("Error on opening/reading Safari user agent file. Error:" + e.getMessage()));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.debug((Object)("Error on closing reader file. Error:" + e.getMessage()));
                }
            }
        }
        return "-1";
    }

    public static String getBrowser(String userAgent) {
        if (userAgent.toLowerCase().contains(FireFox)) {
            return FireFox;
        }
        if (userAgent.toLowerCase().contains(MSIE)) {
            return InternetExplorer;
        }
        if (userAgent.toLowerCase().contains(Chrome) || userAgent.toLowerCase().contains(Chrome) && userAgent.toLowerCase().contains(Safari)) {
            return Chrome;
        }
        if (userAgent.toLowerCase().contains(Safari)) {
            return Safari;
        }
        return "-1";
    }

    public static String getBrowserVersion(String userAgent) {
        if (userAgent.toLowerCase().contains(FireFox)) {
            return HttpUserAgent.searchForFirefoxVersion(userAgent);
        }
        if (userAgent.toLowerCase().contains(MSIE)) {
            return HttpUserAgent.searchForInternetExplorerVersion(userAgent);
        }
        if (userAgent.toLowerCase().contains(Chrome) || userAgent.toLowerCase().contains(Chrome) && userAgent.toLowerCase().contains(Safari)) {
            return HttpUserAgent.searchForChromeVersion(userAgent);
        }
        if (userAgent.toLowerCase().contains(Safari)) {
            return HttpUserAgent.searchForSafariVersion(userAgent);
        }
        return "-1";
    }
}

