/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.utils.FontUtils;

public class DisplayUtils {
    private static List<Image> zapIconImages;
    private static Boolean scaleImages;
    private static final int STD_HEIGHT = 16;

    private static boolean isScaleImages() {
        if (scaleImages == null) {
            scaleImages = Model.getSingleton().getOptionsParam().getViewParam().isScaleImages();
        }
        return scaleImages;
    }

    public static ImageIcon getScaledIcon(ImageIcon icon) {
        if (!DisplayUtils.isScaleImages() || icon == null || FontUtils.getScale() == 1.0f || icon.getIconHeight() > 16) {
            return icon;
        }
        return new ImageIcon(icon.getImage().getScaledInstance((int)((float)icon.getIconWidth() * FontUtils.getScale()), (int)((float)icon.getIconHeight() * FontUtils.getScale()), 4));
    }

    public static Icon getScaledIcon(Icon icon) {
        if (!DisplayUtils.isScaleImages() || icon == null || FontUtils.getScale() == 1.0f || !(icon instanceof ImageIcon)) {
            return icon;
        }
        return DisplayUtils.getScaledIcon((ImageIcon)icon);
    }

    public static Dimension getScaledDimension(int width, int height) {
        if (FontUtils.getScale() == 1.0f) {
            return new Dimension(width, height);
        }
        return new Dimension((int)((float)width * FontUtils.getScale()), (int)((float)height * FontUtils.getScale()));
    }

    public static int getScaledSize(int size) {
        return (int)((float)size * FontUtils.getScale());
    }

    public static void scaleIcon(JLabel label) {
        if (DisplayUtils.isScaleImages() && label != null && label.getIcon() != null && label.getIcon() instanceof ImageIcon) {
            label.setIcon(DisplayUtils.getScaledIcon((ImageIcon)label.getIcon()));
        }
    }

    public static void scaleIcon(JButton button) {
        if (DisplayUtils.isScaleImages() && button != null && button.getIcon() != null && button.getIcon() instanceof ImageIcon) {
            button.setIcon(DisplayUtils.getScaledIcon((ImageIcon)button.getIcon()));
        }
    }

    public static void scaleIcon(JToggleButton button) {
        if (DisplayUtils.isScaleImages() && button != null) {
            if (button.getIcon() != null && button.getIcon() instanceof ImageIcon) {
                button.setIcon(DisplayUtils.getScaledIcon((ImageIcon)button.getIcon()));
            }
            if (button.getSelectedIcon() != null && button.getSelectedIcon() instanceof ImageIcon) {
                button.setSelectedIcon(DisplayUtils.getScaledIcon((ImageIcon)button.getSelectedIcon()));
            }
            if (button.getRolloverIcon() != null && button.getRolloverIcon() instanceof ImageIcon) {
                button.setRolloverIcon(DisplayUtils.getScaledIcon((ImageIcon)button.getRolloverIcon()));
            }
            if (button.getRolloverSelectedIcon() != null && button.getRolloverSelectedIcon() instanceof ImageIcon) {
                button.setRolloverSelectedIcon(DisplayUtils.getScaledIcon((ImageIcon)button.getRolloverSelectedIcon()));
            }
            if (button.getDisabledIcon() != null && button.getDisabledIcon() instanceof ImageIcon) {
                button.setDisabledIcon(DisplayUtils.getScaledIcon((ImageIcon)button.getDisabledIcon()));
            }
            if (button.getDisabledSelectedIcon() != null && button.getDisabledSelectedIcon() instanceof ImageIcon) {
                button.setDisabledSelectedIcon(DisplayUtils.getScaledIcon((ImageIcon)button.getDisabledSelectedIcon()));
            }
            if (button.getPressedIcon() != null && button.getPressedIcon() instanceof ImageIcon) {
                button.setPressedIcon(DisplayUtils.getScaledIcon((ImageIcon)button.getPressedIcon()));
            }
        }
    }

    public static List<Image> getZapIconImages() {
        if (zapIconImages == null) {
            DisplayUtils.createZapIconImages();
        }
        return zapIconImages;
    }

    private static synchronized void createZapIconImages() {
        if (zapIconImages == null) {
            ArrayList<Image> images = new ArrayList<Image>(8);
            images.add(Toolkit.getDefaultToolkit().getImage(DisplayUtils.class.getResource("/resource/zap16x16.png")));
            images.add(Toolkit.getDefaultToolkit().getImage(DisplayUtils.class.getResource("/resource/zap32x32.png")));
            images.add(Toolkit.getDefaultToolkit().getImage(DisplayUtils.class.getResource("/resource/zap48x48.png")));
            images.add(Toolkit.getDefaultToolkit().getImage(DisplayUtils.class.getResource("/resource/zap64x64.png")));
            images.add(Toolkit.getDefaultToolkit().getImage(DisplayUtils.class.getResource("/resource/zap128x128.png")));
            images.add(Toolkit.getDefaultToolkit().getImage(DisplayUtils.class.getResource("/resource/zap256x256.png")));
            images.add(Toolkit.getDefaultToolkit().getImage(DisplayUtils.class.getResource("/resource/zap512x512.png")));
            images.add(Toolkit.getDefaultToolkit().getImage(DisplayUtils.class.getResource("/resource/zap1024x1024.png")));
            zapIconImages = Collections.unmodifiableList(images);
        }
    }

    static {
        scaleImages = null;
    }
}

