/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.List;
import net.htmlparser.jericho.Source;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.zaproxy.zap.spider.Spider;
import org.zaproxy.zap.spider.filters.ParseFilter;
import org.zaproxy.zap.spider.parser.SpiderParser;

public class SpiderTask
implements Runnable {
    private Spider parent;
    private HistoryReference reference;
    private int depth;
    private ExtensionHistory extHistory = null;
    private static final Logger log = Logger.getLogger(SpiderTask.class);

    public SpiderTask(Spider parent, URI uri, int depth, String method) {
        this(parent, null, uri, depth, method, null);
    }

    public SpiderTask(Spider parent, URI sourceUri, URI uri, int depth, String method) {
        this(parent, sourceUri, uri, depth, method, null);
    }

    public SpiderTask(Spider parent, URI uri, int depth, String method, String requestBody) {
        this(parent, null, uri, depth, method, requestBody);
    }

    public SpiderTask(Spider parent, URI sourceUri, URI uri, int depth, String method, String requestBody) {
        this.parent = parent;
        this.depth = depth;
        if (log.isDebugEnabled()) {
            log.debug((Object)("New task submitted for uri: " + uri));
        }
        try {
            HttpRequestHeader requestHeader = new HttpRequestHeader(method, uri, "HTTP/1.1", parent.getConnectionParam());
            if (sourceUri != null && parent.getSpiderParam().isSendRefererHeader()) {
                requestHeader.setHeader("Referer", sourceUri.toString());
            }
            HttpMessage msg = new HttpMessage(requestHeader);
            if (requestBody != null) {
                msg.getRequestHeader().setContentLength(requestBody.length());
                msg.setRequestBody(requestBody);
            }
            this.reference = new HistoryReference(parent.getModel().getSession(), 9, msg);
        }
        catch (HttpMalformedHeaderException e) {
            log.error((Object)("Error while building HttpMessage for uri: " + uri), (Throwable)e);
        }
        catch (DatabaseException e) {
            log.error((Object)("Error while persisting HttpMessage for uri: " + uri), (Throwable)e);
        }
    }

    @Override
    public void run() {
        if (this.reference == null) {
            log.warn((Object)("Null URI. Skipping crawling task: " + this));
            this.parent.postTaskExecution();
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Spider Task Started. Processing uri at depth " + this.depth + " using already constructed message:  " + this.reference.getURI()));
        }
        if (this.parent.isStopped()) {
            log.debug((Object)"Spider process is stopped. Skipping crawling task...");
            this.deleteHistoryReference();
            this.parent.postTaskExecution();
            return;
        }
        this.parent.preTaskExecution();
        HttpMessage msg = null;
        try {
            msg = this.fetchResource();
        }
        catch (ConnectException e) {
            this.parent.postTaskExecution();
            return;
        }
        catch (SocketTimeoutException e) {
            this.parent.postTaskExecution();
            return;
        }
        catch (SocketException e) {
            this.parent.postTaskExecution();
            return;
        }
        catch (UnknownHostException e) {
            this.parent.postTaskExecution();
            return;
        }
        catch (Exception e) {
            log.error((Object)("An error occured while fetching the resource: " + e.getMessage()), (Throwable)e);
            this.parent.postTaskExecution();
            return;
        }
        if (this.parent.isStopped()) {
            log.debug((Object)"Spider process is stopped. Skipping crawling task...");
            this.parent.postTaskExecution();
            return;
        }
        this.parent.checkPauseAndWait();
        boolean isFiltered = false;
        for (ParseFilter filter : this.parent.getController().getParseFilters()) {
            if (!filter.isFiltered(msg)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource fetched, but will not be parsed due to a ParseFilter rule: " + msg.getRequestHeader().getURI()));
            }
            isFiltered = true;
            break;
        }
        if (!isFiltered) {
            this.parent.notifyListenersReadURI(msg);
        }
        if (this.parent.isStopped()) {
            log.debug((Object)"Spider process is stopped. Skipping crawling task...");
            this.parent.postTaskExecution();
            return;
        }
        this.parent.checkPauseAndWait();
        if (!isFiltered && this.depth < this.parent.getSpiderParam().getMaxDepth()) {
            this.processResource(msg);
        }
        this.parent.postTaskExecution();
        log.debug((Object)"Spider Task finished.");
    }

    private void deleteHistoryReference() {
        if (this.reference == null) {
            return;
        }
        if (this.getExtensionHistory() != null) {
            this.getExtensionHistory().delete(this.reference);
            this.reference = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResource(HttpMessage message) {
        List<SpiderParser> parsers = this.parent.getController().getParsers();
        Source source = new Source((CharSequence)message.getResponseBody().toString());
        String path = null;
        try {
            path = message.getRequestHeader().getURI().getPath();
        }
        catch (URIException uRIException) {
        }
        finally {
            if (path == null) {
                path = "";
            }
        }
        boolean alreadyConsumed = false;
        for (SpiderParser parser : parsers) {
            if (parser.canParseResource(message, path, alreadyConsumed)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Parser " + parser + " can parse resource '" + path + "'"));
                }
                if (!parser.parseResource(message, source, this.depth)) continue;
                alreadyConsumed = true;
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Parser " + parser + " cannot parse resource '" + path + "'"));
        }
    }

    private ExtensionHistory getExtensionHistory() {
        if (this.extHistory == null) {
            this.extHistory = (ExtensionHistory)Control.getSingleton().getExtensionLoader().getExtension("ExtensionHistory");
        }
        return this.extHistory;
    }

    private HttpMessage fetchResource() throws HttpException, IOException, DatabaseException {
        HttpMessage msg;
        try {
            msg = this.reference.getHttpMessage();
        }
        finally {
            this.deleteHistoryReference();
        }
        msg.getRequestHeader().setHeader("If-Modified-Since", null);
        msg.getRequestHeader().setHeader("If-None-Match", null);
        if (this.parent.getSpiderParam().getUserAgent() != null) {
            msg.getRequestHeader().setHeader("User-Agent", this.parent.getSpiderParam().getUserAgent());
        }
        if (this.parent.getScanUser() != null) {
            msg.setRequestingUser(this.parent.getScanUser());
        }
        if (this.parent.getHttpSender() != null) {
            try {
                this.parent.getHttpSender().sendAndReceive(msg);
            }
            catch (ConnectException e) {
                log.debug((Object)("Failed to connect to: " + msg.getRequestHeader().getURI()), (Throwable)e);
                throw e;
            }
            catch (SocketTimeoutException e) {
                log.debug((Object)("Socket timeout: " + msg.getRequestHeader().getURI()), (Throwable)e);
                throw e;
            }
            catch (SocketException e) {
                log.debug((Object)("Socket exception: " + msg.getRequestHeader().getURI()), (Throwable)e);
                throw e;
            }
            catch (UnknownHostException e) {
                log.debug((Object)("Unknown host: " + msg.getRequestHeader().getURI()), (Throwable)e);
                throw e;
            }
        }
        return msg;
    }

    void cleanup() {
        this.deleteHistoryReference();
    }
}

