/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.zaproxy.zap.model.Vulnerability;
import org.zaproxy.zap.utils.LocaleUtils;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

public class VulnerabilitiesLoader {
    private static final Logger logger = Logger.getLogger(VulnerabilitiesLoader.class);
    private final Path directory;
    private final String fileName;
    private final String fileExtension;

    public VulnerabilitiesLoader(Path directory, String fileName, String fileExtension) {
        Validate.notNull((Object)directory, (String)"Parameter directory must not be null.");
        Validate.notEmpty((String)fileName, (String)"Parameter fileName must not be null nor empty.");
        Validate.notEmpty((String)fileExtension, (String)"Parameter fileExtension must not be null nor empty.");
        this.directory = directory;
        this.fileName = fileName;
        this.fileExtension = fileExtension;
    }

    public List<Vulnerability> load(Locale locale) {
        List<String> filenames = this.getListOfVulnerabilitiesFiles();
        for (Locale candidateLocale : this.getCandidateLocales(locale)) {
            List<Vulnerability> list;
            String candidateFilename = this.createFilename(candidateLocale);
            if (!filenames.contains(candidateFilename)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("loading vulnerabilities from " + candidateFilename + " for locale " + locale + "."));
            }
            if ((list = this.loadVulnerabilitiesFile(this.directory.resolve(candidateFilename))) == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<Locale> getCandidateLocales(Locale locale) {
        return ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_DEFAULT).getCandidateLocales(this.fileName, locale);
    }

    private String createFilename(Locale locale) {
        StringBuilder resourceBuilder = new StringBuilder(this.fileName);
        String strLocale = locale.toString();
        if (!strLocale.isEmpty()) {
            resourceBuilder.append('_').append(locale);
        }
        resourceBuilder.append(this.fileExtension);
        return resourceBuilder.toString();
    }

    private List<Vulnerability> loadVulnerabilitiesFile(Path file) {
        String[] test;
        ZapXmlConfiguration config;
        try {
            config = new ZapXmlConfiguration(file.toFile());
        }
        catch (ConfigurationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        try {
            test = config.getStringArray("vuln_items");
        }
        catch (ConversionException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        int numberOfVulns = test.length;
        ArrayList<Vulnerability> tempVulns = new ArrayList<Vulnerability>(numberOfVulns);
        for (String item : test) {
            ArrayList<String> references;
            String name = "vuln_item_" + item;
            try {
                references = new ArrayList<String>(Arrays.asList(config.getStringArray(name + ".reference")));
            }
            catch (ConversionException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                references = new ArrayList(0);
            }
            Vulnerability v = new Vulnerability(item, config.getString(name + ".alert"), config.getString(name + ".desc"), config.getString(name + ".solution"), references);
            tempVulns.add(v);
        }
        return tempVulns;
    }

    private List<String> getListOfVulnerabilitiesFiles() {
        final Pattern filePattern = LocaleUtils.createResourceFilesPattern(this.fileName, this.fileExtension);
        final ArrayList<String> fileNames = new ArrayList<String>();
        try {
            Files.walkFileTree(this.directory, Collections.emptySet(), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String fileName = file.getFileName().toString();
                    if (filePattern.matcher(fileName).matches()) {
                        fileNames.add(fileName);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            logger.error((Object)("An error occurred while walking directory: " + this.directory), (Throwable)e);
        }
        return fileNames;
    }
}

