/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.model.HttpMessageLocation;
import org.zaproxy.zap.model.MessageLocation;
import org.zaproxy.zap.model.TextHttpMessageLocation;

public class DefaultTextHttpMessageLocation
implements TextHttpMessageLocation {
    private final HttpMessageLocation.Location location;
    private final int start;
    private final int end;
    private final String value;

    public DefaultTextHttpMessageLocation(HttpMessageLocation.Location location, int position) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location must not be null");
        }
        if (position < 0) {
            throw new IllegalArgumentException("Parameter position must be greater or equal to zero.");
        }
        this.location = location;
        this.start = position;
        this.end = position;
        this.value = "";
    }

    public DefaultTextHttpMessageLocation(HttpMessageLocation.Location location, int start, int end, String value) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location must not be null");
        }
        if (start < 0) {
            throw new IllegalArgumentException("Parameter start must be greater or equal to zero.");
        }
        if (end < 0) {
            throw new IllegalArgumentException("Parameter end must be greater or equal to zero.");
        }
        if (start > end) {
            throw new IllegalArgumentException("Parameter end must be greater than start.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value must not be null.");
        }
        this.location = location;
        this.start = start;
        this.end = end;
        this.value = value;
    }

    @Override
    public HttpMessageLocation.Location getLocation() {
        return this.location;
    }

    public Class<HttpMessage> getTargetMessageClass() {
        return HttpMessage.class;
    }

    @Override
    public String getDescription() {
        StringBuffer description = new StringBuffer(25);
        switch (this.location) {
            case REQUEST_HEADER: 
            case RESPONSE_HEADER: {
                description.append(Constant.messages.getString("messagelocation.http.text.location.header"));
                break;
            }
            case REQUEST_BODY: 
            case RESPONSE_BODY: {
                description.append(Constant.messages.getString("messagelocation.http.text.location.body"));
                break;
            }
            default: {
                description.append(Constant.messages.getString("messagelocation.http.text.location.unknown"));
            }
        }
        description.append(" [").append(this.start);
        if (this.start != this.end) {
            description.append(", ").append(this.end);
        }
        description.append(']');
        return description.toString();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public boolean overlaps(MessageLocation otherLocation) {
        if (!(otherLocation instanceof HttpMessageLocation)) {
            return true;
        }
        HttpMessageLocation otherHttpMessageLocation = (HttpMessageLocation)otherLocation;
        if (this.location != otherHttpMessageLocation.getLocation()) {
            return false;
        }
        if (!(otherHttpMessageLocation instanceof TextHttpMessageLocation)) {
            return true;
        }
        TextHttpMessageLocation otherTextLocation = (TextHttpMessageLocation)otherHttpMessageLocation;
        if (this.start == otherTextLocation.getStart()) {
            return this.start == this.end ? this.end == otherTextLocation.getEnd() : false;
        }
        if (this.start < otherTextLocation.getStart()) {
            return this.end > otherTextLocation.getStart();
        }
        return this.start < otherTextLocation.getEnd();
    }

    @Override
    public int compareTo(MessageLocation otherLocation) {
        if (!(otherLocation instanceof HttpMessageLocation)) {
            return 1;
        }
        HttpMessageLocation otherHttpMessageLocation = (HttpMessageLocation)otherLocation;
        if (this.location != otherHttpMessageLocation.getLocation()) {
            if (this.location.ordinal() > otherHttpMessageLocation.getLocation().ordinal()) {
                return 1;
            }
            if (this.location.ordinal() < otherHttpMessageLocation.getLocation().ordinal()) {
                return -1;
            }
        }
        if (!(otherHttpMessageLocation instanceof TextHttpMessageLocation)) {
            return 1;
        }
        TextHttpMessageLocation otherTextLocation = (TextHttpMessageLocation)otherHttpMessageLocation;
        if (this.start > otherTextLocation.getStart()) {
            return 1;
        }
        if (this.start < otherTextLocation.getStart()) {
            return -1;
        }
        if (this.end > otherTextLocation.getEnd()) {
            return 1;
        }
        if (this.end < otherTextLocation.getEnd()) {
            return -1;
        }
        int result = this.value.compareTo(otherHttpMessageLocation.getValue());
        if (result != 0) {
            return result;
        }
        return otherHttpMessageLocation instanceof DefaultTextHttpMessageLocation ? 0 : 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.end;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + this.start;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultTextHttpMessageLocation other = (DefaultTextHttpMessageLocation)obj;
        if (this.end != other.end) {
            return false;
        }
        if (this.location != other.location) {
            return false;
        }
        if (this.start != other.start) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

