/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.stdmenus;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.stdmenus.PopupUserMenu;
import org.zaproxy.zap.extension.users.ContextUserAuthManager;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.view.messagecontainer.MessageContainer;
import org.zaproxy.zap.view.popup.ExtensionPopupMenuMessageContainer;

public abstract class PopupUserMenuItemHolder
extends ExtensionPopupMenuMessageContainer {
    private static final long serialVersionUID = 4454384312614225721L;
    private String parentName;
    private List<ExtensionPopupMenuItem> subMenuItems = null;
    private boolean visibleItself;
    private ExtensionUserManagement extensionUserAuth;

    public PopupUserMenuItemHolder(String label, String parentName) {
        super(label);
        this.parentName = parentName;
        this.visibleItself = true;
        this.extensionUserAuth = (ExtensionUserManagement)Control.getSingleton().getExtensionLoader().getExtension("ExtensionUserManagement");
        if (this.extensionUserAuth == null || !this.extensionUserAuth.isEnabled()) {
            Logger.getLogger(PopupUserMenuItemHolder.class).warn((Object)(ExtensionUserManagement.class + " is not enabled but is required for getting info about Users."));
            this.extensionUserAuth = null;
        }
    }

    public PopupUserMenuItemHolder(String parentName) {
        super("UserMenuItemHolder");
        this.parentName = parentName;
        this.visibleItself = false;
    }

    @Override
    public String getParentMenuName() {
        return this.parentName;
    }

    @Override
    public int getParentMenuIndex() {
        return 0;
    }

    @Override
    public boolean isSubMenu() {
        return true;
    }

    private List<ExtensionPopupMenuItem> getSubmenuItems() {
        if (this.subMenuItems == null) {
            this.subMenuItems = new ArrayList<ExtensionPopupMenuItem>();
        }
        return this.subMenuItems;
    }

    @Override
    public boolean isEnableForMessageContainer(MessageContainer<?> invoker) {
        this.resetMenu();
        if (this.extensionUserAuth == null) {
            return false;
        }
        if (this.visibleItself) {
            return super.isEnableForMessageContainer(invoker);
        }
        return false;
    }

    private void resetMenu() {
        Vector<JMenuItem> mainPopupMenuItems = View.getSingleton().getPopupList();
        if (this.visibleItself) {
            this.removeAll();
        } else {
            for (ExtensionPopupMenuItem menu : this.getSubmenuItems()) {
                mainPopupMenuItems.remove(menu);
            }
            this.subMenuItems.clear();
        }
        Session session = Model.getSingleton().getSession();
        List<Context> contexts = session.getContexts();
        for (Context context : contexts) {
            ContextUserAuthManager manager = this.extensionUserAuth.getContextUserAuthManager(context.getIndex());
            for (User user : manager.getUsers()) {
                PopupUserMenu piicm;
                if (this.visibleItself) {
                    piicm = this.getPopupUserMenu(context, user, this.getText());
                    this.add(piicm);
                    continue;
                }
                piicm = this.getPopupUserMenu(context, user, this.parentName);
                piicm.setMenuIndex(this.getMenuIndex());
                mainPopupMenuItems.add(piicm);
                this.subMenuItems.add(piicm);
            }
        }
    }

    public abstract PopupUserMenu getPopupUserMenu(Context var1, User var2, String var3);
}

