/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.parosproxy.paros.model.HistoryReference;
import org.zaproxy.zap.extension.search.SearchResult;
import org.zaproxy.zap.extension.search.SearchResultsTableModel;
import org.zaproxy.zap.view.table.HistoryReferencesTable;

public class SearchResultsTable
extends HistoryReferencesTable {
    private static final long serialVersionUID = -2227731336800996073L;

    public SearchResultsTable(SearchResultsTableModel resultsModel) {
        super(resultsModel, false);
        this.setAutoScrollOnNewValues(false);
    }

    public SearchResult getSelectedSearchResult() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow != -1) {
            SearchResultsTableModel.SearchResultTableEntry entry = (SearchResultsTableModel.SearchResultTableEntry)this.getModel().getEntry(this.convertRowIndexToModel(selectedRow));
            if (entry != null) {
                return entry.getSearchResult();
            }
            return null;
        }
        return null;
    }

    @Override
    public List<HistoryReference> getSelectedHistoryReferences() {
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<HistoryReference> uniqueHistoryReferences = new ArrayList<HistoryReference>(selectedRows.length);
        TreeSet<Integer> historyReferenceIdsAdded = new TreeSet<Integer>();
        for (int selectedRow : selectedRows) {
            Integer id;
            HistoryReference historyReference = this.getHistoryReferenceAtViewRow(selectedRow);
            if (historyReference == null || historyReferenceIdsAdded.contains(id = Integer.valueOf(historyReference.getHistoryId()))) continue;
            historyReferenceIdsAdded.add(id);
            uniqueHistoryReferences.add(historyReference);
        }
        uniqueHistoryReferences.trimToSize();
        return uniqueHistoryReferences;
    }
}

